/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakSet<T>
implements Set<T> {
    WeakHashMap<T, Object> under = new WeakHashMap();
    private static final Object EMPTY = new Object();

    @Override
    public boolean add(T e) {
        return this.under.put(e, EMPTY) == null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean any = false;
        for (T e : c) {
            any |= this.add(e);
        }
        return any;
    }

    @Override
    public void clear() {
        this.under.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.under.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.under.containsKey(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.under.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<Map.Entry<T, Object>> it;
            {
                this.it = WeakSet.this.under.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return this.it.next().getKey();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.under.remove(o) == EMPTY;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean any = false;
        for (Object e : c) {
            any |= this.remove(e);
        }
        return any;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean any = false;
        Iterator<Map.Entry<T, Object>> it = this.under.entrySet().iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            any = true;
        }
        return any;
    }

    @Override
    public int size() {
        return this.under.size();
    }

    @Override
    public Object[] toArray() {
        return this.under.keySet().toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.under.keySet().toArray(a);
    }
}

