/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds.interfaces;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.EntityFz;
import factorization.util.SpaceUtil;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class IDeltaChunk
extends EntityFz {
    protected String partName = "";
    protected IDCController controller = IDCController.default_controller;

    public IDeltaChunk(World w) {
        super(w);
    }

    public abstract void setParent(IDeltaChunk var1);

    public abstract IDeltaChunk getParent();

    public abstract Vec3 getParentJoint();

    public abstract List<IDeltaChunk> getChildren();

    public abstract Quaternion getRotation();

    public abstract Vec3 getRotationalCenterOffset();

    public abstract Quaternion getRotationalVelocity();

    public abstract void setRotation(Quaternion var1);

    public abstract void setRotationalVelocity(Quaternion var1);

    public abstract void orderTargetRotation(Quaternion var1, int var2, Interpolation var3);

    public abstract boolean hasOrderedRotation();

    public abstract int getRemainingRotationTime();

    public abstract void cancelOrderedRotation();

    public abstract Quaternion getOrderedRotationTarget();

    public Quaternion getEventualRotation() {
        if (this.hasOrderedRotation()) {
            return this.getOrderedRotationTarget();
        }
        return this.getRotation();
    }

    public abstract void setRotationalCenterOffset(Vec3 var1);

    public void changeRotationCenter(Vec3 newCenter) {
        Vec3 origCenter = this.getRotationalCenterOffset();
        Vec3 shadowCenter = this.real2shadow(newCenter);
        Coord min = this.getCorner();
        shadowCenter.field_72450_a -= (double)min.x;
        shadowCenter.field_72448_b -= (double)min.y;
        shadowCenter.field_72449_c -= (double)min.z;
        this.setRotationalCenterOffset(shadowCenter);
        Vec3 ds = origCenter.func_72444_a(shadowCenter);
        ds.field_72450_a += this.field_70165_t;
        ds.field_72448_b += this.field_70163_u;
        ds.field_72449_c += this.field_70161_v;
        this.func_70107_b(ds.field_72450_a, ds.field_72448_b, ds.field_72449_c);
    }

    public void multiplyParentRotations(Quaternion rot) {
        for (IDeltaChunk parent = this.getParent(); parent != null; parent = parent.getParent()) {
            parent.getRotation().incrToOtherMultiply(rot);
        }
    }

    public abstract boolean can(DeltaCapability var1);

    public abstract IDeltaChunk permit(DeltaCapability var1);

    public abstract IDeltaChunk forbid(DeltaCapability var1);

    public IDeltaChunk permit(DeltaCapability ... caps) {
        for (DeltaCapability cap : caps) {
            this.permit(cap);
        }
        return this;
    }

    public IDeltaChunk forbid(DeltaCapability ... caps) {
        for (DeltaCapability cap : caps) {
            this.forbid(cap);
        }
        return this;
    }

    public void loadUsualCapabilities() {
        for (DeltaCapability cap : DeltaCapability.values()) {
            this.forbid(cap);
        }
        for (DeltaCapability cap : new DeltaCapability[]{DeltaCapability.COLLIDE, DeltaCapability.MOVE, DeltaCapability.ROTATE, DeltaCapability.DRAG, DeltaCapability.REMOVE_EXTERIOR_ENTITIES, DeltaCapability.INTERACT, DeltaCapability.BLOCK_PLACE, DeltaCapability.BLOCK_MINE, DeltaCapability.REMOVE_ITEM_ENTITIES, DeltaCapability.ENTITY_PHYSICS}) {
            this.permit(cap);
        }
    }

    public abstract Vec3 real2shadow(Vec3 var1);

    public abstract Vec3 shadow2real(Vec3 var1);

    @Deprecated
    public abstract void real2shadow(Coord var1);

    @Deprecated
    public abstract void shadow2real(Coord var1);

    public Coord shadow2realCoord(Coord realCoord) {
        Coord ret = realCoord.copy();
        this.shadow2real(ret);
        return ret;
    }

    public Coord shadow2realCoordPrecise(Coord real) {
        Vec3 r = real.toVector();
        r.field_72450_a += 0.5;
        r.field_72448_b += 0.5;
        r.field_72449_c += 0.5;
        Vec3 s = this.shadow2real(r);
        return new Coord(this.field_70170_p, (int)Math.floor(s.field_72450_a), (int)Math.floor(s.field_72448_b), (int)Math.floor(s.field_72449_c));
    }

    public Coord real2shadowCoord(Coord realCoord) {
        Coord ret = realCoord.copy();
        this.real2shadow(ret);
        return ret;
    }

    public abstract AxisAlignedBB shadow2real(AxisAlignedBB var1);

    public abstract AxisAlignedBB real2shadow(AxisAlignedBB var1);

    public ForgeDirection shadow2real(ForgeDirection dir) {
        Vec3 v = SpaceUtil.fromDirection(dir);
        this.getRotation().applyRotation(v);
        return SpaceUtil.round(v, ForgeDirection.UNKNOWN);
    }

    public ForgeDirection real2shadow(ForgeDirection dir) {
        Vec3 v = SpaceUtil.fromDirection(dir);
        this.getRotation().applyReverseRotation(v);
        return SpaceUtil.round(v, ForgeDirection.UNKNOWN);
    }

    public abstract Coord getCorner();

    public Coord getCenter() {
        return this.getCorner().center(this.getFarCorner());
    }

    public abstract Coord getFarCorner();

    public void setPartName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.partName = name;
    }

    public String toString() {
        String ret = this.partName != null && !this.partName.isEmpty() ? "[DSE " + this.partName + " " + this.func_145782_y() + "]" : super.toString() + " - from " + this.getCorner() + "  to  " + this.getFarCorner() + "   center at " + this.getRotationalCenterOffset();
        if (this.getParent() != null) {
            ret = ret + ":PARENT=" + this.getParent().func_145782_y();
        }
        ret = ret + " " + (int)this.field_70165_t + " " + (int)this.field_70163_u + " " + (int)this.field_70161_v;
        return ret;
    }

    public IDCController getController() {
        return this.controller;
    }

    public void setController(IDCController controller) {
        if (controller == null) {
            controller = IDCController.default_controller;
        }
        this.controller = controller;
    }

    public void func_70016_h(double vx, double vy, double vz) {
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
    }

    public void setVelocity(Vec3 v) {
        this.func_70016_h(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public abstract void findAnyCollidingBox();
}

