/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds.interfaces;

public enum Interpolation {
    CONSTANT{

        @Override
        public double scale(double t) {
            if (t >= 1.0) {
                return 1.0;
            }
            return 0.0;
        }
    }
    ,
    LINEAR{

        @Override
        public double scale(double t) {
            return t;
        }
    }
    ,
    SMOOTH{

        @Override
        public double scale(double t) {
            return t * t * (3.0 - 2.0 * t);
        }
    }
    ,
    SMOOTHER{

        @Override
        public double scale(double t) {
            return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
        }
    }
    ,
    SQUARE{

        @Override
        public double scale(double t) {
            return t * t;
        }
    }
    ,
    INV_SQUARE{

        @Override
        public double scale(double t) {
            t = 1.0 - t;
            return 1.0 - t * t;
        }
    }
    ,
    CUBIC{

        @Override
        public double scale(double t) {
            return t * t * t;
        }
    }
    ,
    INV_CUBIC{

        @Override
        public double scale(double t) {
            t = 1.0 - t;
            return 1.0 - t * t * t;
        }
    }
    ,
    SMOOTH2{

        @Override
        public double scale(double t) {
            return SMOOTH.scale(SMOOTH.scale(t));
        }
    }
    ,
    SMOOTH3{

        @Override
        public double scale(double t) {
            return SMOOTH.scale(SMOOTH.scale(SMOOTH.scale(t)));
        }
    }
    ,
    HALF_SIN{
        private static final double halfpi = 1.5707963267948966;

        @Override
        public double scale(double t) {
            return Math.sin(t * 1.5707963267948966);
        }
    }
    ,
    INV_HALF_SIN{
        private static final double halfpi = 1.5707963267948966;

        @Override
        public double scale(double t) {
            return 1.0 - Math.sin(t * 1.5707963267948966);
        }
    };


    public abstract double scale(double var1);
}

