/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds.network;

import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import factorization.fzds.ShadowPlayerAligner;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.IFzdsShenanigans;
import factorization.fzds.network.CustomChannelNetworkManager;
import factorization.fzds.network.PacketProxyingPlayer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.world.WorldServer;

public class InteractionLiason
extends EntityPlayerMP
implements IFzdsShenanigans {
    static final WeakHashMap<EntityPlayerMP, InteractionLiason> activeLiasons = new WeakHashMap();
    private final InventoryPlayer original_inventory;
    private ShadowPlayerAligner aligner;
    private NetworkManager networkManager;
    private final WeakReference<EntityPlayerMP> realPlayerRef;
    private EmbeddedChannel proxiedChannel = new EmbeddedChannel(new ChannelHandler[]{new LiasonHandler()});

    public InteractionLiason(WorldServer world, ItemInWorldManager itemManager, EntityPlayerMP realPlayer, IDeltaChunk idc) {
        super(MinecraftServer.func_71276_C(), world, realPlayer.func_146103_bH(), itemManager);
        this.original_inventory = this.field_71071_by;
        this.realPlayerRef = new WeakReference<EntityPlayerMP>(realPlayer);
        this.initLiason();
        this.updateFromPlayerStatus();
    }

    private void initLiason() {
        this.networkManager = new CustomChannelNetworkManager((Channel)this.proxiedChannel, false);
        this.field_71135_a = new NetHandlerPlayServer(MinecraftServer.func_71276_C(), this.networkManager, (EntityPlayerMP)this);
        this.field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).set((Object)new NetworkDispatcher(this.networkManager));
        this.field_71135_a.field_147371_a.func_150723_a(EnumConnectionState.PLAY);
    }

    void updateFromPlayerStatus() {
        EntityPlayerMP realPlayer = (EntityPlayerMP)this.realPlayerRef.get();
        if (realPlayer == null) {
            return;
        }
        this.field_71071_by = realPlayer.field_71071_by;
        this.func_70031_b(realPlayer.func_70051_ag());
        this.func_70095_a(realPlayer.func_70093_af());
        this.field_71075_bZ = realPlayer.field_71075_bZ;
    }

    void initializeFor(IDeltaChunk idc) {
        EntityPlayerMP realPlayer = (EntityPlayerMP)this.realPlayerRef.get();
        if (realPlayer == null) {
            return;
        }
        this.aligner = new ShadowPlayerAligner((EntityPlayer)realPlayer, (EntityPlayer)this, idc);
        this.aligner.apply();
    }

    void finishUsingLiason() {
        if (this.field_71070_bA == null) {
            this.murderLiasonAndShoveHisWretchedBodyOnAPike();
        } else {
            this.keepLiason();
        }
    }

    void murderLiasonAndShoveHisWretchedBodyOnAPike() {
        this.field_71071_by = this.original_inventory;
        this.aligner.unapply();
        this.func_70106_y();
        this.realPlayerRef.clear();
    }

    void keepLiason() {
        EntityPlayerMP realPlayer = (EntityPlayerMP)this.realPlayerRef.get();
        if (realPlayer == null) {
            return;
        }
        activeLiasons.put(realPlayer, this);
    }

    public void func_71128_l() {
        super.func_71128_l();
        this.murderLiasonAndShoveHisWretchedBodyOnAPike();
    }

    public void func_71053_j() {
        super.func_71053_j();
        this.murderLiasonAndShoveHisWretchedBodyOnAPike();
    }

    public static void updateActiveLiasons() {
        Iterator<Map.Entry<EntityPlayerMP, InteractionLiason>> it = activeLiasons.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<EntityPlayerMP, InteractionLiason> pair = it.next();
            EntityPlayerMP real = pair.getKey();
            InteractionLiason liason = pair.getValue();
            if (real.field_70128_L || liason.field_71070_bA == null || liason.field_70128_L) {
                liason.murderLiasonAndShoveHisWretchedBodyOnAPike();
                it.remove();
                continue;
            }
            liason.field_71070_bA.func_75142_b();
        }
    }

    void bouncePacket(Object msg) {
        EntityPlayerMP realPlayer = (EntityPlayerMP)this.realPlayerRef.get();
        if (realPlayer == null) {
            return;
        }
        realPlayer.field_71135_a.func_147359_a(PacketProxyingPlayer.wrapMessage(msg));
    }

    public EntityPlayerMP getRealPlayer() {
        return (EntityPlayerMP)this.realPlayerRef.get();
    }

    private class LiasonHandler
    extends ChannelOutboundHandlerAdapter
    implements IFzdsShenanigans {
        private LiasonHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            InteractionLiason.this.bouncePacket(msg);
        }
    }
}

