/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds.network;

import com.google.common.collect.BiMap;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import factorization.fzds.interfaces.IFzdsShenanigans;
import factorization.fzds.network.WrappedPacketFromClient;
import factorization.fzds.network.WrappedPacketFromServer;
import factorization.shared.Core;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.network.play.server.S3FPacketCustomPayload;

public abstract class WrappedPacket
extends Packet
implements IFzdsShenanigans {
    static final BiMap<Integer, Class> serverPacketMap = EnumConnectionState.PLAY.func_150755_b();
    static final BiMap<Integer, Class> clientPacketMap = EnumConnectionState.PLAY.func_150753_a();
    static int server_packet_id = 92;
    static int client_packet_id = 92;
    Packet wrapped = null;
    boolean localPacket = true;

    public static void registerPacket() {
        if (serverPacketMap.containsKey((Object)server_packet_id)) {
            throw new RuntimeException("Packet " + server_packet_id + " is already registered!");
        }
        serverPacketMap.put((Object)server_packet_id, WrappedPacketFromServer.class);
        EnumConnectionState.field_150761_f.put(WrappedPacketFromServer.class, EnumConnectionState.PLAY);
        if (clientPacketMap.containsKey((Object)client_packet_id)) {
            throw new RuntimeException("Packet " + client_packet_id + " is already registered!");
        }
        clientPacketMap.put((Object)client_packet_id, WrappedPacketFromClient.class);
        EnumConnectionState.field_150761_f.put(WrappedPacketFromClient.class, EnumConnectionState.PLAY);
    }

    public WrappedPacket() {
    }

    public WrappedPacket(Packet wrapped) {
        this.wrapped = wrapped;
    }

    public void func_148837_a(PacketBuffer data) {
        this.wrapped = this.unwrapPacket(data);
        this.localPacket = false;
    }

    private Packet unwrapPacket(PacketBuffer buf) {
        int packetId = buf.func_150792_a();
        if (packetId == -1) {
            Core.logWarning("Recieved null packet", new Object[0]);
            return null;
        }
        Packet recieved_packet = Packet.func_148839_a(this.getPacketMap(), (int)packetId);
        if (recieved_packet == null) {
            Core.logWarning("Bad packet ID " + packetId, new Object[0]);
            return null;
        }
        try {
            recieved_packet.func_148837_a(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (recieved_packet instanceof S3FPacketCustomPayload) {
            return new FMLProxyPacket((S3FPacketCustomPayload)recieved_packet);
        }
        if (recieved_packet instanceof C17PacketCustomPayload) {
            return new FMLProxyPacket((C17PacketCustomPayload)recieved_packet);
        }
        return recieved_packet;
    }

    protected abstract boolean isServerside();

    protected abstract BiMap<Integer, Class> getPacketMap();

    public void func_148840_b(PacketBuffer data) {
        Integer packetId;
        PacketBuffer buff = new PacketBuffer((ByteBuf)data);
        if (this.wrapped == null) {
            buff.func_150787_b(-1);
            return;
        }
        if (this.wrapped instanceof FMLProxyPacket) {
            FMLProxyPacket pp = (FMLProxyPacket)this.wrapped;
            Packet packet = this.wrapped = this.isServerside() ? pp.toS3FPacket() : pp.toC17Packet();
        }
        if ((packetId = (Integer)this.getPacketMap().inverse().get(this.wrapped.getClass())) == null || packetId == -1) {
            if (packetId == null) {
                Core.logSevere("Can't send unregistered packet: " + this.wrappedToString(), new Object[0]);
            } else {
                Core.logSevere("I'm using the -1 ID for myself! Can't send this packet: " + this.wrappedToString(), new Object[0]);
            }
            this.wrapped = null;
            buff.func_150787_b(-1);
            return;
        }
        buff.func_150787_b(packetId.intValue());
        try {
            this.wrapped.func_148840_b(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String wrappedToString() {
        if (this.wrapped == null) {
            return "NULL";
        }
        String info = this.wrapped.getClass().getName();
        if (this.wrapped instanceof FMLProxyPacket) {
            FMLProxyPacket p = (FMLProxyPacket)this.wrapped;
            info = info + " channel:" + p.channel();
        }
        info = info + " serializes:" + this.wrapped.func_148835_b();
        info = info + " toString:" + this.wrapped.toString();
        return info;
    }

    public String func_148835_b() {
        return this.getClass().getSimpleName() + ":" + this.wrappedToString();
    }
}

