/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.mechanics.ChainRender;
import factorization.shared.Core;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class ChainLink {
    private Vec3 start;
    private Vec3 end;
    private Vec3 prevStart;
    private Vec3 prevEnd;
    int bagIndex = -1;

    public void update(Vec3 newStart, Vec3 newEnd) {
        if (this.prevStart == null) {
            this.start = SpaceUtil.copy(newStart);
            this.prevStart = SpaceUtil.copy(this.start);
            this.end = SpaceUtil.copy(newEnd);
            this.prevEnd = SpaceUtil.copy(this.end);
        } else {
            SpaceUtil.assignVecFrom(this.prevStart, this.start);
            SpaceUtil.assignVecFrom(this.start, newStart);
            SpaceUtil.assignVecFrom(this.prevEnd, this.end);
            SpaceUtil.assignVecFrom(this.end, newEnd);
        }
    }

    @SideOnly(value=Side.CLIENT)
    boolean cameraCheck(ICamera camera, float partial, AxisAlignedBB workBox, Vec3 workStart, Vec3 workEnd) {
        if (this.start == null) {
            return false;
        }
        NumUtil.interp(this.prevStart, this.start, partial, workStart);
        NumUtil.interp(this.prevEnd, this.end, partial, workEnd);
        Vec3 min = SpaceUtil.copy(workStart);
        Vec3 max = SpaceUtil.copy(workEnd);
        SpaceUtil.sort(min, max);
        SpaceUtil.setAABB(workBox, min, max);
        double d = -0.125;
        SpaceUtil.incrContract(workBox, -0.125, -0.125, -0.125);
        return camera.func_78546_a(workBox);
    }

    @SideOnly(value=Side.CLIENT)
    void draw(WorldClient world, Tessellator tess, ICamera camera, float partial, AxisAlignedBB workBox, Vec3 workStart, Vec3 workEnd) {
        Vec3 forward = SpaceUtil.subtract(workStart, workEnd);
        double length = forward.func_72433_c();
        Vec3 side1 = forward.func_72431_c(Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0));
        if (SpaceUtil.isZero(side1)) {
            side1 = forward.func_72431_c(Vec3.func_72443_a((double)-1.0, (double)0.0, (double)-1.0));
        }
        side1 = side1.func_72432_b();
        Vec3 side2 = forward.func_72431_c(side1).func_72432_b();
        double d = 0.25;
        double iconLength = 0.5;
        SpaceUtil.incrScale(side1, 0.25);
        SpaceUtil.incrScale(side2, 0.25);
        double linkCount = length / 2.0 / 0.5;
        Vec3 normForward = forward.func_72432_b();
        double extraLinkage = length % 0.5;
        extraLinkage *= -1.0;
        SpaceUtil.incrAdd(workStart, SpaceUtil.scale(normForward, extraLinkage += 0.5));
        double g = 0.28125;
        double h = g + 0.5;
        this.drawPlane(world, tess, workStart, workEnd, side1, g - (linkCount += extraLinkage), 1.0 + g);
        this.drawPlane(world, tess, workStart, workEnd, side2, h - linkCount, 1.0 + h);
    }

    void setupLight(WorldClient world, Tessellator tess, Vec3 at) {
        int x = (int)at.field_72450_a;
        int y = (int)at.field_72448_b;
        int z = (int)at.field_72449_c;
        Block b = world.func_147439_a(x, y, z);
        int brightness = b.func_149677_c((IBlockAccess)world, x, y, z);
        tess.func_78380_c(brightness);
    }

    void drawPlane(WorldClient world, Tessellator tess, Vec3 workStart, Vec3 workEnd, Vec3 right, double uStart, double uEnd) {
        this.setupLight(world, tess, workStart);
        tess.func_78374_a(workStart.field_72450_a + right.field_72450_a, workStart.field_72448_b + right.field_72448_b, workStart.field_72449_c + right.field_72449_c, uStart, 1.0);
        tess.func_78374_a(workStart.field_72450_a - right.field_72450_a, workStart.field_72448_b - right.field_72448_b, workStart.field_72449_c - right.field_72449_c, uStart, 0.0);
        this.setupLight(world, tess, workEnd);
        tess.func_78374_a(workEnd.field_72450_a - right.field_72450_a, workEnd.field_72448_b - right.field_72448_b, workEnd.field_72449_c - right.field_72449_c, uEnd, 0.0);
        tess.func_78374_a(workEnd.field_72450_a + right.field_72450_a, workEnd.field_72448_b + right.field_72448_b, workEnd.field_72449_c + right.field_72449_c, uEnd, 1.0);
    }

    public void release() {
        if (this.bagIndex == -1) {
            Core.logWarning("Already released", new Object[0]);
            Thread.dumpStack();
            return;
        }
        ChainRender.instance.release(this);
        this.bagIndex = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.bagIndex != -1) {
            Core.logWarning("ChainLink was not released! Its location: " + this.start + " to " + this.end, new Object[0]);
        }
    }
}

