/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.algos.FastBag;
import factorization.mechanics.ChainLink;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.lang.ref.WeakReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class ChainRender {
    public static final ChainRender instance = new ChainRender();
    private FastBag<WeakReference<ChainLink>> chains = new FastBag();
    boolean needsRebag = true;

    private ChainRender() {
        Core.loadBus(this);
    }

    public ChainLink add() {
        ChainLink ret = new ChainLink();
        ret.bagIndex = this.chains.size();
        this.chains.add(new WeakReference<ChainLink>(ret));
        this.rebag();
        return ret;
    }

    void release(ChainLink link) {
        int index = link.bagIndex;
        this.chains.remove(index);
        if (index >= this.chains.size()) {
            return;
        }
        ChainLink newEntry = (ChainLink)((WeakReference)this.chains.get(index)).get();
        if (newEntry == null) {
            this.rebag();
            return;
        }
        newEntry.bagIndex = index;
    }

    void rebag() {
        int i;
        if (!this.needsRebag) {
            return;
        }
        this.needsRebag = false;
        for (i = 0; i < this.chains.size(); ++i) {
            if (((WeakReference)this.chains.get(i)).get() != null) continue;
            this.chains.remove(i);
            --i;
        }
        for (i = 0; i < this.chains.size(); ++i) {
            WeakReference ref = (WeakReference)this.chains.get(i);
            ChainLink chain = (ChainLink)ref.get();
            if (chain == null) {
                this.needsRebag = true;
                continue;
            }
            chain.bagIndex = i;
        }
    }

    @SubscribeEvent
    public void drawChains(RenderWorldLastEvent event) {
        if (this.chains.isEmpty()) {
            return;
        }
        float partial = event.partialTicks;
        ICamera camera = this.getFrustum(partial);
        WorldClient w = event.context.field_72769_h;
        Minecraft mc = Minecraft.func_71410_x();
        EntityRenderer er = mc.field_71460_t;
        TextureManager textureManager = mc.func_110434_K();
        Tessellator tess = Tessellator.field_78398_a;
        boolean setup = false;
        AxisAlignedBB workBox = SpaceUtil.newBox();
        Vec3 workStart = SpaceUtil.newVec();
        Vec3 workEnd = SpaceUtil.newVec();
        for (WeakReference weakReference : this.chains) {
            ChainLink chain = (ChainLink)weakReference.get();
            if (chain == null) {
                this.needsRebag = true;
                continue;
            }
            if (!chain.cameraCheck(camera, partial, workBox, workStart, workEnd)) continue;
            if (!setup) {
                setup = true;
                tess.func_78382_b();
                tess.func_78370_a(255, 255, 255, 255);
                EntityLivingBase eyePos = mc.field_71451_h;
                double cx = eyePos.field_70142_S + (eyePos.field_70165_t - eyePos.field_70142_S) * (double)event.partialTicks;
                double cy = eyePos.field_70137_T + (eyePos.field_70163_u - eyePos.field_70137_T) * (double)event.partialTicks;
                double cz = eyePos.field_70136_U + (eyePos.field_70161_v - eyePos.field_70136_U) * (double)event.partialTicks;
                tess.func_78373_b(-cx, -cy, -cz);
            }
            chain.draw(w, tess, camera, partial, workBox, workStart, workEnd);
        }
        if (!setup) {
            return;
        }
        GL11.glPushAttrib((int)24576);
        textureManager.func_110577_a(new ResourceLocation("factorization", "textures/chain.png"));
        er.func_78463_b(0.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        tess.func_78381_a();
        er.func_78483_a(0.0);
        GL11.glPopAttrib();
        tess.func_78373_b(0.0, 0.0, 0.0);
        textureManager.func_110577_a(Core.blockAtlas);
    }

    @SubscribeEvent
    public void reset(WorldEvent.Unload unload) {
        if (!unload.world.field_72995_K) {
            return;
        }
        for (WeakReference weakReference : this.chains) {
            ChainLink chain = (ChainLink)weakReference.get();
            if (chain == null) continue;
            chain.bagIndex = -1;
        }
        this.chains.clear();
    }

    ICamera getFrustum(float partial) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase eye = mc.field_71451_h;
        double eyeX = eye.field_70142_S + (eye.field_70165_t - eye.field_70142_S) * (double)partial;
        double eyeY = eye.field_70137_T + (eye.field_70163_u - eye.field_70137_T) * (double)partial;
        double eyeZ = eye.field_70136_U + (eye.field_70161_v - eye.field_70136_U) * (double)partial;
        Frustrum frustrum = new Frustrum();
        frustrum.func_78547_a(eyeX, eyeY, eyeZ);
        return frustrum;
    }
}

