/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.mechanics.MassCalculator;
import factorization.util.SpaceUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

class InertiaCalculator
extends MassCalculator
implements ICoordFunction {
    private static final String inertiaKey = "IdcInertia";
    private static final String axisKey = "IdcInertiaAxis";
    private final Vec3 origin;
    private final Vec3 axisOfRotation;
    private double inertiaSum = 0.0;
    private Vec3 here = SpaceUtil.newVec();

    static double getInertia(IDeltaChunk idc, Vec3 axisOfRotation) {
        NBTTagCompound tag = idc.getEntityData();
        if (InertiaCalculator.axisNotUpdated(tag, axisOfRotation) && tag.func_74764_b(inertiaKey)) {
            return tag.func_74769_h(inertiaKey);
        }
        InertiaCalculator inertiaCalculator = new InertiaCalculator(idc, axisOfRotation);
        inertiaCalculator.calculate();
        return inertiaCalculator.inertiaSum;
    }

    static void dirty(IDeltaChunk idc) {
        NBTTagCompound tag = idc.getEntityData();
        tag.func_82580_o(inertiaKey);
        MassCalculator.dirty(idc);
    }

    private static boolean axisNotUpdated(NBTTagCompound tag, Vec3 axis) {
        double lastX = tag.func_74769_h("IdcInertiaAxis.x");
        double lastY = tag.func_74769_h("IdcInertiaAxis.y");
        double lastZ = tag.func_74769_h("IdcInertiaAxis.z");
        if (lastX == axis.field_72450_a && lastY == axis.field_72448_b && lastZ == axis.field_72449_c) {
            return true;
        }
        tag.func_74780_a("IdcInertiaAxis.x", axis.field_72450_a);
        tag.func_74780_a("IdcInertiaAxis.y", axis.field_72448_b);
        tag.func_74780_a("IdcInertiaAxis.z", axis.field_72449_c);
        return false;
    }

    protected InertiaCalculator(IDeltaChunk idc, Vec3 axisOfRotation) {
        super(idc);
        Vec3 minVec = SpaceUtil.newVec();
        this.min.setAsVector(minVec);
        this.origin = SpaceUtil.incrAdd(minVec, idc.getRotationalCenterOffset());
        this.axisOfRotation = axisOfRotation;
    }

    @Override
    public void handle(Coord coordHere, double blockMass) {
        super.handle(coordHere, blockMass);
        coordHere.setAsVector(this.here);
        SpaceUtil.incrSubtract(this.here, this.origin);
        double d = SpaceUtil.lineDistance(this.axisOfRotation, this.here);
        this.inertiaSum += blockMass * d * d;
    }

    @Override
    protected void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74780_a(inertiaKey, InertiaCalculator.round(this.inertiaSum));
    }
}

