/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import factorization.api.Coord;
import factorization.common.ItemIcons;
import factorization.fzds.DeltaChunk;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.mechanics.MechanicsController;
import factorization.mechanics.SocketPoweredCrank;
import factorization.notify.Notice;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.FzUtil;
import factorization.util.ItemUtil;
import factorization.util.SpaceUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemDarkIronChain
extends ItemFactorization {
    public ItemDarkIronChain(String name, Core.TabType tabType) {
        super(name, tabType);
        this.func_77625_d(1);
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        Coord at = new Coord(world, x, y, z);
        if (player.func_70093_af()) {
            this.clearPos(is, "real");
            this.clearPos(is, "shadow");
            new Notice(at, "item.factorization:darkIronChain.clear", new String[0]).sendTo(player);
            return true;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (world == DeltaChunk.getServerShadowWorld()) {
            for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(at)) {
                if (!this.acceptableIDC(idc) || !at.isSolidOnSide(dir)) continue;
                this.setPos(is, "shadow", at, dir);
                if (this.bothSet(is)) {
                    this.connectChain(player, is);
                } else {
                    new Notice(at, "item.factorization:darkIronChain.setShadow", new String[0]).sendTo(player);
                }
                return true;
            }
        } else {
            if (this.acceptableAnchor(at)) {
                this.setPos(is, "real", at, dir);
                if (this.bothSet(is)) {
                    this.connectChain(player, is);
                } else {
                    new Notice(at, "item.factorization:darkIronChain.setReal", new String[0]).sendTo(player);
                }
                return true;
            }
            new Notice(at, "item.factorization:darkIronChain.invalid", new String[0]).sendTo(player);
        }
        return false;
    }

    boolean acceptableAnchor(Coord at) {
        SocketPoweredCrank crank = at.getTE(SocketPoweredCrank.class);
        if (crank == null) {
            return false;
        }
        return !crank.isChained();
    }

    boolean acceptableIDC(IDeltaChunk idc) {
        if (!MechanicsController.usable(idc)) {
            return false;
        }
        for (DeltaCapability req : new DeltaCapability[]{DeltaCapability.INTERACT, DeltaCapability.BLOCK_MINE, DeltaCapability.BLOCK_PLACE, DeltaCapability.MOVE, DeltaCapability.COLLIDE, DeltaCapability.COLLIDE_WITH_WORLD}) {
            if (idc.can(req)) continue;
            return false;
        }
        return true;
    }

    void setPos(ItemStack is, String name, Coord at, ForgeDirection side) {
        NBTTagCompound tag = ItemUtil.getTag(is);
        tag.func_74768_a(name + ":w", FzUtil.getWorldDimension(at.w));
        tag.func_74768_a(name + ":x", at.x);
        tag.func_74768_a(name + ":y", at.y);
        tag.func_74768_a(name + ":z", at.z);
        tag.func_74774_a(name + ":s", (byte)side.ordinal());
    }

    void clearPos(ItemStack is, String name) {
        if (!is.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = ItemUtil.getTag(is);
        tag.func_82580_o(name + ":w");
        tag.func_82580_o(name + ":x");
        tag.func_82580_o(name + ":y");
        tag.func_82580_o(name + ":z");
        tag.func_82580_o(name + ":s");
        if (tag.func_82582_d()) {
            is.func_77982_d(null);
        }
    }

    Coord loadPos(ItemStack is, String name) {
        if (!is.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = ItemUtil.getTag(is);
        if (!tag.func_74764_b(name + ":w")) {
            return null;
        }
        WorldServer w = DimensionManager.getWorld((int)tag.func_74762_e(name + ":w"));
        if (w == null) {
            return null;
        }
        int x = tag.func_74762_e(name + ":x");
        int y = tag.func_74762_e(name + ":y");
        int z = tag.func_74762_e(name + ":z");
        return new Coord((World)w, x, y, z);
    }

    ForgeDirection loadSide(ItemStack is, String name) {
        if (!is.func_77942_o()) {
            return ForgeDirection.UNKNOWN;
        }
        NBTTagCompound tag = ItemUtil.getTag(is);
        if (!tag.func_74764_b(name + ":s")) {
            return ForgeDirection.UNKNOWN;
        }
        byte b = tag.func_74771_c(name + ":s");
        return ForgeDirection.getOrientation((int)b);
    }

    boolean bothSet(ItemStack is) {
        Coord real = this.loadPos(is, "real");
        Coord shadow = this.loadPos(is, "shadow");
        return real != null && shadow != null;
    }

    void connectChain(EntityPlayer player, ItemStack is) {
        Coord real = this.loadPos(is, "real");
        Coord shadow = this.loadPos(is, "shadow");
        if (real == null || shadow == null) {
            return;
        }
        SocketPoweredCrank crank = real.getTE(SocketPoweredCrank.class);
        if (crank == null || !this.acceptableAnchor(real)) {
            this.killChain(player, is);
            return;
        }
        IDeltaChunk toHook = null;
        for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(shadow)) {
            if (!this.acceptableIDC(idc)) continue;
            toHook = idc;
        }
        if (toHook == null) {
            this.killChain(player, is);
            return;
        }
        Coord fake = shadow.copy();
        toHook.shadow2real(fake);
        if (real.distance(fake) > 22.0) {
            Notice.onscreen(player, "item.factorization:darkIronChain.tooLong", new String[0]);
            this.killChain(player, is);
            return;
        }
        double d = 0.5;
        Vec3 anchorPoint = shadow.createVector().func_72441_c(d, d, d);
        ForgeDirection dir = this.loadSide(is, "shadow");
        Vec3 dv = SpaceUtil.scale(SpaceUtil.fromDirection(dir), 0.5);
        SpaceUtil.incrAdd(anchorPoint, dv);
        crank.setChain(toHook, anchorPoint, shadow);
        Notice.onscreen(player, "item.factorization:darkIronChain.finish", new String[0]);
        if (player.field_71075_bZ.field_75098_d) {
            is.func_77982_d(new NBTTagCompound());
        } else {
            --is.field_77994_a;
        }
        for (Coord at : Arrays.asList(real, fake)) {
            at.w.func_72980_b((double)at.x, (double)at.y, (double)at.z, "factorization:winch.unwind", 1.0f, 1.0f, false);
        }
    }

    void killChain(EntityPlayer player, ItemStack is) {
        this.clearPos(is, "real");
        this.clearPos(is, "shadow");
        Notice.onscreen(player, "item.factorization:darkIronChain.endLost", new String[0]);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && ((tag = stack.func_77978_p()).func_74764_b("real:w") || tag.func_74764_b("shadow:w"))) {
            return ItemIcons.darkIronChainHalf;
        }
        return super.getIcon(stack, pass);
    }

    public boolean hasEffect(ItemStack is, int pass) {
        if (is.func_77942_o()) {
            return true;
        }
        return super.hasEffect(is, pass);
    }

    @Override
    protected void addExtraInformation(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        if (!Core.dev_environ) {
            return;
        }
        Coord real = this.loadPos(is, "real");
        Coord shadow = this.loadPos(is, "shadow");
        if (real != null) {
            list.add("Real: " + real.toShortString());
        }
        if (shadow != null) {
            list.add("Shadow: " + shadow.toShortString());
        }
    }
}

