/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.mechanics.MassHelper;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

class MassCalculator
implements ICoordFunction {
    private static final boolean ROUND_RESULTS = true;
    private static final String massKey = "IdcMass";
    private static final String comKey = "IdcCOM";
    private double massTotal = 0.0;
    private Vec3 com = SpaceUtil.newVec();
    private final IDeltaChunk idc;
    protected final Coord min;
    protected final Coord max;
    private Vec3 boxMid = SpaceUtil.newVec();

    static double calculateMass(IDeltaChunk idc) {
        NBTTagCompound tag = idc.getEntityData();
        if (tag.func_74764_b(massKey)) {
            return tag.func_74769_h(massKey);
        }
        MassCalculator mc = new MassCalculator(idc);
        mc.calculate();
        return mc.massTotal;
    }

    static Vec3 getCenterOfMass(IDeltaChunk idc) {
        NBTTagCompound tag = idc.getEntityData();
        if (tag.func_74764_b("IdcCOM.x")) {
            double x = tag.func_74769_h("IdcCOM.x");
            double y = tag.func_74769_h("IdcCOM.y");
            double z = tag.func_74769_h("IdcCOM.z");
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        MassCalculator mc = new MassCalculator(idc);
        return mc.com;
    }

    static Coord getComCoord(IDeltaChunk idc) {
        Vec3 com = SpaceUtil.floor(MassCalculator.getCenterOfMass(idc));
        Coord min = idc.getCorner();
        com.field_72450_a -= (double)min.x;
        com.field_72448_b -= (double)min.y;
        com.field_72449_c -= (double)min.z;
        return new Coord(idc.getCorner().w, com);
    }

    static void dirty(IDeltaChunk idc) {
        NBTTagCompound tag = idc.getEntityData();
        tag.func_82580_o(massKey);
        tag.func_82580_o("IdcCOM.x");
        tag.func_82580_o("IdcCOM.y");
        tag.func_82580_o("IdcCOM.z");
    }

    protected static double round(double v) {
        int exp = Math.getExponent(v);
        if (exp < 0) {
            exp = 1;
        }
        return Math.pow(2.0, exp);
    }

    protected MassCalculator(IDeltaChunk idc) {
        this.idc = idc;
        this.min = idc.getCorner();
        this.max = idc.getFarCorner();
    }

    protected final void calculate() {
        Coord.iterateCube(this.min, this.max, this);
        this.save(this.idc.getEntityData());
    }

    protected void save(NBTTagCompound tag) {
        tag.func_74780_a(massKey, MassCalculator.round(this.massTotal));
        tag.func_74780_a("IdcCOM.x", this.com.field_72450_a);
        tag.func_74780_a("IdcCOM.y", this.com.field_72448_b);
        tag.func_74780_a("IdcCOM.z", this.com.field_72449_c);
    }

    protected void handle(Coord here, double mass) {
        AxisAlignedBB box = here.getCollisionBoundingBoxFromPool();
        if (box != null) {
            SpaceUtil.setMiddle(box, this.boxMid);
            double posRatio = mass / (mass + this.massTotal);
            NumUtil.interp(this.com, this.boxMid, (float)posRatio, this.com);
        }
        this.massTotal += mass;
    }

    @Override
    public final void handle(Coord here) {
        double hereMass = MassHelper.getBlockMass(here);
        if (hereMass <= 0.0) {
            return;
        }
        this.handle(here, hereMass);
    }
}

