/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import factorization.api.Coord;
import factorization.util.SpaceUtil;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;

public class MassHelper {
    public static boolean CONSIDER_VOLUME = true;
    private static double MAX_VOLUME = 27.0;

    public static double getBlockMass(Coord at) {
        double density = MassHelper.getMaterialDensity(at);
        if (!CONSIDER_VOLUME) {
            return density;
        }
        if (at.isNormalCube()) {
            return density;
        }
        AxisAlignedBB box = at.getCollisionBoundingBoxFromPool();
        if (box == null) {
            return 0.0;
        }
        return density * MassHelper.getVolume(box);
    }

    public static double getMaterialDensity(Coord at) {
        Material mat = at.getBlock().func_149688_o();
        if (mat == Material.field_151579_a) {
            return 0.0;
        }
        if (mat == Material.field_151570_A || mat == Material.field_151584_j || mat == Material.field_151585_k || mat == Material.field_151582_l) {
            return 0.25;
        }
        if (mat == Material.field_151575_d) {
            return 0.5;
        }
        if (mat == Material.field_151573_f || mat == Material.field_151574_g) {
            return 7.0;
        }
        if (mat == Material.field_151580_n || mat == Material.field_151593_r || mat == Material.field_151569_G) {
            return 0.1;
        }
        if (mat == Material.field_151586_h || mat == Material.field_151572_C) {
            return 1.0;
        }
        if (mat == Material.field_151597_y || mat == Material.field_151588_w) {
            return 0.8;
        }
        return 2.0;
    }

    private static double getVolume(AxisAlignedBB box) {
        double v = SpaceUtil.getVolume(box);
        return v > MAX_VOLUME ? MAX_VOLUME : v;
    }
}

