/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.api.Quaternion;
import factorization.fzds.TransferLib;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.mechanics.MassCalculator;
import factorization.mechanics.TileEntityHinge;
import factorization.shared.Core;
import factorization.shared.EntityReference;
import factorization.util.SpaceUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class MechanicsController
implements IDCController {
    private IDCController[] constraints = new IDCController[0];
    private static final double LINEAR_DAMPENING = 0.98;
    private static final double ROTATIONAL_DAMPENING = 0.98;
    private static final double GRAVITY = -0.08;

    static void register(IDeltaChunk idc, IDCController constraint) {
        MechanicsController.rejoin(idc, constraint);
        MechanicsController.changeCount(idc, 1);
    }

    static void rejoin(IDeltaChunk idc, IDCController constraint) {
        IDCController controller = idc.getController();
        if (controller == IDCController.default_controller) {
            controller = new MechanicsController();
            idc.setController(controller);
        } else if (!(controller instanceof MechanicsController)) {
            throw new IllegalArgumentException("IDC already had a controller, and it is not a MechanicsController! IDC: " + idc + "; controller: " + controller + "; constraint: " + constraint);
        }
        MechanicsController sys = (MechanicsController)controller;
        sys.addConstraint(constraint);
    }

    static void deregister(IDeltaChunk idc, IDCController constraint) {
        IDCController controller = idc.getController();
        if (!(controller instanceof MechanicsController)) {
            Core.logWarning("Tried to deregister constraint for IDC that isn't a MechanicsController! IDC: " + idc + "; controller: " + controller + "; constraint: ", constraint);
            return;
        }
        MechanicsController sys = (MechanicsController)controller;
        sys.removeConstraint(constraint);
        if (MechanicsController.changeCount(idc, -1) <= 0) {
            MechanicsController.dropIDC(idc);
        }
    }

    static boolean usable(IDeltaChunk idc) {
        IDCController controller = idc.getController();
        return controller == IDCController.default_controller || controller instanceof MechanicsController;
    }

    private static int changeCount(IDeltaChunk idc, int d) {
        String key;
        NBTTagCompound tag = idc.getEntityData();
        int old = tag.func_74762_e(key = "KinematicSystemEntries");
        int upd = old + d;
        if (upd < 0) {
            upd = 0;
        }
        tag.func_74768_a(key, upd);
        return upd;
    }

    private static void dropIDC(final IDeltaChunk idc) {
        idc.setRotation(new Quaternion());
        idc.setRotationalVelocity(new Quaternion());
        Coord min = idc.getCorner();
        Coord max = idc.getFarCorner();
        final Coord real = new Coord(idc);
        Coord.iterateCube(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord shadow) {
                if (shadow.isAir()) {
                    return;
                }
                real.set(shadow);
                idc.shadow2real(real);
                --real.x;
                --real.y;
                --real.z;
                if (real.isReplacable()) {
                    TransferLib.move(shadow, real, true, true);
                    real.markBlockForUpdate();
                } else {
                    shadow.breakBlock();
                }
            }
        });
        Coord.iterateCube(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                here.setAir();
            }
        });
        idc.func_70106_y();
    }

    public static void push(IDeltaChunk idc, Coord at, Vec3 force) {
        IDCController idcController = idc.getController();
        if (!(idcController instanceof MechanicsController)) {
            return;
        }
        MechanicsController controller = (MechanicsController)idcController;
        for (IDCController constraint : controller.constraints) {
            if (!(constraint instanceof TileEntityHinge)) continue;
            TileEntityHinge hinge = (TileEntityHinge)constraint;
            if (hinge.getCoord().isWeaklyPowered()) {
                return;
            }
            hinge.applyForce(idc, at, force);
            return;
        }
        double mass = MassCalculator.calculateMass(idc);
        SpaceUtil.incrScale(force, 1.0 / mass);
        Vec3 newVel = SpaceUtil.add(force, SpaceUtil.fromEntVel(idc));
        SpaceUtil.toEntVel(idc, newVel);
    }

    void addConstraint(IDCController constraint) {
        if (ArrayUtils.contains((Object[])this.constraints, (Object)constraint)) {
            return;
        }
        this.constraints = (IDCController[])ArrayUtils.add((Object[])this.constraints, (Object)constraint);
        if (constraint instanceof TileEntityHinge) {
            int i = this.constraints.length - 1;
            IDCController first = this.constraints[0];
            this.constraints[0] = constraint;
            this.constraints[i] = first;
        }
    }

    void removeConstraint(IDCController constraint) {
        this.constraints = (IDCController[])ArrayUtils.removeElement((Object[])this.constraints, (Object)constraint);
    }

    IDCController[] getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean placeBlock(IDeltaChunk idc, EntityPlayer player, Coord at) {
        for (IDCController c : this.constraints) {
            if (!c.placeBlock(idc, player, at)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean breakBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        for (IDCController c : this.constraints) {
            if (!c.breakBlock(idc, player, at, sideHit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hitBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        for (IDCController c : this.constraints) {
            if (!c.hitBlock(idc, player, at, sideHit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        for (IDCController c : this.constraints) {
            if (!c.useBlock(idc, player, at, sideHit)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void idcDied(IDeltaChunk idc) {
        for (IDCController c : this.constraints) {
            c.idcDied(idc);
        }
    }

    @Override
    public void beforeUpdate(IDeltaChunk idc) {
        for (IDCController c : this.constraints) {
            c.beforeUpdate(idc);
        }
    }

    private void updatePhysics(IDeltaChunk idc) {
        boolean anyMotion;
        if (idc.field_70170_p.field_72995_K || this.constraints.length == 0) {
            return;
        }
        if (idc.hasOrderedRotation()) {
            return;
        }
        boolean bl = anyMotion = idc.field_70159_w != 0.0 || idc.field_70181_x != 0.0 || idc.field_70179_y != 0.0 || !idc.getRotationalVelocity().isZero();
        if (!anyMotion) {
            return;
        }
        idc.field_70159_w *= 0.98;
        idc.field_70181_x *= 0.98;
        idc.field_70179_y *= 0.98;
        Quaternion w = idc.getRotationalVelocity();
        if (w.isZero()) {
            return;
        }
        Quaternion wp = new Quaternion().shortSlerp(w, 0.98);
        idc.setRotationalVelocity(wp);
    }

    @Override
    public void afterUpdate(IDeltaChunk idc) {
        for (IDCController c : this.constraints) {
            c.afterUpdate(idc);
        }
        this.updatePhysics(idc);
    }

    @Override
    public boolean onAttacked(IDeltaChunk idc, DamageSource damageSource, float damage) {
        return false;
    }

    @Override
    public IDCController.CollisionAction collidedWithWorld(World realWorld, AxisAlignedBB realBox, World shadowWorld, AxisAlignedBB shadowBox) {
        return IDCController.CollisionAction.STOP_BEFORE;
    }

    static EntityReference<IDeltaChunk> autoJoin(final IDCController controller) {
        EntityReference<IDeltaChunk> ret = new EntityReference<IDeltaChunk>();
        ret.whenFound(new EntityReference.OnFound<IDeltaChunk>(){

            @Override
            public void found(IDeltaChunk ent) {
                MechanicsController.rejoin(ent, controller);
            }
        });
        return ret;
    }
}

