/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.mechanics.ChainLink;
import factorization.mechanics.ChainRender;
import factorization.mechanics.InertiaCalculator;
import factorization.mechanics.MechanicsController;
import factorization.mechanics.TileEntityHinge;
import factorization.mechanics.WinchSound;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import factorization.shared.EntityReference;
import factorization.shared.FactorizationBlockRender;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketBareMotor;
import factorization.sockets.TileEntitySocketBase;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SocketPoweredCrank
extends TileEntitySocketBase
implements IChargeConductor,
IDCController {
    private Charge charge = new Charge(this);
    final EntityReference<IDeltaChunk> hookedIdc = MechanicsController.autoJoin(this);
    Vec3 hookLocation = SpaceUtil.newVec();
    DeltaCoord hookDelta = new DeltaCoord();
    byte powerTime = 0;
    static final float sprocketRadius = 0.5f;
    static final double MAX_CHAIN_LEN = 24.0;
    static final double MIN_CHAIN_LEN = 1.0;
    static final double BROKEN_CHAIN_LENGTH = 32.0;
    static final int WINDING_CHARGE_COST = 16;
    static final double FORCE_PER_TICK = 0.05;
    static final double RESTORATIVE_FORCE_MIN = 1.0;
    static final double RESTORATIVE_FORCE_MAX = 2.0;
    int compareValue;
    ChainLink chainDraw;
    float chainLen;
    float prevChainLen;
    double chainDelta = 0.0;
    boolean soundActive;
    byte spinSign = 1;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_POWERED_CRANK;
    }

    @Override
    public ItemStack getCreatingItem() {
        return Core.registry.dark_iron_sprocket;
    }

    @Override
    public FactoryType getParentFactoryType() {
        return FactoryType.SOCKET_BARE_MOTOR;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean onAttacked(IDeltaChunk idc, DamageSource damageSource, float damage) {
        return false;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.charge = data.as(Share.PRIVATE, "charge").putIDS(this.charge);
        data.as(Share.VISIBLE, "hookedEntity");
        this.hookedIdc.serialize(prefix, data);
        this.hookLocation = data.as(Share.VISIBLE, "hookLocation").putVec3(this.hookLocation);
        if (data.isReader() && this.chainDraw != null) {
            this.chainDraw.release();
            this.chainDraw = null;
            this.chainDelta = 0.0;
        }
        this.hookDelta = data.as(Share.PRIVATE, "hookDelta").putIDS(this.hookDelta);
        this.powerTime = data.as(Share.PRIVATE, "powerTime").putByte(this.powerTime);
        return this;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        if (!this.hookedIdc.trackingEntity()) {
            return "Not connected";
        }
        if (this.hookedIdc.getEntity() == null) {
            return "Chained (unloaded)";
        }
        return "Chained";
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.hookedIdc.setWorld(world);
    }

    @Override
    public void func_145845_h() {
        this.charge.update();
        super.func_145845_h();
    }

    void shareCharge() {
        Coord anchorPoint = this.getAnchorBlock();
        if (anchorPoint == null) {
            return;
        }
        IChargeConductor friendConductor = anchorPoint.getTE(IChargeConductor.class);
        if (friendConductor == null) {
            return;
        }
        Charge friend = friendConductor.getCharge();
        int total = this.charge.getValue() + friend.getValue();
        int split = total / 2;
        int rem = total % 2;
        int mine = split + rem;
        int his = split;
        this.charge.setValue(mine);
        friend.setValue(his);
    }

    @Override
    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        this.updateChain(socket == null ? this : socket);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IDeltaChunk idc = this.hookedIdc.getEntity();
        if (idc == null) {
            return;
        }
        if ((double)this.chainLen > 32.0) {
            this.breakChain();
            return;
        }
        this.shareCharge();
        if ((double)this.chainLen < 1.0) {
            return;
        }
        if ((double)this.chainLen >= 24.0) {
            this.yoinkChain(socket, idc, 0.0625);
            return;
        }
        if (powered && this.powerTime >= 0 && this.charge.tryTake(10) == 0) {
            if (this.powerTime > 5) {
                idc.cancelOrderedRotation();
                this.powerTime = (byte)4;
                return;
            }
            this.powerTime = (byte)(this.powerTime + 1);
            return;
        }
        if (!powered) {
            if (5 > this.powerTime && this.powerTime > 0) {
                this.yankChain(socket, idc, true);
            } else if (this.powerTime > 0 && this.powerTime != -1) {
                idc.cancelOrderedRotation();
            }
            this.powerTime = 0;
        } else if (this.powerTime == 5) {
            this.yankChain(socket, idc, false);
            this.powerTime = (byte)(this.powerTime + 1);
        } else if (powered && this.powerTime >= 0) {
            if (this.powerTime > 5 && !idc.hasOrderedRotation()) {
                this.powerTime = (byte)-1;
                return;
            }
            this.powerTime = (byte)(this.powerTime + 1);
        }
    }

    private void yoinkChain(ISocketHolder socket, IDeltaChunk idc, double targetSpeed) {
        Vec3 force = this.getForce(idc, socket, targetSpeed);
        Coord at = new Coord(DeltaChunk.getServerShadowWorld(), this.hookLocation);
        MechanicsController.push(idc, at, force);
    }

    private void yankChain(ISocketHolder socket, IDeltaChunk idc, boolean singleBlock) {
        double deltaC;
        TileEntityHinge hinge = this.getHinge(idc);
        if (hinge == null) {
            this.yoinkChain(socket, idc, 0.0625);
            return;
        }
        if (new Coord(hinge).isWeaklyPowered()) {
            this.powerTime = (byte)-1;
            return;
        }
        Vec3 rotationAxis = hinge.getRotationAxis();
        Quaternion rot = idc.getRotation();
        Quaternion min = this.getMinimizedRotation(idc, hinge, rotationAxis);
        double dtheta = rot.getAngleBetween(min);
        double r = SpaceUtil.subtract(idc.shadow2real(this.hookLocation), SpaceUtil.fromEntPos(idc)).func_72433_c();
        double totalC = deltaC = dtheta * r;
        if (singleBlock && deltaC > 1.0) {
            deltaC = 1.0;
        }
        if (deltaC == 0.0) {
            return;
        }
        double I = hinge.getInertia(idc, rotationAxis);
        I = NumUtil.clip(I, 100.0, 5000.0);
        double radiansPerTick = 10.0 / I;
        double t = deltaC / totalC;
        Quaternion target = rot.shortSlerp(min, t);
        int ticks = (int)(deltaC / radiansPerTick);
        ticks = NumUtil.clip(ticks, 10, (int)(200.0 * totalC));
        Interpolation interp = singleBlock ? Interpolation.SMOOTH : Interpolation.LINEAR;
        idc.orderTargetRotation(target, ticks, interp);
    }

    private TileEntityHinge getHinge(IDeltaChunk idc) {
        IDCController controller = idc.getController();
        if (controller instanceof MechanicsController) {
            MechanicsController mc = (MechanicsController)controller;
            for (IDCController constraint : mc.getConstraints()) {
                if (!(constraint instanceof TileEntityHinge)) continue;
                return (TileEntityHinge)constraint;
            }
        } else if (controller instanceof TileEntityHinge) {
            return (TileEntityHinge)controller;
        }
        return null;
    }

    private Quaternion getMinimizedRotation(IDeltaChunk idc, TileEntityHinge hinge, Vec3 rotationAxis) {
        Vec3 com = idc.real2shadow(SpaceUtil.fromEntPos(idc));
        Vec3 anchorVec = SpaceUtil.subtract(this.hookLocation, com).func_72432_b();
        Vec3 you = SpaceUtil.fromEntPos(idc);
        Vec3 me = new Coord(this).toMiddleVector();
        Vec3 vec = SpaceUtil.subtract(me, you);
        Vec3 mask = SpaceUtil.copy(rotationAxis);
        mask.field_72450_a = mask.field_72450_a == 0.0 ? 1.0 : 0.0;
        mask.field_72448_b = mask.field_72448_b == 0.0 ? 1.0 : 0.0;
        mask.field_72449_c = mask.field_72449_c == 0.0 ? 1.0 : 0.0;
        SpaceUtil.incrComponentMultiply(vec, mask);
        Vec3 minVec = vec.func_72432_b();
        double angle = SpaceUtil.getAngle(anchorVec, minVec);
        return Quaternion.getRotationQuaternionRadians(angle, rotationAxis);
    }

    private Vec3 getForce(IDeltaChunk idc, ISocketHolder socket, double targetSpeed) {
        Vec3 realHookLocation = idc.shadow2real(this.hookLocation);
        Vec3 selfPos = socket.getPos();
        Vec3 chainVec = SpaceUtil.subtract(realHookLocation, selfPos).func_72432_b();
        SpaceUtil.incrScale(chainVec, -targetSpeed);
        return chainVec;
    }

    private Vec3 limitForce(IDeltaChunk idc, Vec3 force, double targetSpeed) {
        DimensionSliceEntity dse = (DimensionSliceEntity)idc;
        Vec3 realHookLocation = idc.shadow2real(this.hookLocation);
        Vec3 inst = dse.getInstantaneousRotationalVelocityAtPointInCornerSpace(realHookLocation);
        return Vec3.func_72443_a((double)SocketPoweredCrank.c(inst.field_72450_a, force.field_72450_a), (double)SocketPoweredCrank.c(inst.field_72448_b, force.field_72448_b), (double)SocketPoweredCrank.c(inst.field_72449_c, force.field_72449_c));
    }

    private static double c(double inst, double force) {
        if (inst == 0.0 || force == 0.0) {
            return force;
        }
        if (inst > 0.0 && force > 0.0) {
            double d = force - inst;
            if (d < 0.0) {
                return 0.0;
            }
            return d;
        }
        if (inst < 0.0 && force < 0.0) {
            double d = inst - force;
            if (d < 0.0) {
                return d;
            }
            return 0.0;
        }
        return force;
    }

    public void setChain(IDeltaChunk idc, Vec3 hookLocation, Coord hookedBlock) {
        if (this.hookedIdc.trackingEntity()) {
            this.getCoord().spawnItem(Core.registry.darkIronChain);
        }
        this.hookedIdc.trackEntity(idc);
        this.hookLocation = hookLocation;
        this.hookDelta = hookedBlock.asDeltaCoord();
        this.getCoord().syncTE();
        MechanicsController.register(idc, this);
        this.updateComparator();
    }

    public boolean isChained() {
        return this.hookedIdc.trackingEntity();
    }

    public boolean breakChain() {
        if (!this.isChained()) {
            return false;
        }
        IDeltaChunk idc = this.hookedIdc.getEntity();
        if (idc == null) {
            return true;
        }
        MechanicsController.deregister(idc, this);
        this.hookedIdc.trackEntity(null);
        Coord at = this.getCoord();
        at.spawnItem(new ItemStack((Item)Core.registry.darkIronChain));
        at.syncTE();
        this.updateComparator();
        this.chainDelta = 0.0;
        return false;
    }

    @Override
    public void uninstall() {
        this.breakChain();
    }

    void updateComparator() {
        int orig = this.compareValue;
        this.calcComparator();
        if (this.compareValue != orig) {
            this.func_70296_d();
        }
    }

    void calcComparator() {
        if (!this.isChained()) {
            this.compareValue = 0;
            return;
        }
        if ((double)this.chainLen >= 23.0) {
            this.compareValue = 15;
        } else {
            int l;
            this.compareValue = l = (int)(this.chainLen / 2.0f);
            if (this.compareValue < 0) {
                this.compareValue = 1;
            }
            if (this.compareValue > 14) {
                this.compareValue = 14;
            }
            this.compareValue = 14 - this.compareValue;
        }
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        return this.compareValue;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
        SocketBareMotor sbm = (SocketBareMotor)FactoryType.SOCKET_BARE_MOTOR.getRepresentative();
        this.getCoord().setAsTileEntityLocation(sbm);
        sbm.facing = this.facing;
        sbm.renderStatic(motor, tess);
        sbm.func_145834_a(null);
    }

    void updateChain(ISocketHolder socket) {
        IDeltaChunk idc = this.hookedIdc.getEntity();
        if (idc == null) {
            return;
        }
        Vec3 realHookLocation = idc.shadow2real(this.hookLocation);
        Vec3 selfPos = socket.getPos();
        Vec3 chainVec = SpaceUtil.subtract(realHookLocation, selfPos);
        Vec3 point = SpaceUtil.fromDirection(this.facing);
        Vec3 right = SpaceUtil.scale(point.func_72431_c(chainVec).func_72432_b(), 0.5);
        this.spinSign = (byte)(SpaceUtil.sum(right) > 0.0 ? 1 : -1);
        SpaceUtil.incrAdd(selfPos, right);
        float len = (float)SpaceUtil.lineDistance(selfPos, realHookLocation);
        if (this.field_145850_b.field_72995_K) {
            this.setChainDraw(realHookLocation, selfPos, len);
        } else {
            this.chainLen = len;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setChainDraw(Vec3 realHookLocation, Vec3 selfPos, float len) {
        boolean first = false;
        if (this.chainDraw == null) {
            this.chainDraw = ChainRender.instance.add();
            first = true;
        }
        this.chainDraw.update(selfPos, realHookLocation);
        if (first) {
            this.chainLen = this.prevChainLen = len;
        } else {
            this.chainDelta += (double)(len - this.prevChainLen);
            this.prevChainLen = this.chainLen;
            this.chainLen = len;
        }
        if (this.soundActive) {
            this.chainDelta /= 2.0;
            if (Math.abs(this.chainDelta) < 1.0E-4) {
                this.chainDelta = 0.0;
            }
            return;
        }
        double min = 0.15;
        byte direction = 0;
        if (this.chainDelta < -min) {
            direction = -1;
        } else if (this.chainDelta > min) {
            direction = 1;
        } else {
            return;
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new WinchSound(direction, this));
    }

    @Override
    public Vec3 getPos() {
        double d = 0.5;
        return Vec3.func_72443_a((double)((double)this.field_145851_c + d), (double)((double)this.field_145848_d + d), (double)((double)this.field_145849_e + d));
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.chainDraw != null) {
            this.chainDraw.release();
            this.chainDraw = null;
            this.chainDelta = 0.0;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
        super.renderTesr(motor, partial);
        float sprocketTheta = 0.0f;
        if (this.chainDraw != null) {
            float len = NumUtil.interp(this.prevChainLen, this.chainLen, partial);
            sprocketTheta = len / 0.5f;
        }
        float d = 0.5f;
        GL11.glTranslatef((float)d, (float)d, (float)d);
        Quaternion.fromOrientation(FzOrientation.fromDirection(this.facing.getOpposite())).glRotate();
        GL11.glTranslatef((float)0.0f, (float)-0.078125f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)2.5f, (float)1.0f);
        GL11.glRotated((double)Math.toDegrees(sprocketTheta), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.0f);
        FactorizationBlockRender.renderItemIIcon(this.getCreatingItem().func_77973_b().func_77617_a(0));
    }

    Coord getAnchorBlock() {
        IDeltaChunk idc = this.hookedIdc.getEntity();
        if (idc == null) {
            return null;
        }
        return new Coord(idc.getCorner().w, 0, 0, 0).add(this.hookDelta);
    }

    @Override
    public boolean placeBlock(IDeltaChunk idc, EntityPlayer player, Coord at) {
        InertiaCalculator.dirty(idc);
        return false;
    }

    @Override
    public boolean breakBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        Coord anchorPoint = this.getAnchorBlock();
        if (anchorPoint == null) {
            return false;
        }
        if (anchorPoint.equals(at)) {
            this.breakChain();
        }
        InertiaCalculator.dirty(idc);
        return false;
    }

    @Override
    public boolean hitBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return false;
    }

    @Override
    public boolean useBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return false;
    }

    @Override
    public void idcDied(IDeltaChunk idc) {
    }

    @Override
    public void beforeUpdate(IDeltaChunk idc) {
    }

    @Override
    public void afterUpdate(IDeltaChunk idc) {
        if (idc.hasOrderedRotation() || !idc.getRotationalVelocity().isZero() || idc.field_70159_w != 0.0 || idc.field_70181_x != 0.0 || idc.field_70179_y != 0.0) {
            this.updateComparator();
        }
    }

    @Override
    public IDCController.CollisionAction collidedWithWorld(World realWorld, AxisAlignedBB realBox, World shadowWorld, AxisAlignedBB shadowBox) {
        return IDCController.CollisionAction.STOP_BEFORE;
    }
}

