/*
 * Decompiled with CFR 0.152.
 */
package factorization.mechanics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.fzds.DeltaChunk;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.mechanics.InertiaCalculator;
import factorization.mechanics.MechanicsController;
import factorization.mechanics.MechanismsFeature;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.EntityReference;
import factorization.shared.ObjectModel;
import factorization.shared.TileEntityCommon;
import factorization.util.NumUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityHinge
extends TileEntityCommon
implements IDCController {
    FzOrientation facing = FzOrientation.FACE_EAST_POINT_DOWN;
    final EntityReference<IDeltaChunk> idcRef = MechanicsController.autoJoin(this);
    Vec3 dseOffset = SpaceUtil.newVec();
    transient boolean idc_ticking = false;
    static ThreadLocal<Boolean> initializing = new ThreadLocal();
    static final double min_velocity = 3.9269908169872416E-4;
    static final double max_velocity = 0.039269908169872414;
    static final double min_push_force = NumUtil.interp(3.9269908169872416E-4, 0.039269908169872414, 0.01);
    transient long ticks;
    @SideOnly(value=Side.CLIENT)
    public static ObjectModel hingeTop;
    private transient byte comparator_cache = 0;
    private transient boolean executing_order = false;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.HINGE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    public void func_145834_a(World w) {
        super.func_145834_a(w);
        this.idcRef.setWorld(w);
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        this.facing = SpaceUtil.getOrientation(player, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return ForgeDirection.getOrientation((int)side) == this.facing.facing.getOpposite();
    }

    @Override
    public void neighborChanged() {
        if (this.idcRef.trackingEntity()) {
            IDeltaChunk idc = this.idcRef.getEntity();
            if (idc != null && this.getCoord().isWeaklyPowered()) {
                idc.setRotationalVelocity(new Quaternion());
            }
        } else {
            this.initHinge();
        }
    }

    private void initHinge() {
        if (this.idcRef.trackingEntity()) {
            return;
        }
        if (initializing.get() == Boolean.TRUE) {
            return;
        }
        initializing.set(Boolean.TRUE);
        try {
            this.initHinge0();
        }
        finally {
            initializing.remove();
        }
    }

    private void initHinge0() {
        final Coord target = this.getCoord().add(this.facing.facing);
        if (target.isReplacable()) {
            return;
        }
        if (target.isBedrock()) {
            return;
        }
        DeltaCoord size = new DeltaCoord(8, 8, 8);
        Coord min = this.getCoord().add(size.reverse());
        Coord max = this.getCoord().add(size);
        IDeltaChunk idc = DeltaChunk.makeSlice(MechanismsFeature.deltachunk_channel, min, max, new DeltaChunk.AreaMap(){

            @Override
            public void fillDse(DeltaChunk.DseDestination destination) {
                destination.include(target);
            }
        }, true);
        idc.loadUsualCapabilities();
        idc.permit(DeltaCapability.COLLIDE_WITH_WORLD);
        idc.permit(DeltaCapability.DIE_WHEN_EMPTY);
        idc.permit(DeltaCapability.ENTITY_PHYSICS);
        idc.permit(DeltaCapability.PHYSICS_DAMAGE);
        idc.permit(DeltaCapability.CONSERVE_MOMENTUM);
        Vec3 idcPos = SpaceUtil.fromEntPos(idc);
        int faceSign = SpaceUtil.sign(this.facing.facing);
        int topSign = SpaceUtil.sign(this.facing.top);
        Vec3 half = SpaceUtil.fromDirection(this.facing.facing);
        half = SpaceUtil.scale(half, 0.5 * (double)faceSign);
        if (topSign > 0) {
            half = SpaceUtil.add(half, SpaceUtil.fromDirection(this.facing.top));
        }
        Vec3 com = idc.getRotationalCenterOffset();
        com = SpaceUtil.add(com, half);
        idc.setRotationalCenterOffset(com);
        SpaceUtil.toEntPos(idc, SpaceUtil.add(idcPos, half));
        Coord dest = idc.getCenter();
        DeltaCoord hingePoint = dest.difference(idc.getCorner());
        this.field_145850_b.func_72838_d((Entity)idc);
        MechanicsController.register(idc, this);
        this.idcRef.trackEntity(idc);
        this.updateComparators();
        this.func_70296_d();
        this.getCoord().syncTE();
        this.dseOffset.field_72450_a = idc.field_70165_t - (double)this.field_145851_c;
        this.dseOffset.field_72448_b = idc.field_70163_u - (double)this.field_145848_d;
        this.dseOffset.field_72449_c = idc.field_70161_v - (double)this.field_145849_e;
    }

    void setProperPosition(IDeltaChunk idc) {
        idc.field_70165_t = this.dseOffset.field_72450_a + (double)this.field_145851_c;
        idc.field_70163_u = this.dseOffset.field_72448_b + (double)this.field_145848_d;
        idc.field_70161_v = this.dseOffset.field_72449_c + (double)this.field_145849_e;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.facing = data.as(Share.VISIBLE, "facing").putEnum(this.facing);
        data.as(Share.VISIBLE, "ref").putIDS(this.idcRef);
        this.dseOffset = data.as(Share.PRIVATE, "dseOffset").putVec3(this.dseOffset);
    }

    void setSlabBounds(Block b) {
        float d = 0.5f;
        switch (this.facing.facing) {
            case DOWN: {
                b.func_149676_a(0.0f, d, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UNKNOWN: 
            case UP: {
                b.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, d, 1.0f);
                break;
            }
            case NORTH: {
                b.func_149676_a(0.0f, 0.0f, d, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                b.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, d);
                break;
            }
            case WEST: {
                b.func_149676_a(d, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                b.func_149676_a(0.0f, 0.0f, 0.0f, d, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean placeBlock(IDeltaChunk idc, EntityPlayer player, Coord at) {
        this.dirtyInertia();
        return false;
    }

    @Override
    public boolean breakBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        this.dirtyInertia();
        return false;
    }

    @Override
    public boolean useBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        if (player.func_70093_af()) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held != null && held.func_77976_d() > 1) {
            return false;
        }
        if (this.getCoord().isWeaklyPowered()) {
            return false;
        }
        return this.applyForce(idc, player, at, -1.0);
    }

    double getInertia(IDeltaChunk idc, Vec3 rotationAxis) {
        double inertia = InertiaCalculator.getInertia(idc, rotationAxis);
        if (inertia < 20.0) {
            inertia = 20.0;
        }
        return inertia;
    }

    void dirtyInertia() {
        IDeltaChunk idc = this.idcRef.getEntity();
        if (idc == null) {
            return;
        }
        InertiaCalculator.dirty(idc);
    }

    @Override
    public boolean hitBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        if (player.func_70093_af()) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.applyForce(idc, player, at, 1.0);
    }

    private boolean applyForce(IDeltaChunk idc, EntityPlayer player, Coord at, double forceMultiplier) {
        if (this.getCoord().isWeaklyPowered()) {
            return true;
        }
        if (player.func_70051_ag()) {
            forceMultiplier *= 2.0;
        }
        if (!player.field_70122_E) {
            forceMultiplier /= 3.0;
        }
        Vec3 force = player.func_70040_Z().func_72432_b();
        SpaceUtil.incrScale(force, forceMultiplier *= PlayerUtil.getPuntStrengthMultiplier(player));
        this.applyForce(idc, at, force);
        this.limitBend(idc);
        this.limitVelocity(idc);
        return false;
    }

    void applyForce(IDeltaChunk idc, Coord at, Vec3 force) {
        Vec3 rotationAxis = this.getRotationAxis();
        double I = this.getInertia(idc, rotationAxis);
        idc.getRotation().applyReverseRotation(force);
        Vec3 hitBlock = at.createVector();
        Vec3 idcCorner = idc.getCorner().createVector();
        Vec3 idcRot = SpaceUtil.add(idcCorner, idc.getRotationalCenterOffset());
        Vec3 leverArm = SpaceUtil.subtract(hitBlock, idcRot);
        SpaceUtil.incrScale(force, 2.0 / I);
        Vec3 torque = leverArm.func_72431_c(force);
        idc.getRotation().applyRotation(torque);
        if (SpaceUtil.sum(rotationAxis) < 0.0) {
            SpaceUtil.incrScale(rotationAxis, -1.0);
        }
        SpaceUtil.incrComponentMultiply(torque, rotationAxis);
        Quaternion qx = Quaternion.getRotationQuaternionRadians(torque.field_72450_a, ForgeDirection.EAST);
        Quaternion qy = Quaternion.getRotationQuaternionRadians(torque.field_72448_b, ForgeDirection.UP);
        Quaternion qz = Quaternion.getRotationQuaternionRadians(torque.field_72449_c, ForgeDirection.SOUTH);
        Quaternion dOmega = qx.multiply(qy).multiply(qz);
        if (dOmega.getAngleRadians() < min_push_force) {
            dOmega = Quaternion.getRotationQuaternionRadians(min_push_force, SpaceUtil.normalize(dOmega.toVector()));
        }
        Quaternion origOmega = idc.getRotationalVelocity();
        Quaternion newOmega = origOmega.multiply(dOmega);
        newOmega.incrNormalize();
        idc.setRotationalVelocity(newOmega);
    }

    Vec3 getRotationAxis() {
        Vec3 topVec = SpaceUtil.fromDirection(this.facing.top);
        Vec3 faceVec = SpaceUtil.fromDirection(this.facing.facing);
        return topVec.func_72431_c(faceVec);
    }

    @Override
    public void idcDied(IDeltaChunk idc) {
        this.idcRef.trackEntity(null);
        this.updateComparators();
        this.func_70296_d();
        this.getCoord().syncTE();
    }

    @Override
    public boolean onAttacked(IDeltaChunk idc, DamageSource damageSource, float damage) {
        return false;
    }

    @Override
    public IDCController.CollisionAction collidedWithWorld(World realWorld, AxisAlignedBB realBox, World shadowWorld, AxisAlignedBB shadowBox) {
        return IDCController.CollisionAction.STOP_BEFORE;
    }

    IDeltaChunk getIdc() {
        return this.idcRef.getEntity();
    }

    boolean isBasicallyZero(Quaternion rotVel) {
        return rotVel.isZero() || rotVel.getAngleRadians() < 3.9269908169872416E-4;
    }

    @Override
    public void beforeUpdate(IDeltaChunk idc) {
        Quaternion dampened;
        if (idc.hasOrderedRotation()) {
            this.limitBend(idc);
            return;
        }
        this.idc_ticking = true;
        Quaternion rotVel = idc.getRotationalVelocity();
        if (rotVel.isZero()) {
            return;
        }
        if (this.isBasicallyZero(rotVel)) {
            dampened = new Quaternion();
        } else {
            double angle = rotVel.getAngleRadians();
            if (angle > 0.039269908169872414) {
                Vec3 axis = rotVel.toVector().func_72432_b();
                dampened = Quaternion.getRotationQuaternionRadians(0.039269908169872414, axis);
            } else {
                dampened = rotVel.slerp(new Quaternion(), 0.05);
            }
        }
        idc.setRotationalVelocity(dampened);
        this.limitBend(idc);
        this.limitVelocity(idc);
    }

    private boolean bendMode() {
        return SpaceUtil.sign(this.facing.facing.getRotation(this.facing.top)) == -1;
    }

    private void limitBend(IDeltaChunk idc) {
        Quaternion rotationalVelocity = idc.getRotationalVelocity();
        if (!idc.hasOrderedRotation() && rotationalVelocity.isZero()) {
            return;
        }
        Quaternion nextRotation = idc.getRotation().multiply(rotationalVelocity);
        Vec3 middle = SpaceUtil.fromDirection(this.facing.top);
        Vec3 arm = SpaceUtil.fromDirection(this.facing.facing);
        nextRotation.applyRotation(arm);
        double angle = SpaceUtil.getAngle(middle, arm);
        double end = 1.5707963267948966;
        if (angle < 1.5707963267948966) {
            return;
        }
        double p = 1.5707963267948966 / angle;
        Quaternion armAngle = Quaternion.getRotationQuaternionRadians(0.0, middle);
        if (idc.hasOrderedRotation()) {
            idc.cancelOrderedRotation();
        } else {
            idc.setRotationalVelocity(new Quaternion());
        }
        double t = nextRotation.getAngleRadians();
        if (t < 0.0) {
            t = -1.5707963267948966;
        }
        if (t > Math.PI) {
            t = Math.PI;
        }
        idc.setRotation(Quaternion.getRotationQuaternionRadians(t, nextRotation.toVector()));
    }

    private void limitVelocity(IDeltaChunk idc) {
        Quaternion rot = idc.getRotationalVelocity();
        double rv = rot.getAngleRadians();
        if (rv < 0.039269908169872414) {
            return;
        }
        double p = 0.039269908169872414 / rv;
        idc.setRotationalVelocity(new Quaternion().slerp(rot, p));
    }

    @Override
    public void afterUpdate(IDeltaChunk idc) {
        this.idc_ticking = false;
        if (!idc.getRotationalVelocity().isZero() || idc.hasOrderedRotation()) {
            this.updateComparators();
        }
        if (this.executing_order && !idc.hasOrderedRotation()) {
            this.executing_order = false;
        }
        if (this.field_145850_b.func_82737_E() % 60L == 0L) {
            this.setProperPosition(idc);
        }
    }

    @Override
    public boolean addCollisionBoxesToList(Block block, AxisAlignedBB aabb, List list, Entity entity) {
        if (this.idc_ticking) {
            return true;
        }
        return super.addCollisionBoxesToList(block, aabb, list, entity);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.updateClient();
        } else {
            this.updateServer();
        }
    }

    private void updateClient() {
        if (this.idcRef.trackingEntity()) {
            this.ticks = 0L;
            return;
        }
        ++this.ticks;
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        if (mop.field_72311_b == this.field_145851_c && mop.field_72312_c == this.field_145848_d && mop.field_72309_d == this.field_145849_e) {
            this.ticks = 0L;
        }
    }

    private void updateServer() {
        IDeltaChunk idc;
        if (!this.idcRef.entityFound() && this.idcRef.trackingEntity() && (idc = this.idcRef.getEntity()) != null) {
            MechanicsController.register(idc, this);
            this.executing_order = idc.hasOrderedRotation();
            this.updateComparators();
        }
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        Quaternion align;
        Quaternion rot;
        if (this.getCoord().isWeaklyPowered()) {
            return;
        }
        IDeltaChunk idc = this.idcRef.getEntity();
        if (idc == null) {
            return;
        }
        if (idc.hasOrderedRotation()) {
            return;
        }
        Quaternion w = idc.getRotationalVelocity();
        if (!w.isZero()) {
            idc.setRotationalVelocity(new Quaternion());
        }
        if ((rot = idc.getRotation()).hasNaN() || rot.hasInf() || w.hasNaN() || w.hasInf()) {
            idc.setRotation(new Quaternion());
            idc.setRotationalVelocity(new Quaternion());
            return;
        }
        double theta = rot.getAngleBetween(new Quaternion());
        if (theta < 0.031415926535897934) {
            align = new Quaternion();
        } else {
            double d = 0.39269908169872414;
            double t = d / theta;
            if (t < 0.0 || t > 1.0) {
                t = 1.0;
            }
            align = rot.slerp(new Quaternion(), t);
        }
        idc.orderTargetRotation(align, 10, Interpolation.SQUARE);
        this.executing_order = true;
    }

    @Override
    protected boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        IDeltaChunk idc = this.idcRef.getEntity();
        boolean unload = false;
        if (idc != null) {
            if (!this.isBasicallyZero(idc.getRotationalVelocity()) || !this.isBasicallyZero(idc.getRotation())) {
                return false;
            }
            unload = true;
        } else if (this.idcRef.trackingEntity()) {
            return false;
        }
        if (this.getCoord().isWeaklyPowered()) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        boolean ret = super.removedByPlayer(player, willHarvest);
        if (ret && unload) {
            MechanicsController.deregister(idc, this);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void representYoSelf() {
        super.representYoSelf();
        hingeTop = new ObjectModel(Core.getResource("models/hingeTop.obj"));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTesr(float partial) {
        BlockRenderHelper block = BlockRenderHelper.instance;
        if (this.idcRef.trackingEntity()) {
            IDeltaChunk idc = this.getIdc();
            if (idc != null) {
                ForgeDirection face = this.facing.facing;
                ForgeDirection top = this.facing.top;
                float faced = 0.5f;
                float topd = 0.0f;
                if (SpaceUtil.sign(this.facing.top) == 1) {
                    topd = 1.0f;
                }
                if (SpaceUtil.sign(this.facing.facing) == -1) {
                    faced *= -1.0f;
                }
                float dx = (float)face.offsetX * faced + (float)top.offsetX * topd;
                float dy = (float)face.offsetY * faced + (float)top.offsetY * topd;
                float dz = (float)face.offsetZ * faced + (float)top.offsetZ * topd;
                GL11.glTranslatef((float)dx, (float)dy, (float)dz);
                idc.getRotation().glRotate();
                GL11.glTranslatef((float)(-dx), (float)(-dy), (float)(-dz));
            }
            this.setupHingeRotation2();
        } else {
            this.setupHingeRotation2();
            float nowish = (float)this.ticks + partial;
            double now = (Math.cos((double)nowish / 24.0) - 1.0) * -6.0;
            GL11.glRotated((double)now, (double)0.0, (double)0.0, (double)1.0);
        }
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(Core.blockAtlas);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)32826);
        hingeTop.render(BlockIcons.mechanism$hinge_uvs);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
    }

    private void setupHingeRotation2() {
        ForgeDirection v;
        ForgeDirection face = this.facing.facing;
        ForgeDirection top = this.facing.top;
        int fsign = face.ordinal() % 2 == 0 ? -1 : 1;
        int tsign = top.ordinal() % 2 == 0 ? -1 : 1;
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        if (tsign == 1) {
            v = top;
            dx += (float)v.offsetX;
            dy += (float)v.offsetY;
            dz += (float)v.offsetZ;
        }
        if (fsign == 1) {
            v = this.facing.rotateOnFace((int)1).top;
            dx += (float)v.offsetX;
            dy += (float)v.offsetY;
            dz += (float)v.offsetZ;
        }
        GL11.glTranslatef((float)dx, (float)dy, (float)dz);
        Quaternion.fromOrientation(this.facing).glRotate();
        boolean left = false;
        if (face.offsetX != 0) {
            boolean bl = left = top == ForgeDirection.NORTH || top == ForgeDirection.UP;
        }
        if (face.offsetY != 0) {
            boolean bl = left = top == ForgeDirection.WEST || top == ForgeDirection.SOUTH;
        }
        if (face.offsetZ != 0) {
            left = top == ForgeDirection.DOWN || top == ForgeDirection.EAST;
        }
        float dleft = 0.5f;
        if (left) {
            dleft += (float)fsign;
        }
        GL11.glTranslatef((float)0.0f, (float)(0.5f * (float)fsign), (float)dleft);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int a = -2;
        int b = 3;
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c + a), (double)(this.field_145848_d + a), (double)(this.field_145849_e + a), (double)(this.field_145851_c + b), (double)(this.field_145848_d + b), (double)(this.field_145849_e + b));
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        return this.comparator_cache;
    }

    private void updateComparators() {
        byte new_val = this.comparatorMeasure();
        if (new_val == this.comparator_cache) {
            return;
        }
        this.comparator_cache = new_val;
        this.func_70296_d();
    }

    private byte comparatorMeasure() {
        if (!this.idcRef.trackingEntity()) {
            return 0;
        }
        IDeltaChunk idc = this.idcRef.getEntity();
        if (idc == null) {
            return this.comparator_cache;
        }
        double angle = Math.toDegrees(idc.getRotation().getAngleBetween(new Quaternion()));
        angle /= 90.0;
        angle = 1.0 - angle;
        return (byte)(15.0 * angle);
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }
}

