/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.FzConfig;
import factorization.util.DataUtil;
import factorization.util.FzUtil;
import factorization.util.ItemUtil;
import factorization.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BlockUndo {
    public static final String channelName = "FZ|blockundo";
    public static final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("FZ|blockundo");
    public static final BlockUndo instance = new BlockUndo();
    public static int UNDO_MAX = 6;
    public static float MAX_TRUE_SPEED_STANDARD = 0.125f;
    public static float MAX_TRUE_SPEED_TILEENTITY = 0.0625f;
    public static float ANTI_WARP_SPEED = 64.0f;
    HashMap<String, ArrayList<PlacedBlock>> recentlyPlaced = new HashMap();
    private ThreadLocal<Boolean> working = new ThreadLocal();
    private HashMap<Integer, Long> playerBreakage = new HashMap();
    private final HashMap<String, Item> cache = new HashMap();

    private BlockUndo() {
        channel.register((Object)this);
    }

    private static void send(EntityPlayer player, PlacedBlock at) {
        ByteBuf payload = Unpooled.buffer();
        at.write(payload);
        FMLProxyPacket packet = new FMLProxyPacket(payload, channelName);
        channel.sendTo(packet, (EntityPlayerMP)player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addBlockUndo(FMLNetworkEvent.ClientCustomPacketEvent event) {
        PlacedBlock at = PlacedBlock.read(event.packet.payload());
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        this.markPlacement((EntityPlayer)player, at);
    }

    private static String getName(EntityPlayer player) {
        return player.func_70005_c_() + " #" + player.field_70170_p.field_72995_K;
    }

    private static ItemStack toItem(Block b, World w, int x, int y, int z, int md) {
        Iterator iterator = b.getDrops(w, x, y, z, md, 0).iterator();
        if (iterator.hasNext()) {
            ItemStack is = (ItemStack)iterator.next();
            return is;
        }
        return null;
    }

    void markPlacement(EntityPlayer player, PlacedBlock at) {
        ArrayList<PlacedBlock> coords;
        String playerName = BlockUndo.getName(player);
        if (!this.recentlyPlaced.containsKey(playerName)) {
            coords = new ArrayList();
            this.recentlyPlaced.put(playerName, coords);
        } else {
            coords = this.recentlyPlaced.get(playerName);
        }
        Iterator<PlacedBlock> it = coords.iterator();
        while (it.hasNext()) {
            PlacedBlock c = it.next();
            WorldServer w = DimensionManager.getWorld((int)c.w);
            if (w == null || w.func_147437_c(c.x, c.y, c.z)) {
                it.remove();
                continue;
            }
            if (c.x != at.x || c.y != at.y || c.z != at.z) continue;
            it.remove();
        }
        coords.add(at);
        if (coords.size() > UNDO_MAX) {
            coords.remove(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void recordBlock(BlockEvent.PlaceEvent event) {
        if (event.player == null) {
            return;
        }
        if (event.world.field_72995_K) {
            return;
        }
        if (event.player instanceof FakePlayer) {
            return;
        }
        if (event.block.func_149712_f(event.world, event.x, event.y, event.z) <= 0.0f) {
            return;
        }
        if (PlayerUtil.isPlayerCreative(event.player)) {
            return;
        }
        int md = event.world.func_72805_g(event.x, event.y, event.z);
        int idmd = DataUtil.getId(event.block) << 4;
        ItemStack theItem = BlockUndo.toItem(event.block, event.world, event.x, event.y, event.z, md);
        PlacedBlock at = new PlacedBlock(FzUtil.getWorldDimension(event.world), event.x, event.y, event.z, idmd, theItem);
        this.markPlacement(event.player, at);
        if (!event.world.field_72995_K && event.player instanceof EntityPlayerMP) {
            BlockUndo.send((EntityPlayer)((EntityPlayerMP)event.player), at);
        }
    }

    @SubscribeEvent
    public void boostBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.working.get() != null) {
            return;
        }
        this.working.set(true);
        try {
            this.determineBreakSpeed(event);
        }
        finally {
            this.working.remove();
        }
    }

    private boolean stillBusy(EntityPlayer player) {
        Integer code = player.hashCode();
        Long last = this.playerBreakage.get(code);
        if (last == null) {
            last = -1000L;
        }
        long end = player.field_70170_p.func_82737_E() + 8L;
        return last > end;
    }

    private void markBusy(EntityPlayer player) {
        Integer code = player.hashCode();
        this.playerBreakage.put(code, player.field_70170_p.func_82737_E());
    }

    private void determineBreakSpeed(PlayerEvent.BreakSpeed event) {
        float max_true_speed;
        int y = event.y;
        if (y == -1) {
            return;
        }
        Block block = event.block;
        int md = event.metadata;
        int x = event.x;
        int z = event.z;
        EntityPlayer player = event.entityPlayer;
        if (this.stillBusy(player)) {
            return;
        }
        if (!this.canUndo((PlayerEvent)event, x, y, z, block, md)) {
            return;
        }
        float hardness = block.func_149712_f(player.field_70170_p, x, y, z);
        if (hardness < 0.0f) {
            return;
        }
        String heldName = DataUtil.getName(player.func_70694_bm());
        if (heldName == null) {
            heldName = "";
        }
        if (heldName.startsWith("TConstruct:")) {
            return;
        }
        float harvestingSpeed = ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)md) ? 30.0f : 100.0f;
        float true_speed = event.newSpeed / hardness / harvestingSpeed;
        if (true_speed > (max_true_speed = block.hasTileEntity(md) ? MAX_TRUE_SPEED_TILEENTITY : MAX_TRUE_SPEED_STANDARD)) {
            return;
        }
        float boost = max_true_speed * hardness * harvestingSpeed;
        event.newSpeed = Math.max(event.newSpeed * boost, event.newSpeed);
        event.newSpeed = Math.min(ANTI_WARP_SPEED, event.newSpeed);
    }

    private boolean canUndo(PlayerEvent event, int x, int y, int z, Block block, int metadata) {
        EntityPlayer player = event.entityPlayer;
        ArrayList<PlacedBlock> coords = this.recentlyPlaced.get(BlockUndo.getName(player));
        if (coords == null) {
            return false;
        }
        int w = FzUtil.getWorldDimension(player.field_70170_p);
        for (PlacedBlock hot : coords) {
            int idmd;
            if (hot.w != w || hot.x != x || hot.y != y || hot.z != z || (idmd = DataUtil.getId(block) << 4) != hot.idmd) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void playerRemovedBlock(BlockEvent.BreakEvent event) {
        int harvestLevel;
        EntityPlayer thePlayer = event.getPlayer();
        this.markBusy(thePlayer);
        ArrayList<PlacedBlock> coords = this.recentlyPlaced.get(BlockUndo.getName(thePlayer));
        if (coords == null) {
            return;
        }
        PlacedBlock heat = null;
        World w = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        Block block = event.block;
        int md = event.blockMetadata;
        int wDim = FzUtil.getWorldDimension(w);
        if (PlayerUtil.isPlayerCreative(thePlayer)) {
            return;
        }
        Iterator<PlacedBlock> iterator = coords.iterator();
        while (iterator.hasNext()) {
            PlacedBlock hot = iterator.next();
            if (hot.w != wDim || hot.x != x || hot.y != y || hot.z != z) continue;
            heat = hot;
            iterator.remove();
            break;
        }
        if (heat == null || !(thePlayer instanceof EntityPlayerMP)) {
            return;
        }
        if (!ItemUtil.identical(heat.orig, BlockUndo.toItem(block, w, x, y, z, md))) {
            return;
        }
        EntityPlayerMP real_player = (EntityPlayerMP)thePlayer;
        ItemStack heldItem = real_player.func_70694_bm();
        String heldName = DataUtil.getName(heldItem);
        if (heldName == null) {
            heldName = "";
        }
        if (heldName.startsWith("TConstruct:")) {
            return;
        }
        if (ForgeHooks.canToolHarvestBlock((Block)block, (int)md, (ItemStack)heldItem)) {
            return;
        }
        if (block.func_149650_a(md, thePlayer.field_70170_p.field_73012_v, 0) != DataUtil.getItem(block) && !real_player.func_70093_af() && block.func_149712_f(w, x, y, z) < 1.0f) {
            return;
        }
        String harvestTool = block.getHarvestTool(md);
        Item harvester = this.findAppropriateTool(harvestTool, harvestLevel = block.getHarvestLevel(md));
        if (harvester == null) {
            return;
        }
        event.setCanceled(true);
        ItemStack tool = new ItemStack(harvester);
        tool.func_77964_b(tool.func_77958_k());
        tool.func_77966_a(Enchantment.field_77348_q, 1);
        tool.field_77994_a = 0;
        EntityPlayer fake_player = PlayerUtil.makePlayer(new Coord(w, x, y, z), "BlockUndo");
        fake_player.func_70062_b(0, tool);
        double r = 0.5;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)x - r), (double)((double)y - r), (double)((double)z - r), (double)((double)(x + 1) + r), (double)((double)(y + 1) + r), (double)((double)(z + 1) + r));
        block.func_149681_a(w, x, y, z, md, fake_player);
        boolean canDestroy = block.removedByPlayer(w, fake_player, x, y, z, true);
        if (canDestroy) {
            block.func_149664_b(w, x, y, z, md);
        }
        block.func_149636_a(w, fake_player, x, y, z, md);
        if (canDestroy) {
            int xp = block.getExpDrop((IBlockAccess)w, md, 0);
            block.func_149657_c(w, x, y, z, xp);
        }
        if (FzConfig.blockundo_grab) {
            for (Object o : w.func_72872_a(EntityItem.class, box)) {
                EntityItem ei = (EntityItem)o;
                int orig_delay = ei.field_145804_b;
                ei.field_145804_b = 0;
                ei.func_70100_b_((EntityPlayer)real_player);
                ei.field_145804_b = orig_delay;
            }
        }
        PlayerUtil.recycleFakePlayer(fake_player);
    }

    private Item findAppropriateTool(String tool, int level) {
        if (tool == null && level == -1) {
            return Items.field_151046_w;
        }
        String name = tool + "#" + level;
        Item ret = this.cache.get(name);
        if (ret != null) {
            return ret;
        }
        if (this.cache.containsKey(name)) {
            return null;
        }
        for (Object obj : Item.field_150901_e) {
            ItemStack dummy;
            Item item = (Item)obj;
            if (!item.getToolClasses(dummy = new ItemStack(item)).contains(tool) || item.getHarvestLevel(dummy, tool) < level) continue;
            this.cache.put(name, item);
            return item;
        }
        this.cache.put(name, null);
        return null;
    }

    private static class PlacedBlock {
        final int w;
        final int x;
        final int y;
        final int z;
        final int idmd;
        final ItemStack orig;

        private PlacedBlock(int w, int x, int y, int z, int idmd, ItemStack orig) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
            this.idmd = idmd;
            this.orig = orig;
        }

        public String toString() {
            return this.x + " " + this.z;
        }

        void write(ByteBuf out) {
            out.writeInt(this.w);
            out.writeInt(this.x);
            out.writeInt(this.y);
            out.writeInt(this.z);
            out.writeInt(this.idmd);
            ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.orig);
        }

        static PlacedBlock read(ByteBuf in) {
            return new PlacedBlock(in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), ByteBufUtils.readItemStack((ByteBuf)in));
        }
    }
}

