/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteOrder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.TesselatorVertexState;

public class ExporterTessellatorObj
extends Tessellator {
    final File filename;
    OutputStreamWriter out;
    int vertexNumber = 0;
    double field_78403_j;
    double field_78404_k;

    public ExporterTessellatorObj(File filename) {
        this.filename = filename;
        try {
            this.out = new OutputStreamWriter(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    void writeLine(String line) {
        try {
            this.out.write(line + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void func_78371_b(int par1) {
    }

    public int func_78381_a() {
        return 0;
    }

    public void doneDumping() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.out = null;
        this.dumpTextureMap();
    }

    void dumpTextureMap() {
    }

    public void func_78385_a(double textureU, double textureV) {
        this.field_78403_j = textureU;
        this.field_78404_k = -textureV;
    }

    public void func_78377_a(double x, double y, double z) {
        x += this.field_78408_v;
        y += this.field_78407_w;
        z += this.field_78417_x;
        if (this.field_78399_n) {
            float a;
            float b;
            float g;
            float r;
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                r = this.field_78402_m & 0xFF;
                g = this.field_78402_m >> 8 & 0xFF;
                b = this.field_78402_m >> 16 & 0xFF;
                a = this.field_78402_m >> 24 & 0xFF;
            } else {
                a = this.field_78402_m & 0xFF;
                b = this.field_78402_m >> 8 & 0xFF;
                g = this.field_78402_m >> 16 & 0xFF;
                r = this.field_78402_m >> 24 & 0xFF;
            }
            this.writeLine("v " + x + " " + y + "  " + z + " " + (r /= 255.0f) + " " + (g /= 255.0f) + " " + (b /= 255.0f) + " " + (a /= 255.0f));
        } else {
            this.writeLine("v " + x + " " + y + "  " + z);
        }
        this.writeLine("vt " + this.field_78403_j + " " + this.field_78404_k);
        ++this.vertexNumber;
        if (this.vertexNumber % 4 == 0) {
            this.writeLine("f" + this.make(-3) + this.make(-2) + this.make(-1) + this.make(0));
        }
    }

    private String make(int delta) {
        int i = this.vertexNumber + delta;
        if (i <= 0) {
            throw new IllegalArgumentException("Invalid index");
        }
        return " " + i + "/" + i;
    }

    public TesselatorVertexState func_147564_a(float posX, float posY, float posZ) {
        if (this.field_147569_p <= 0) {
            return null;
        }
        return super.func_147564_a(posX, posY, posZ);
    }
}

