/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.TesselatorVertexState;

public class ExporterTessellatorPly
extends Tessellator {
    final File filename;
    final File tmp_vert;
    final File tmp_face;
    OutputStreamWriter vertices;
    OutputStreamWriter faces;
    double field_78403_j;
    double field_78404_k;
    int r;
    int g;
    int b;
    int a;
    int vertexNumber = 0;

    public ExporterTessellatorPly(File filename) {
        this.filename = filename;
        this.tmp_vert = new File(this.filename + ".tmp_vert");
        this.tmp_face = new File(this.filename + ".tmp_face");
        try {
            this.vertices = new OutputStreamWriter(new FileOutputStream(this.tmp_vert));
            this.faces = new OutputStreamWriter(new FileOutputStream(this.tmp_face));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    void finish() throws IOException {
        this.vertices.close();
        this.faces.close();
        FileOutputStream fos = new FileOutputStream(this.filename);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        out.write("ply\n");
        out.write("format ascii 1.0\n");
        out.write("comment Exported by Factorization\n");
        out.write("element vertex " + this.vertexNumber + "\n");
        out.write("property float x\n");
        out.write("property float y\n");
        out.write("property float z\n");
        out.write("property float s\n");
        out.write("property float t\n");
        out.write("property uchar red\n");
        out.write("property uchar green\n");
        out.write("property uchar blue\n");
        out.write("property uchar alpha\n");
        out.write("element face " + this.vertexNumber / 4 + "\n");
        out.write("property list uchar uint vertex_indices\n");
        out.write("end_header\n");
        out.flush();
        this.append(fos, this.tmp_vert);
        this.append(fos, this.tmp_face);
        out.close();
        this.tmp_vert.delete();
        this.tmp_face.delete();
    }

    private void append(FileOutputStream out, File filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        byte[] buff = new byte[1024];
        while (true) {
            int got;
            if ((got = in.read(buff)) == -1) {
                in.close();
                return;
            }
            out.write(buff, 0, got);
        }
    }

    void vert(String line) {
        try {
            this.vertices.write(line);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void face(String line) {
        try {
            this.faces.write(line);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void func_78371_b(int shapeKind) {
        if (shapeKind != 7) {
            throw new RuntimeException("This tessellator can only handle GL_QUADS");
        }
        this.a = 255;
        this.b = 255;
        this.g = 255;
        this.r = 255;
    }

    public int func_78381_a() {
        return 0;
    }

    public void doneDumping() {
        try {
            this.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void func_78385_a(double textureU, double textureV) {
        this.field_78403_j = textureU;
        this.field_78404_k = textureV;
    }

    public void func_78370_a(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void func_78377_a(double x, double y, double z) {
        this.vert(x + " " + z + " " + y + " " + this.field_78403_j + " " + (1.0 - this.field_78404_k) + " " + this.r + " " + this.g + " " + this.b + " " + this.a + "\n");
        if (this.vertexNumber % 4 == 0) {
            this.face("4" + this.make(-1) + this.make(-2) + this.make(-3) + this.make(-4) + "\n");
        }
        ++this.vertexNumber;
    }

    private String make(int delta) {
        return " " + (this.vertexNumber + delta);
    }

    public TesselatorVertexState func_147564_a(float posX, float posY, float posZ) {
        if (this.field_147569_p <= 0) {
            return null;
        }
        return super.func_147564_a(posX, posY, posZ);
    }
}

