/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import factorization.util.ItemUtil;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ItemMover {
    static final int CLICK_BUTTON = 0;
    static final int MODE = 0;

    public static void moveItems(EntityPlayer player, int slotId, int motion) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Slot slot = player.field_71070_bA.func_75139_a(slotId);
        if (slot == null) {
            return;
        }
        ItemStack search = ItemUtil.normalize(slot.func_75211_c());
        if (search == null) {
            return;
        }
        if (motion == 0) {
            return;
        }
        InventoryPlayer pinv = player.field_71071_by;
        if (pinv.func_70445_o() != null) {
            return;
        }
        ItemStack buffer = null;
        int amount = Math.abs(motion);
        if (!slot.func_82869_a(player) || !slot.func_75214_a(search)) {
            return;
        }
        Slot stock = ItemMover.getRestockSlot(player, slot, search);
        if (motion <= -1) {
            buffer = ItemMover.leave(slot, amount);
            if (buffer == null && ItemUtil.normalize(slot.func_75211_c()) == null) {
                return;
            }
            player.field_71070_bA.func_82846_b(player, slotId);
            if (pinv.func_70445_o() == null && buffer != null) {
                pinv.func_70437_b(buffer);
                buffer = null;
                player.field_71070_bA.func_75144_a(slotId, 0, 0, player);
            }
        } else if (motion >= 1) {
            if (stock == null) {
                return;
            }
            ItemStack stockStack = ItemUtil.normalize(stock.func_75211_c());
            if (stockStack == null) {
                return;
            }
            int free = ItemUtil.getFreeSpace(search, 64);
            amount = Math.min(free, amount);
            if (amount <= 0) {
                return;
            }
            buffer = ItemMover.leave(stock, amount);
            if (buffer == null && ItemUtil.normalize(stock.func_75211_c()) == null) {
                return;
            }
            player.field_71070_bA.func_75144_a(stock.field_75222_d, 0, 0, player);
            if (pinv.func_70445_o() != null) {
                player.field_71070_bA.func_75144_a(slotId, 0, 0, player);
                if (pinv.func_70445_o() == null && buffer != null) {
                    pinv.func_70437_b(buffer);
                    buffer = null;
                    player.field_71070_bA.func_75144_a(stock.field_75222_d, 0, 0, player);
                } else if (pinv.func_70445_o() != null) {
                    ItemStack held = pinv.func_70445_o();
                    if (ItemUtil.couldMerge(held, buffer)) {
                        held.field_77994_a += ItemUtil.getStackSize(buffer);
                        buffer = null;
                    }
                    if (stock.func_75211_c() == null) {
                        player.field_71070_bA.func_75144_a(stock.field_75222_d, 0, 0, player);
                    }
                }
            }
        }
        if (buffer != null) {
            if (pinv.func_70445_o() == null) {
                pinv.func_70437_b(buffer);
            } else {
                player.func_71019_a(buffer, true);
            }
        }
        if (pinv.func_70445_o() != null) {
            ItemMover.updateHeldItem(player);
        }
    }

    private static void updateHeldItem(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71113_k();
        }
    }

    private static int reevaluateMotion(Slot slot, EntityPlayer player, int motion) {
        if (slot.field_75224_c == player.field_71071_by) {
            return -motion;
        }
        return motion;
    }

    private static ItemStack leave(Slot slot, int amount) {
        int avail = slot.func_75211_c().field_77994_a;
        int toTake = avail - amount;
        if (toTake <= 0) {
            return null;
        }
        return slot.func_75209_a(toTake);
    }

    private static Slot getRestockSlot(EntityPlayer player, Slot src, ItemStack search) {
        ArrayList<Slot> foreign = new ArrayList<Slot>();
        ArrayList<Slot> local = new ArrayList<Slot>();
        for (Slot slot : player.field_71070_bA.field_75151_b) {
            if (!ItemUtil.identical(search, slot.func_75211_c()) || !slot.func_82869_a(player) || !slot.func_75214_a(search)) continue;
            if (slot.field_75224_c == src.field_75224_c) {
                if (slot == src) continue;
                local.add(slot);
                continue;
            }
            foreign.add(slot);
        }
        if (!foreign.isEmpty()) {
            return (Slot)foreign.get(0);
        }
        if (!local.isEmpty()) {
            return (Slot)local.get(0);
        }
        return null;
    }
}

