/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import com.google.common.base.Joiner;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.aabbdebug.AabbDebugger;
import factorization.api.Coord;
import factorization.common.FzConfig;
import factorization.misc.BlockUpdateDebugger;
import factorization.misc.ExporterTessellatorObj;
import factorization.misc.ExporterTessellatorPly;
import factorization.misc.LagssieWatchDog;
import factorization.misc.WireframeTessellator;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.shared.Core;
import factorization.util.FzUtil;
import factorization.util.RenderUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class MiscClientCommands
implements ICommand {
    static final Minecraft mc = Minecraft.func_71410_x();
    static int queued_action = 0;
    static int queue_delay = 0;
    static final int SHOW_MODS_LIST = 1;
    static final int CLEAR_CHAT = 2;

    public int compareTo(ICommand other) {
        return this.func_71517_b().compareTo(other.func_71517_b());
    }

    public int compareTo(Object obj) {
        return this.compareTo((ICommand)obj);
    }

    public String func_71517_b() {
        return FzConfig.f;
    }

    public List func_71514_a() {
        return null;
    }

    public boolean func_71519_b(ICommandSender player) {
        return true;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args == null || args.length == 0) {
            args = new String[]{"help"};
        }
        ArrayList<String> better = new ArrayList<String>();
        for (String arg : args) {
            if (arg == null || arg.length() == 0) continue;
            better.add(arg);
        }
        this.runCommand(better);
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/" + FzConfig.f + " <subcommand, such as 'help' or 'list'>";
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        try {
            if (args.length == 1) {
                String arg0 = args[0];
                ArrayList<String> availCommands = new ArrayList<String>(50);
                availCommands.addAll(Arrays.asList("0", "1", "2", "3", "4", "+", ""));
                for (Method method : miscCommands.class.getMethods()) {
                    if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0) continue;
                    availCommands.add(method.getName());
                    alias a = method.getAnnotation(alias.class);
                    if (a == null) continue;
                    for (String name : a.value()) {
                        availCommands.add(name);
                    }
                }
                LinkedList<String> ret = new LinkedList<String>();
                for (String name : availCommands) {
                    if (!name.startsWith(arg0)) continue;
                    ret.add(name);
                }
                return ret;
            }
        }
        catch (Throwable e) {
            Core.logWarning("Wasn't able to do tab completion!", new Object[0]);
            e.printStackTrace();
            return Arrays.asList("tab_completion_failed");
        }
        return new LinkedList();
    }

    void runCommand(List<String> args) {
        try {
            String n;
            if (args == null) {
                args = new ArrayList<String>();
            }
            if (args.size() == 0) {
                args = Arrays.asList("help");
                n = "help";
            } else {
                n = args.get(0);
            }
            int i = MiscClientCommands.mc.field_71474_y.field_151451_c;
            boolean found_number = true;
            if (n.equalsIgnoreCase("+")) {
                ++i;
            } else if (n.equalsIgnoreCase("-")) {
                --i;
            } else {
                try {
                    i = Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    found_number = false;
                }
            }
            if (found_number) {
                if (i < 1) {
                    i = 1;
                }
                if (i > 16) {
                    i = 16;
                }
                MiscClientCommands.mc.field_71474_y.field_151451_c = i;
                return;
            }
            if (n.equalsIgnoreCase("bug")) {
                this.addBugReport(args);
                return;
            }
            for (Method method : miscCommands.class.getMethods()) {
                if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0) continue;
                if (method.getName().equals(n)) {
                    this.tryCall(method, args);
                    return;
                }
                alias a = method.getAnnotation(alias.class);
                if (a == null) continue;
                for (String an : a.value()) {
                    if (!an.equals(n)) continue;
                    this.tryCall(method, args);
                    return;
                }
            }
            MiscClientCommands.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Unknown command. Try /" + FzConfig.f + " list."));
        }
        catch (Exception e) {
            MiscClientCommands.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Command failed; see console"));
            e.printStackTrace();
        }
    }

    private void addBugReport(List<String> args) {
        String msg = "[" + Calendar.getInstance().getTime().toString() + "]";
        for (String arg : args) {
            if (arg == args.get(0)) continue;
            msg = msg + " " + arg;
        }
        if (msg.isEmpty()) {
            return;
        }
        try {
            File target = new File("/media/media/fbugs");
            BufferedWriter out = new BufferedWriter(new FileWriter(target, true));
            out.append(msg + "\n");
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static boolean commandAllowed(Method method) {
        boolean canCheat;
        if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0) {
            return false;
        }
        boolean bl = canCheat = MiscClientCommands.mc.field_71439_g.field_71075_bZ.field_75098_d && mc.func_71356_B();
        if (canCheat) {
            return true;
        }
        if (method.getAnnotation(sketchy.class) != null && !FzConfig.enable_sketchy_client_commands) {
            return false;
        }
        return method.getAnnotation(cheaty.class) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryCall(Method method, List<String> args) {
        if (!MiscClientCommands.commandAllowed(method)) {
            MiscClientCommands.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("That command is disabled"));
            return;
        }
        try {
            miscCommands.player = MiscClientCommands.mc.field_71439_g;
            miscCommands.arg0 = args.get(0);
            if (args.size() >= 2) {
                miscCommands.arg1 = args.get(1);
            }
            miscCommands.args = args;
            Object ret = method.invoke(null, new Object[0]);
            if (ret != null) {
                MiscClientCommands.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(ret.toString()));
            }
        }
        catch (Exception e) {
            MiscClientCommands.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Caught an exception from command; see console"));
            e.printStackTrace();
        }
        finally {
            miscCommands.player = null;
            miscCommands.arg1 = null;
            miscCommands.arg0 = null;
        }
    }

    static void tick() {
        if (queued_action == 0) {
            return;
        }
        if (queue_delay > 0) {
            --queue_delay;
            return;
        }
        switch (queued_action) {
            case 2: {
                ArrayList cp = new ArrayList();
                cp.addAll(MiscClientCommands.mc.field_71456_v.func_146158_b().func_146238_c());
                MiscClientCommands.mc.field_71456_v.func_146158_b().func_146231_a();
                MiscClientCommands.mc.field_71456_v.func_146158_b().func_146238_c().addAll(cp);
                new Notice(MiscClientCommands.mc.field_71439_g, "", new String[0]).withStyle(Style.CLEAR).send((EntityPlayer)MiscClientCommands.mc.field_71439_g);
                break;
            }
            case 1: {
                mc.func_147108_a((GuiScreen)new GuiModList(null));
            }
        }
        queued_action = 0;
    }

    public static class miscCommands {
        static EntityClientPlayerMP player;
        static String arg0;
        static String arg1;
        static List<String> args;
        static Tessellator orig;
        static Map backup;
        static Map empty;
        private static int active_world_hash;
        private static IWorldAccess debugger;

        @alias(value={"date", "time"})
        @help(value="Show the real-world time. Notes can be added.")
        public static String now() {
            DateFormat df = DateFormat.getTimeInstance(3);
            String ret = "[" + df.format(new Date()) + "]";
            args.remove(0);
            if (!args.isEmpty()) {
                ret = ret + " " + Joiner.on((String)" ").join(args);
            }
            return ret;
        }

        @alias(value={"help", "?"})
        public static void about() {
            player.func_145747_a((IChatComponent)new ChatComponentText("Miscellaneous Client Commands; from Factorization, by neptunepink"));
            player.func_145747_a((IChatComponent)new ChatComponentText("Use /" + FzConfig.f + " list go see the sub-commands."));
        }

        @help(value="Lists available subcommands. Can also search the list.")
        public static void list() {
            String em = "" + EnumChatFormatting.GREEN;
            for (Method method : miscCommands.class.getMethods()) {
                help h;
                if (!MiscClientCommands.commandAllowed(method)) continue;
                String msg = em + method.getName() + EnumChatFormatting.RESET;
                alias a = method.getAnnotation(alias.class);
                if (a != null) {
                    for (String v : a.value()) {
                        msg = msg + ", " + em + v + EnumChatFormatting.RESET;
                    }
                }
                if ((h = method.getAnnotation(help.class)) != null) {
                    msg = msg + ": " + h.value();
                }
                if (method.getAnnotation(sketchy.class) != null) {
                    msg = msg + EnumChatFormatting.DARK_GRAY + " [SKETCHY]";
                }
                if (method.getAnnotation(cheaty.class) != null) {
                    msg = msg + EnumChatFormatting.RED + " [CHEATY]";
                }
                if (arg1 != null && arg1.length() != 0 && !msg.contains(arg1)) continue;
                player.func_145747_a((IChatComponent)new ChatComponentText(msg));
            }
            String msg = "";
            boolean first = true;
            for (String v : new String[]{"0", "1", "2", "3", "4", "+", "-"}) {
                if (!first) {
                    msg = msg + ", ";
                }
                first = false;
                msg = msg + em + v + EnumChatFormatting.RESET;
            }
            msg = msg + ": Changes the fog";
            if (arg1 == null || arg1.length() == 0 || msg.contains(arg1)) {
                player.func_145747_a((IChatComponent)new ChatComponentText(msg));
            }
        }

        @alias(value={"cl"})
        @help(value="Erases the chat window")
        public static void clear() {
            queued_action = 2;
            queue_delay = 10;
        }

        @sketchy
        @help(value="Reveals your coordinates in-chat")
        public static void saycoords() {
            String append = "";
            if (args.size() > 1) {
                append = ": ";
                for (int i = 1; i < args.size(); ++i) {
                    append = append + args.get(i) + " ";
                }
            }
            player.func_71165_d("/me is at " + (int)miscCommands.player.field_70165_t + ", " + (int)miscCommands.player.field_70163_u + ", " + (int)miscCommands.player.field_70161_v + " in dimension " + miscCommands.player.field_70170_p.field_73011_w.field_76574_g + append);
        }

        @alias(value={"ss"})
        @help(value="Saves game settings. (Vanilla seems to need help with this.)")
        public static String savesettings() {
            MiscClientCommands.mc.field_71474_y.func_74303_b();
            return "Saved settings";
        }

        @alias(value={"render_everything_lagfest"})
        @help(value="Render a ton of terrain at once (may lock your game up for a while)")
        public static void render_above() {
            WorldRenderer[] lizt = MiscClientCommands.mc.field_71438_f.field_72768_k;
            int did = 0;
            int total = 0;
            boolean lagfest = arg0.contains("lagfest");
            for (WorldRenderer wr : lizt) {
                ++total;
                if (!wr.field_78939_q || !((double)(wr.field_78920_d - 48) > MiscClientCommands.mc.field_71439_g.field_70163_u && (double)wr.field_78920_d < MiscClientCommands.mc.field_71439_g.field_70163_u + 128.0) && !lagfest) continue;
                wr.func_147892_a((EntityLivingBase)MiscClientCommands.mc.field_71439_g);
                wr.field_78939_q = false;
                ++did;
            }
            player.func_145747_a((IChatComponent)new ChatComponentText("Rendered " + did + " chunks out of " + total));
        }

        @alias(value={"c"})
        @help(value="Switch between creative and survival mode")
        public static void creative() {
            player.func_71165_d("/gamemode " + (miscCommands.player.field_71075_bZ.field_75098_d ? 0 : 1));
        }

        @alias(value={"n", "makenice"})
        @help(value="Makes it a sunny morning")
        public static void nice() {
            double angle;
            if (miscCommands.player.field_70170_p.func_72896_J()) {
                player.func_71165_d("/weather clear");
            }
            if ((angle = (double)(miscCommands.player.field_70170_p.func_72826_c(0.0f) % 360.0f)) < 45.0 || angle > 135.0) {
                player.func_71165_d("/time set 1200");
            }
            miscCommands.clear();
        }

        @help(value="Makes it day")
        public static void day() {
            player.func_71165_d("/time set 1200");
        }

        @help(value="Makes it night")
        public static void night() {
            player.func_71165_d("/time set 18000");
        }

        @help(value="Shows the mods screen")
        @SideOnly(value=Side.CLIENT)
        public static void mods() {
            queued_action = 1;
        }

        @cheaty
        @alias(value={"neo", "deneo", "deninja"})
        @help(value="Makes the world run slowly (single-player client-side only). Can specify custom timerSpeed.")
        public static String ninja() {
            if (mc.func_71356_B()) {
                float tps;
                if (arg0.startsWith("de")) {
                    tps = 1.0f;
                } else {
                    tps = 0.5f;
                    try {
                        tps = Float.parseFloat(arg1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                tps = Math.max(0.1f, tps);
                MiscClientCommands.mc.field_71428_T.field_74278_d = tps = Math.min(1.0f, tps);
                if (arg0.contains("neo")) {
                    if (tps == 1.0f) {
                        return "Go back to sleep, Neo.";
                    }
                    return "Wake up, Neo.";
                }
            }
            return null;
        }

        @help(value="Sets the watchdog waitInterval")
        public static String watchdog() {
            if (LagssieWatchDog.instance == null) {
                return "Watchdog disabled. Enable in config, or use /" + FzConfig.f + " startwatchdog";
            }
            if (arg1 == null) {
                return "Usage: /" + FzConfig.f + " watchdog [waitInterval=" + LagssieWatchDog.instance.sleep_time + "]";
            }
            LagssieWatchDog.instance.sleep_time = Double.parseDouble(arg1);
            return "Set waitInterval to " + LagssieWatchDog.instance.sleep_time;
        }

        @help(value="Starts the watchdog")
        public static String startwatchdog() {
            if (LagssieWatchDog.instance == null) {
                FzConfig.lagssie_watcher = true;
                LagssieWatchDog.start();
                return "Started watchdog.";
            }
            return "Watchdog already running.";
        }

        @alias(value={"td"})
        @help(value="Sets the minimum time dilation (between 0.1 and 1), or disables it (0)")
        public static String timedilation() {
            if (arg1 == null) {
                String msg = "Current time dilation: " + MiscClientCommands.mc.field_71428_T.field_74278_d;
                if (!FzConfig.use_tps_reports) {
                    msg = msg + " ";
                    msg = msg + "(Disabled)";
                }
                return msg;
            }
            float dilation = Float.parseFloat(arg1);
            if (dilation <= 0.0f) {
                FzConfig.use_tps_reports = false;
                return "Time dilation disabled";
            }
            dilation = Math.max(0.1f, dilation);
            FzConfig.lowest_dilation = dilation = Math.min(1.0f, dilation);
            if (!FzConfig.use_tps_reports) {
                FzConfig.use_tps_reports = true;
                return "Enabled time dilation at " + dilation;
            }
            return "Set minimum time dilation to " + dilation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @cheaty
        @help(value="Saves terrain to a 3D model. Slow! Watch the console. /f exportWorld [radius] --ply --obj --player-origin --world-origin")
        public static String exportWorld() {
            double maxDist = MiscClientCommands.mc.field_71474_y.field_151451_c * 16;
            if (!StringUtils.func_151246_b((String)arg1)) {
                try {
                    maxDist = Double.parseDouble(arg1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            WorldRenderer[] lizt = MiscClientCommands.mc.field_71438_f.field_72768_k;
            Tessellator real_tess = Tessellator.field_78398_a;
            boolean use_ply = true;
            boolean at_player = true;
            for (String arg : args) {
                if (arg.equalsIgnoreCase("--ply")) {
                    use_ply = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("--obj")) {
                    use_ply = false;
                    continue;
                }
                if (arg.equals("--player-origin")) {
                    at_player = true;
                    continue;
                }
                if (!arg.equals("--world-origin")) continue;
                at_player = false;
            }
            File output = new File("./worldExport." + (use_ply ? "ply" : "obj"));
            try {
                ExporterTessellatorObj ex_obj = null;
                ExporterTessellatorPly ex_ply = null;
                if (use_ply) {
                    ex_ply = new ExporterTessellatorPly(output);
                    Tessellator.field_78398_a = ex_ply;
                } else {
                    ex_obj = new ExporterTessellatorObj(output);
                    Tessellator.field_78398_a = ex_obj;
                }
                int total = lizt.length;
                double px = MiscClientCommands.mc.field_71439_g.field_70165_t;
                double py = MiscClientCommands.mc.field_71439_g.field_70163_u;
                double pz = MiscClientCommands.mc.field_71439_g.field_70161_v;
                int skipped = 0;
                for (int i = 0; i < total; ++i) {
                    WorldRenderer wr = lizt[i];
                    double dx = (double)wr.field_78923_c - px;
                    double dy = (double)wr.field_78920_d - py;
                    double dz = (double)wr.field_78921_e - pz;
                    Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    if (dist > maxDist) {
                        ++skipped;
                        continue;
                    }
                    System.out.println("Writing chunk " + i + "/" + total + " at " + wr.field_78923_c + " " + wr.field_78920_d + " " + wr.field_78921_e);
                    wr.func_78914_f();
                    wr.func_147892_a((EntityLivingBase)MiscClientCommands.mc.field_71439_g);
                }
                System.out.println("Skipped " + skipped + " chunks outside the render distance");
                if (use_ply) {
                    ex_ply.doneDumping();
                } else {
                    ex_obj.doneDumping();
                }
            }
            finally {
                Tessellator.field_78398_a = real_tess;
            }
            return "Done!";
        }

        @cheaty
        @help(value="Re-renders the chunk as a wireframe")
        public static String wireframe() {
            WorldRenderer[] lizt = MiscClientCommands.mc.field_71438_f.field_72768_k;
            double px = MiscClientCommands.mc.field_71439_g.field_70165_t;
            double py = MiscClientCommands.mc.field_71439_g.field_70163_u;
            double pz = MiscClientCommands.mc.field_71439_g.field_70161_v;
            for (WorldRenderer wr : lizt) {
                if (!((double)wr.field_78918_f < px) || !(px < (double)wr.field_78925_n) || !((double)wr.field_78919_g < py) || !(py < (double)wr.field_78926_o) || !((double)wr.field_78931_h < pz) || !(pz < (double)wr.field_78940_p)) continue;
                Tessellator real_tess = Tessellator.field_78398_a;
                Tessellator.field_78398_a = new WireframeTessellator();
                wr.func_78914_f();
                wr.func_147892_a((EntityLivingBase)MiscClientCommands.mc.field_71439_g);
                Tessellator.field_78398_a = real_tess;
                return null;
            }
            return "You aren't in a rendering chunk. Remarkable.";
        }

        @cheaty
        @help(value="Render all the things with a wireframe")
        public static String wireframeGlobal() {
            if (orig == null) {
                orig = Tessellator.field_78398_a;
                Tessellator.field_78398_a = new WireframeTessellator();
                return "Run the command again to disable. Note that some effects may persist until MC is restarted.";
            }
            Tessellator.field_78398_a = orig;
            orig = null;
            return "Restored normal Tessellator";
        }

        @help(value="Disable or enable TileEntity special renderers")
        public static String tesrtoggle() {
            if (backup == null) {
                if (TileEntityRendererDispatcher.field_147556_a.field_147559_m == null) {
                    return "no TESRs!";
                }
                backup = TileEntityRendererDispatcher.field_147556_a.field_147559_m;
                TileEntityRendererDispatcher.field_147556_a.field_147559_m = empty;
                return "TESRs disabled";
            }
            empty.clear();
            TileEntityRendererDispatcher.field_147556_a.field_147559_m = backup;
            backup = null;
            return "TESRs enabled; requires chunk update to restart drawing";
        }

        @help(value="Change how large servo instructions are rendered. (This also has a config option.)")
        public static String servoInstructionSize() {
            FzConfig.large_servo_instructions = !FzConfig.large_servo_instructions;
            return "Servo instruction size toggled; requires a chunk update to redraw.";
        }

        @help(value="Sets doDaylightCycle, doMobSpawning, weather, time")
        public static void setupSterileTestWorld() {
            player.func_71165_d("/gamerule doDaylightCycle false");
            player.func_71165_d("/gamerule doMobSpawning false");
            player.func_71165_d("/weather clear 999999");
            player.func_71165_d("/time set 1200");
            MinecraftServer ms = MinecraftServer.func_71276_C();
            if (ms == null) {
                return;
            }
            if (ms.field_71305_c == null) {
                return;
            }
            for (WorldServer w : ms.field_71305_c) {
                for (Entity ent : w.field_72996_f) {
                    if (ent instanceof EntityLiving) {
                        ent.func_70106_y();
                        continue;
                    }
                    if (!(ent instanceof EntityItem)) continue;
                    ent.func_70106_y();
                }
            }
        }

        @help(value="Pass an /f command to the server (for Factions; but see FZ's config)")
        @alias(value={"/f"})
        public static void factions() {
            String cmd = "";
            boolean first = true;
            for (String c : args) {
                if (first) {
                    first = false;
                    cmd = c;
                    continue;
                }
                cmd = cmd + " " + c;
            }
            player.func_71165_d(cmd);
        }

        @help(value="Copy the unlocalized name of the held item to the clipboard")
        public static String copylocalkey() {
            ItemStack is = MiscClientCommands.mc.field_71439_g.func_70694_bm();
            if (is == null) {
                return "Not holding anything";
            }
            String name = is.func_77977_a();
            if (name == null) {
                return "Item has no localization key!";
            }
            if (name.isEmpty()) {
                return "Item's localization key is empty!";
            }
            FzUtil.copyStringToClipboard(name);
            return "Copied to clipboard: " + name;
        }

        @help(value="Copy the internal name of the held item to the clipboard")
        public static String copyname() {
            ItemStack is = MiscClientCommands.mc.field_71439_g.func_70694_bm();
            if (is == null) {
                return "Not holding anything";
            }
            String name = Item.field_150901_e.func_148750_c((Object)is.func_77973_b());
            FzUtil.copyStringToClipboard(name);
            return "Copied to clipboard: " + name;
        }

        @help(value="Marks nearby fake air blocks")
        public static void checkFakeAir() {
            Coord at = new Coord((Entity)MiscClientCommands.mc.field_71439_g);
            int d = 3;
            for (int dz = -d; dz <= d; ++dz) {
                for (int dy = -d; dy <= d; ++dy) {
                    for (int dx = -d; dx <= d; ++dx) {
                        Coord here = at.add(dx, dy, dz);
                        if (!here.isAir() || here.getBlock() == Blocks.field_150350_a) continue;
                        new Notice(here, "X", new String[0]).withStyle(Style.FORCE).send((EntityPlayer)MiscClientCommands.mc.field_71439_g);
                    }
                }
            }
        }

        @help(value="Generate random values")
        public static String rng() {
            Random rng;
            String coin = "TF";
            String dirs = "\u2b05\u2b06\u2b07\u27a1";
            String blocks = "\u2591\u2580\u2584\u2588";
            String[] woods = new String[]{"Oak", "Spruce", "Birch", "Jungle", "Dark Oak", "Acacia"};
            String[] tc4 = new String[]{"Earth", "Air", "Fire", "Water", "Order", "Chaos"};
            String iching = "\u4dc0\u4dc1\u4dc2\u4dc3\u4dc4\u4dc5\u4dc6\u4dc7\u4dc8\u4dc9\u4dca\u4dcb\u4dcc\u4dcd\u4dce\u4dcf\u4dd0\u4dd1\u4dd2\u4dd3\u4dd4\u4dd5\u4dd6\u4dd7\u4dd8\u4dd9\u4dda\u4ddb\u4ddc\u4ddd\u4dde\u4ddf\u4de0\u4de1\u4de2\u4de3\u4de4\u4de5\u4de6\u4de7\u4de8\u4de9\u4dea\u4deb\u4dec\u4ded\u4dee\u4def\u4df0\u4df1\u4df2\u4df3\u4df4\u4df5\u4df6\u4df7\u4df8\u4df9\u4dfa\u4dfb\u4dfc\u4dfd\u4dfe\u4dff";
            if (arg1 == null) {
                rng = new Random();
            } else {
                long seed;
                try {
                    seed = Long.parseLong(arg1);
                }
                catch (NumberFormatException e) {
                    seed = arg1.hashCode();
                }
                rng = new Random(seed);
            }
            return miscCommands.pick(coin, rng) + " " + miscCommands.pick(dirs, rng) + " " + miscCommands.pick(blocks, rng, 8) + " " + miscCommands.pick(rng, woods) + " " + rng.nextFloat() + " " + miscCommands.pick(iching, rng) + " " + miscCommands.pick(rng, tc4);
        }

        private static String pick(String s, Random rng) {
            int i = rng.nextInt(s.length());
            return s.substring(i, i + 1);
        }

        private static String pick(String s, Random rng, int n) {
            String bs = "";
            for (int i = 0; i < n; ++i) {
                bs = bs + miscCommands.pick(s, rng);
            }
            return bs;
        }

        private static String pick(Random rng, String ... args) {
            return args[rng.nextInt(args.length)];
        }

        @help(value="Temp-fix for the entity interaction bug")
        public static String mc2713() {
            int failed = 0;
            WorldClient world = MiscClientCommands.mc.field_71441_e;
            block0: for (Entity ent : world.field_72996_f) {
                Chunk chunk = world.func_72964_e(ent.field_70176_ah, ent.field_70164_aj);
                for (Entity e : chunk.field_76645_j[ent.field_70162_ai]) {
                    if (e != ent) continue;
                    continue block0;
                }
                ++failed;
                chunk.func_76612_a(ent);
            }
            if (failed == 0) {
                return "No broken entities; neptune thinks he's fixed the bug!";
            }
            return "Fixed " + failed + " entities";
        }

        @help(value="Turns your cape on or off")
        public static void cape() {
            MiscClientCommands.mc.field_71474_y.field_82880_z ^= true;
            MiscClientCommands.mc.field_71474_y.func_82879_c();
        }

        @help(value="shows block render update ranges; run again to disable")
        public static void debugBlockUpdates() {
            WorldClient w;
            int hash;
            if (debugger == null) {
                debugger = new BlockUpdateDebugger();
                AabbDebugger.freeze = true;
            }
            if ((hash = (w = MiscClientCommands.mc.field_71441_e).hashCode()) == active_world_hash) {
                w.func_72848_b(debugger);
                active_world_hash = 0;
                if (!Core.dev_environ) {
                    AabbDebugger.freeze = false;
                }
            } else {
                w.func_72954_a(debugger);
                active_world_hash = hash;
                player.func_146105_b((IChatComponent)new ChatComponentText("Run the command again to disable."));
            }
        }

        @help(value="Saves block & item textures to a file, primarily for exportWorld & exportChunk; probably goes into .minecraft")
        public static void exportTextures() {
            miscCommands.doSave(Core.blockAtlas, "./fz_block_atlas.png");
            miscCommands.doSave(Core.itemAtlas, "./fz_item_atlas.png");
        }

        private static void doSave(ResourceLocation texture, String filename) {
            mc.func_110434_K().func_110577_a(texture);
            RenderUtil.checkGLError("Before save texture");
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            int bufferSize = width * height;
            RenderUtil.checkGLError("After get texture info");
            IntBuffer pixelBuffer = BufferUtils.createIntBuffer((int)bufferSize);
            int[] pixelValues = new int[bufferSize];
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
            pixelBuffer.get(pixelValues);
            BufferedImage img = new BufferedImage(width, height, 6);
            img.setRGB(0, 0, width, height, pixelValues, 0, width);
            try {
                ImageIO.write((RenderedImage)img, "png", new File(filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RenderUtil.checkGLError("After save texture");
        }

        static {
            orig = null;
            backup = null;
            empty = new HashMap();
            active_world_hash = 0;
            debugger = null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface help {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface cheaty {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface sketchy {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface alias {
        public String[] value();
    }
}

