/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.algos.ReservoirSampler;
import factorization.common.Command;
import factorization.common.FzConfig;
import factorization.coremodhooks.UnhandledGuiKeyEvent;
import factorization.misc.MiscClientCommands;
import factorization.misc.MiscClientTickHandler;
import factorization.misc.MiscProxy;
import factorization.misc.ProxiedSound;
import factorization.shared.Core;
import factorization.truth.DocumentationModule;
import factorization.util.FzUtil;
import factorization.weird.NeptuneCape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.ICommand;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import org.apache.commons.io.Charsets;
import org.lwjgl.input.Keyboard;

public class MiscClientProxy
extends MiscProxy {
    static final Minecraft mc = Minecraft.func_71410_x();
    MiscClientTickHandler cth = new MiscClientTickHandler();
    private GuiButton difficulty_button = null;
    long present_tick = -100L;
    int event_count = 0;
    static final int max_event = 4;
    static final double logMax = Math.log(4.0);
    int last_hash = 0;

    @Override
    void initializeClient() {
        Minecraft.field_71444_a = new byte[0];
        Core.loadBus(this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new MiscClientCommands());
        FMLCommonHandler.instance().bus().register((Object)this.cth);
        new NeptuneCape();
    }

    @Override
    void handleTpsReport(float newTps) {
        if (Float.isInfinite(newTps) || Float.isNaN(newTps)) {
            return;
        }
        if (!FzConfig.use_tps_reports) {
            return;
        }
        MiscClientProxy.mc.field_71428_T.field_74278_d = newTps = Math.min(1.5f, Math.max(FzConfig.lowest_dilation, newTps));
    }

    @SubscribeEvent
    public void addDifficultyInfo(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!(event.gui instanceof GuiSelectWorld)) {
            this.difficulty_button = null;
            return;
        }
        if (this.difficulty_button != null) {
            return;
        }
        if (this.getDifficulty() != EnumDifficulty.PEACEFUL) {
            return;
        }
        GuiButton first = (GuiButton)event.buttonList.get(0);
        first.field_146126_j = "    " + EnumChatFormatting.BOLD + EnumChatFormatting.RED + first.field_146126_j;
        this.difficulty_button = new GuiButton(-237, 0, 0, 150, 18, "");
        event.buttonList.add(this.difficulty_button);
        this.updateDifficultyString();
    }

    @SubscribeEvent
    public void changeDifficulty(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.button != this.difficulty_button || this.difficulty_button == null) {
            return;
        }
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        gs.field_74318_M = (EnumDifficulty)FzUtil.shiftEnum((Enum)gs.field_74318_M, (Enum[])EnumDifficulty.values(), (int)1);
        this.updateDifficultyString();
    }

    void updateDifficultyString() {
        EnumDifficulty ed = this.getDifficulty();
        String color = ed == EnumDifficulty.PEACEFUL ? "" + EnumChatFormatting.RED : "";
        this.difficulty_button.field_146126_j = color + "Difficulty: " + ed;
    }

    EnumDifficulty getDifficulty() {
        return Minecraft.func_71410_x().field_71474_y.field_74318_M;
    }

    @SubscribeEvent
    public void patchupTheStupidSecretButton(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!(event.gui instanceof GuiOptions)) {
            return;
        }
        for (Object obj : event.buttonList) {
            if (!(obj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)obj;
            if (button.field_146127_k != 8675309) continue;
            button.field_146126_j = "Shaders; press F4 to reset";
            button.field_146128_h = 0;
            button.field_146129_i = 0;
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addDirectionInfoToDebugScreen(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        float t = 360.0f;
        double yaw = (player.field_70177_z % t + t) % t;
        yaw = Math.toRadians(yaw);
        double x = -Math.sin(yaw);
        double z = Math.cos(yaw);
        for (int i = 0; i < event.left.size(); ++i) {
            String line = (String)event.left.get(i);
            if (line == null || !line.startsWith("f:")) continue;
            line = line + " (" + this.displ(x) + ", " + this.displ(z) + ")";
            event.left.set(i, line);
            break;
        }
    }

    private String displ(double r) {
        int n = (int)Math.abs(r * 3.0);
        if (n == 0) {
            return "=";
        }
        String s = r > 0.0 ? "+" : "-";
        String ret = "";
        for (int i = 0; i < n; ++i) {
            ret = ret + s;
        }
        return ret;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void supressExcessiveSound(PlaySoundEvent17 event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            this.present_tick = -100L;
            return;
        }
        if (event.result == null) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        long now = mc.field_71441_e.func_82737_E();
        if (now != this.present_tick) {
            this.present_tick = now;
            this.event_count = 0;
        }
        if (this.event_count++ < 4) {
            return;
        }
        double origVolume = event.result.func_147653_e();
        final float newVolume = (float)(origVolume / Math.log(this.event_count) * logMax);
        event.result = new ProxiedSound(event.result){

            @Override
            public float func_147653_e() {
                return newVolume;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void customSplash(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (!(event.gui instanceof GuiMainMenu)) {
            return;
        }
        int hash = event.gui.hashCode();
        if (hash == this.last_hash) {
            return;
        }
        this.last_hash = hash;
        GuiMainMenu menu = (GuiMainMenu)event.gui;
        ReservoirSampler<String> sampler = new ReservoirSampler<String>(1, new Random());
        sampler.give(menu.field_73975_c);
        sampler.preGive(321);
        sampler.give("");
        try {
            List resources = mc.func_110442_L().func_135056_b(new ResourceLocation("minecraft:texts/extra_splashes.txt"));
            for (IResource res : resources) {
                InputStream is = null;
                try {
                    String s;
                    is = res.func_110527_b();
                    if (is == null) continue;
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                    while ((s = bufferedreader.readLine()) != null) {
                        if ((s = s.trim()).isEmpty() || s.hashCode() == 125780783 || s.startsWith("#")) continue;
                        sampler.give(s);
                    }
                }
                finally {
                    FzUtil.closeNoisily("Closing " + res, is);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sampler.size() < 1) {
            return;
        }
        menu.field_73975_c = (String)sampler.getSamples().get(0);
    }

    @SubscribeEvent
    public void transferItems(UnhandledGuiKeyEvent event) {
        Command command;
        boolean sneak;
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        if (event.keysym == 0) {
            return;
        }
        Slot slot = DocumentationModule.getSlotUnderMouse();
        if (slot == null) {
            return;
        }
        ItemStack search = slot.func_75211_c();
        if (search == null) {
            return;
        }
        GameSettings gm = Minecraft.func_71410_x().field_71474_y;
        boolean bl = sneak = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        if (event.keysym == gm.field_74370_x.func_151463_i()) {
            command = sneak ? Command.itemTransferLeftShift : Command.itemTransferLeft;
        } else if (event.keysym == gm.field_74366_z.func_151463_i()) {
            command = sneak ? Command.itemTransferRightShift : Command.itemTransferRight;
        } else if (event.keysym == gm.field_74351_w.func_151463_i()) {
            command = sneak ? Command.itemTransferUpShift : Command.itemTransferUp;
        } else if (event.keysym == gm.field_74368_y.func_151463_i()) {
            command = sneak ? Command.itemTransferDownShift : Command.itemTransferDown;
        } else {
            return;
        }
        command.call(event.player, slot.field_75222_d);
    }
}

