/*
 * Decompiled with CFR 0.152.
 */
package factorization.misc;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.api.Coord;
import factorization.api.ICoordFunction;
import factorization.common.FzConfig;
import factorization.misc.LagssieWatchDog;
import factorization.misc.MiscClientCommands;
import factorization.util.FzUtil;
import factorization.util.ItemUtil;
import factorization.util.PlayerUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;

public class MiscClientTickHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    int count = 0;
    boolean hit = false;
    private ItemStack[] swaps = new ItemStack[9];
    boolean was_activated = true;
    static KeyBinding sprint = new KeyBinding("Sprint (FZ)", 0, "key.categories.movement");
    static KeyBinding pickBlock = new KeyBinding("Pick Block (FZ)", 0, "key.categories.gameplay");
    boolean prevState = false;
    long old_now = -1L;
    long interval = 30L;
    String last_msg = null;
    boolean mentioned_disabling = false;
    int last_chunk_x = Integer.MAX_VALUE;
    int last_chunk_z = Integer.MAX_VALUE;

    @SubscribeEvent
    public void clientTicks(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.type != TickEvent.Type.CLIENT) {
            return;
        }
        this.emitLoadAlert();
        this.checkPickBlockKey();
        this.checkSprintKey();
        MiscClientCommands.tick();
        this.notifyTimeOnFullScreen();
        this.fix_mc2713();
    }

    private void emitLoadAlert() {
        if (this.hit) {
            return;
        }
        if (this.count == 40) {
            if (this.mc.field_71462_r instanceof GuiMainMenu) {
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            }
            this.hit = true;
            LagssieWatchDog.start();
            MiscClientTickHandler.setupPickBlockKey();
        }
        ++this.count;
    }

    private void checkPickBlockKey() {
        if (!FzConfig.fix_middle_click) {
            return;
        }
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        boolean keyPressed = pickBlock.func_151470_d();
        if (!keyPressed) {
            this.was_activated = false;
            return;
        }
        if (this.was_activated) {
            return;
        }
        this.was_activated = true;
        if (this.mc.field_71462_r != null) {
            return;
        }
        if (PlayerUtil.isPlayerCreative((EntityPlayer)player)) {
            this.mc.func_147112_ai();
            return;
        }
        MovingObjectPosition mop = this.mc.field_71476_x;
        if (mop == null) {
            return;
        }
        ArrayList<ItemStack> validItems = new ArrayList<ItemStack>();
        int slot = player.field_71071_by.field_70461_c;
        if (this.swaps.length != InventoryPlayer.func_70451_h()) {
            this.swaps = new ItemStack[InventoryPlayer.func_70451_h()];
        }
        if (slot >= 0 && 0 < this.swaps.length && this.swaps[slot] != null) {
            ItemStack origSwap = this.swaps[slot];
            this.swaps[slot] = null;
            boolean movedDown = false;
            for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                if (!ItemUtil.identical(origSwap, player.field_71071_by.func_70301_a(i))) continue;
                movedDown = true;
                break;
            }
            if (!movedDown) {
                validItems.add(origSwap);
            }
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Coord here = Coord.fromMop(player.field_70170_p, mop);
            validItems.add(here.getPickBlock(mop));
            validItems.add(here.getBrokenBlock());
            validItems.add(new ItemStack(here.getId(), 1, here.getMd()));
            ItemStack b = FzUtil.getReifiedBarrel(here);
            if (b != null) {
                validItems.add(b);
            }
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            validItems.add(mop.field_72308_g.getPickedResult(mop));
        }
        ItemStack held = player.func_70694_bm();
        Iterator it = validItems.iterator();
        while (it.hasNext()) {
            if (!ItemUtil.identical((ItemStack)it.next(), held)) continue;
            it.remove();
        }
        if (validItems.isEmpty()) {
            return;
        }
        int firstEmpty = -1;
        if (held == null) {
            firstEmpty = player.field_71071_by.field_70461_c;
        }
        for (int invSlot = 0; invSlot < player.field_71071_by.field_70462_a.length; ++invSlot) {
            for (ItemStack needle : validItems) {
                if (needle == null) continue;
                ItemStack hay = player.field_71071_by.field_70462_a[invSlot];
                if (hay == null && firstEmpty == -1 && invSlot < 9) {
                    firstEmpty = invSlot;
                }
                if (hay == null || !ItemUtil.couldMerge(needle, hay)) continue;
                if (invSlot < 9) {
                    player.field_71071_by.field_70461_c = invSlot;
                    return;
                }
                if (firstEmpty != -1) {
                    player.field_71071_by.field_70461_c = firstEmpty;
                }
                this.swapify((EntityPlayer)player, held, invSlot);
                return;
            }
        }
    }

    private void swapify(EntityPlayer player, ItemStack held, int invSlot) {
        int targetSlot = player.field_71071_by.field_70461_c;
        this.mc.field_71442_b.func_78753_a(player.field_71069_bz.field_75152_c, invSlot, targetSlot, 2, player);
        if (held == null) {
            return;
        }
        if (this.swaps[targetSlot] == null) {
            this.swaps[targetSlot] = held;
            return;
        }
        boolean canReplace = false;
        for (int barSlot = 0; barSlot < 9; ++barSlot) {
            ItemStack barItem = player.field_71071_by.func_70301_a(barSlot);
            if (barItem == null || barItem != this.swaps[targetSlot]) continue;
            canReplace = true;
            break;
        }
        if (canReplace) {
            this.swaps[targetSlot] = held;
        }
    }

    static void setupPickBlockKey() {
        if (!FzConfig.fix_middle_click) {
            return;
        }
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        if (gs.field_74322_I.func_151463_i() != 0 && pickBlock.func_151463_i() == 0) {
            pickBlock.func_151462_b(gs.field_74322_I.func_151463_i());
            gs.field_74322_I.func_151462_b(0);
            MiscClientCommands.miscCommands.savesettings();
        }
    }

    private void checkSprintKey() {
        if (this.mc.field_71462_r != null) {
            return;
        }
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (sprint.func_151463_i() == 0) {
            return;
        }
        boolean state = sprint.func_151470_d();
        int forwardCode = this.mc.field_71474_y.field_74351_w.func_151463_i();
        if (state) {
            if (!this.mc.field_71439_g.func_70093_af()) {
                KeyBinding.func_74510_a((int)forwardCode, (boolean)true);
                this.mc.field_71439_g.func_70031_b(true);
            }
        } else if (this.prevState) {
            KeyBinding.func_74510_a((int)forwardCode, (boolean)false);
            this.mc.field_71439_g.func_70031_b(false);
        }
        this.prevState = state;
    }

    long getNow() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return -1L;
        }
        Calendar cal = world.func_83015_S();
        return (long)cal.get(12) / this.interval;
    }

    public void notifyTimeOnFullScreen() {
        if (!FzConfig.show_time_on_fullscreen) {
            return;
        }
        if (this.interval <= 0L) {
            return;
        }
        long now = this.getNow();
        if (now == this.old_now || now == -1L) {
            return;
        }
        this.old_now = now;
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_71372_G()) {
            return;
        }
        DateFormat df = DateFormat.getTimeInstance(3);
        String msg = df.format(new Date());
        if (!this.mentioned_disabling) {
            msg = msg + " (via FZ)";
            this.mentioned_disabling = true;
        }
        ChatStyle style = new ChatStyle().func_150217_b(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.GRAY);
        mc.field_71456_v.func_146158_b().func_146234_a(new ChatComponentText(msg).func_150255_a(style), 20392);
        this.last_msg = msg;
    }

    boolean chunkChanged() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        if (this.last_chunk_x == player.field_70176_ah && this.last_chunk_z == player.field_70164_aj) {
            return false;
        }
        this.last_chunk_x = player.field_70176_ah;
        this.last_chunk_z = player.field_70164_aj;
        return true;
    }

    void fix_mc2713() {
        WorldClient world = this.mc.field_71441_e;
        if (world == null || world.field_72996_f == null) {
            return;
        }
        if (!this.chunkChanged()) {
            return;
        }
        int d = 24;
        final HashSet properly_known_entities = new HashSet();
        Coord at = new Coord((Entity)this.mc.field_71439_g);
        Coord.iterateChunks(at.add(-d, -d, -d), at.add(d, d, d), new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                Chunk chunk = here.getChunk();
                if (chunk == null) {
                    return;
                }
                for (List l : chunk.field_76645_j) {
                    if (l == null) continue;
                    properly_known_entities.addAll(l);
                }
            }
        });
        block0: for (Entity ent : world.field_72996_f) {
            boolean near;
            int ecz;
            int dz;
            int ecx = MathHelper.func_76128_c((double)(ent.field_70165_t / 16.0));
            int dx = this.last_chunk_x - ecx;
            int dSq = dx * dx + (dz = this.last_chunk_z - (ecz = MathHelper.func_76128_c((double)(ent.field_70161_v / 16.0)))) * dz;
            boolean bl = near = dSq <= 4;
            if (!near) continue;
            Chunk chunk = world.func_72964_e(ecx, ecz);
            if (chunk.field_76645_j[ent.field_70162_ai].size() < 16) {
                for (Entity e : chunk.field_76645_j[ent.field_70162_ai]) {
                    if (e != ent) continue;
                    continue block0;
                }
            } else if (properly_known_entities.contains(ent)) continue;
            chunk.func_76612_a(ent);
        }
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)sprint);
        if (FzConfig.fix_middle_click) {
            ClientRegistry.registerKeyBinding((KeyBinding)pickBlock);
        }
    }
}

