/*
 * Decompiled with CFR 0.152.
 */
package factorization.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import factorization.oreprocessing.GuiCrystallizer;
import factorization.oreprocessing.TileEntityCrystallizer;
import factorization.shared.Core;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RecipeCrystallizer
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(ItemStack result) {
        for (Object obj : TileEntityCrystallizer.recipes) {
            if (!(obj instanceof TileEntityCrystallizer.CrystalRecipe)) continue;
            TileEntityCrystallizer.CrystalRecipe cr = (TileEntityCrystallizer.CrystalRecipe)obj;
            if (result != null && !result.func_77969_a(cr.output)) continue;
            this.arecipes.add(new CachedCrystallizerRecipe(cr));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fz.crystallizing")) {
            this.loadCraftingRecipes(null);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object obj : TileEntityCrystallizer.recipes) {
            if (!(obj instanceof TileEntityCrystallizer.CrystalRecipe)) continue;
            TileEntityCrystallizer.CrystalRecipe cr = (TileEntityCrystallizer.CrystalRecipe)obj;
            if (ingredient != null && !ingredient.func_77969_a(cr.input) && !ingredient.func_77969_a(cr.solution)) continue;
            this.arecipes.add(new CachedCrystallizerRecipe(cr));
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        TileEntityCrystallizer.CrystalRecipe cr = ((CachedCrystallizerRecipe)((Object)this.arecipes.get((int)recipe))).cr;
        if (stack.func_77969_a(cr.output)) {
            float prob = cr.output_count * 100.0f;
            if (prob == 100.0f) {
                // empty if block
            }
            currenttip.add((int)prob + "%");
        }
        if (stack.func_77969_a(cr.solution)) {
            currenttip.add("Does not get used up");
        }
        if (stack.func_77969_a(cr.input)) {
            currenttip.add("Extra copies of this can be added");
            currenttip.add("to the other slots to increase yield");
        }
        if (stack.func_77969_a(Core.registry.heater_item)) {
            currenttip.add("Use this to heat the crystallizer");
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 78, 32, 16), "fz.crystallizing", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrystallizer.class;
    }

    public String getRecipeName() {
        return "Crystallizer";
    }

    public String getGuiTexture() {
        return "factorization:textures/gui/crystal.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)15, (int)5, (int)11, (int)166, (int)95);
    }

    public String getOverlayIdentifier() {
        return "fz.crystallizing";
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    class CachedCrystallizerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        TileEntityCrystallizer.CrystalRecipe cr;

        public CachedCrystallizerRecipe(TileEntityCrystallizer.CrystalRecipe cr) {
            super((TemplateRecipeHandler)RecipeCrystallizer.this);
            this.cr = cr;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.cr.output, 75, 44);
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public ArrayList<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            ret.add(new PositionedStack((Object)this.cr.input, 75, 17));
            ret.add(new PositionedStack((Object)this.cr.solution, 75, 73));
            ret.add(new PositionedStack((Object)Core.registry.heater_item, 0, 75));
            return ret;
        }
    }
}

