/*
 * Decompiled with CFR 0.152.
 */
package factorization.oreprocessing;

import factorization.api.IFurnaceHeatable;
import factorization.api.crafting.CraftingManagerGeneric;
import factorization.api.crafting.IVexatiousCrafting;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityFactorization;
import factorization.util.DataUtil;
import factorization.util.ItemUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySlagFurnace
extends TileEntityFactorization
implements IFurnaceHeatable {
    ItemStack[] inv = new ItemStack[4];
    public int furnaceBurnTime;
    public int currentFuelItemBurnTime;
    public int furnaceCookTime;
    static final int inputSlotIndex = 0;
    static final int fuelSlotIndex = 1;
    static final int outputSlotIndex = 2;
    private static final int[] INPUT_s = new int[]{0, 1};
    private static final int[] FUEL_s = new int[]{1};
    private static final int[] OUTPUT_s = new int[]{2, 3};
    boolean prevBurnState = false;
    IVexatiousCrafting<TileEntitySlagFurnace> current_recipe = null;
    public static final CraftingManagerGeneric<TileEntitySlagFurnace> recipes = CraftingManagerGeneric.get(TileEntitySlagFurnace.class);

    public int func_70302_i_() {
        return 4;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.facing_direction = SpaceUtil.getOpposite(SpaceUtil.determineFlatOrientation(player));
    }

    @Override
    public IIcon getIcon(ForgeDirection dir) {
        if (this.draw_active > 0 && this.facing_direction == dir.ordinal()) {
            return BlockIcons.machine$slag_furnace_face_on;
        }
        return BlockIcons.slag_furnace.get(this, dir);
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public void func_70299_a(int i, ItemStack is) {
        this.inv[i] = is;
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Slag Furnace";
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        switch (side) {
            case DOWN: {
                return OUTPUT_s;
            }
            case UP: {
                return INPUT_s;
            }
        }
        return FUEL_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (slotIndex == 0) {
            return true;
        }
        if (slotIndex == 1) {
            return TileEntityFurnace.func_145954_b((ItemStack)itemstack);
        }
        return false;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SLAGFURNACE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.MachineLightable;
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        super.putData(data);
        this.putSlots(data);
        this.furnaceBurnTime = data.as(Share.VISIBLE, "burnTime").putInt(this.furnaceBurnTime);
        this.furnaceCookTime = data.as(Share.VISIBLE, "cookTime").putInt(this.furnaceCookTime);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public void func_145845_h() {
        boolean burning;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        boolean invChanged = false;
        if (this.furnaceBurnTime <= 0 && this.canSmelt()) {
            this.currentFuelItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inv[1]) / 2;
            if (this.furnaceBurnTime > 0) {
                invChanged = true;
                if (this.inv[1] != null) {
                    --this.inv[1].field_77994_a;
                    if (this.inv[1].field_77994_a == 0) {
                        this.inv[1] = this.inv[1].func_77973_b().getContainerItem(this.inv[1]);
                    }
                }
            }
            if (this.current_recipe != null) {
                this.current_recipe.onCraftingStart(this);
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.furnaceCookTime;
            if (this.furnaceCookTime >= 200 || Core.cheat) {
                this.furnaceCookTime = 0;
                this.smeltItem();
                invChanged = true;
            }
        } else {
            this.furnaceCookTime = 0;
        }
        if (this.prevBurnState != (burning = this.isBurning())) {
            this.draw_active = (byte)(burning ? 0 : -1);
            this.drawActive(1);
            this.prevBurnState = burning;
        }
        if (invChanged) {
            this.func_70296_d();
        }
    }

    public boolean canSmelt() {
        if (this.inv[0] == null) {
            return false;
        }
        this.current_recipe = recipes.find(this);
        if (this.current_recipe == null) {
            return false;
        }
        return this.current_recipe.isUnblocked(this);
    }

    int getRandomSize(float f) {
        int i = (int)f;
        if (f - (float)i > this.field_145850_b.field_73012_v.nextFloat()) {
            ++i;
        }
        return i;
    }

    void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        IVexatiousCrafting<TileEntitySlagFurnace> res = recipes.find(this);
        res.onCraftingComplete(this);
    }

    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 200;
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentFuelItemBurnTime == 0) {
            this.currentFuelItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentFuelItemBurnTime;
    }

    @Override
    public boolean acceptsHeat() {
        return this.canSmelt();
    }

    @Override
    public void giveHeat() {
        TileEntitySlagFurnace furnace = this;
        boolean needStart = !this.isStarted();
        int topBurnTime = 200;
        if (furnace.furnaceBurnTime < 200) {
            ++furnace.furnaceBurnTime;
        } else {
            ++furnace.furnaceCookTime;
            furnace.furnaceCookTime = Math.min(furnace.furnaceCookTime, 199);
        }
    }

    @Override
    public boolean hasLaggyStart() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.isBurning();
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            if (messageType == NetworkFactorization.MessageType.DrawActive) {
                this.getCoord().updateLight();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        if (axis.offsetY != 0) {
            return false;
        }
        byte newd = (byte)axis.ordinal();
        if (newd != this.facing_direction) {
            this.facing_direction = newd;
            return true;
        }
        return false;
    }

    @Override
    public void spawnDisplayTickParticles(Random rand) {
        if (this.draw_active <= 0) {
            return;
        }
        byte direction = this.facing_direction;
        World w = this.field_145850_b;
        float px = (float)this.field_145851_c + 0.5f;
        float py = (float)this.field_145848_d + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
        float pz = (float)this.field_145849_e + 0.5f;
        float d = 0.52f;
        float rng = rand.nextFloat() * 0.6f - 0.3f;
        if (direction == 4) {
            w.func_72869_a("smoke", (double)(px - d), (double)py, (double)(pz + rng), 0.0, 0.0, 0.0);
            w.func_72869_a("flame", (double)(px - d), (double)py, (double)(pz + rng), 0.0, 0.0, 0.0);
        } else if (direction == 5) {
            w.func_72869_a("smoke", (double)(px + d), (double)py, (double)(pz + rng), 0.0, 0.0, 0.0);
            w.func_72869_a("flame", (double)(px + d), (double)py, (double)(pz + rng), 0.0, 0.0, 0.0);
        } else if (direction == 2) {
            w.func_72869_a("smoke", (double)(px + rng), (double)py, (double)(pz - d), 0.0, 0.0, 0.0);
            w.func_72869_a("flame", (double)(px + rng), (double)py, (double)(pz - d), 0.0, 0.0, 0.0);
        } else if (direction == 3) {
            w.func_72869_a("smoke", (double)(px + rng), (double)py, (double)(pz + d), 0.0, 0.0, 0.0);
            w.func_72869_a("flame", (double)(px + rng), (double)py, (double)(pz + d), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getDynamicLight() {
        return this.isBurning() ? 13 : 0;
    }

    public static class SlagRecipes {
        public static ArrayList<SmeltingResult> smeltingResults = TileEntitySlagFurnace.recipes.list;

        static ItemStack obj2is(Object o) {
            if (o instanceof ItemStack) {
                return ItemStack.func_77944_b((ItemStack)((ItemStack)o));
            }
            if (o instanceof Block) {
                Block b = (Block)o;
                Item it = DataUtil.getItem(b);
                if (it == null) {
                    return null;
                }
                return new ItemStack(it);
            }
            if (o instanceof Item) {
                return new ItemStack((Item)o);
            }
            return null;
        }

        public static void register(Object o_input, float prob1, Object o_output1, float prob2, Object o_output2) {
            ItemStack input = SlagRecipes.obj2is(o_input);
            ItemStack output1 = SlagRecipes.obj2is(o_output1);
            ItemStack output2 = SlagRecipes.obj2is(o_output2);
            input.field_77994_a = 1;
            SmeltingResult recipe = new SmeltingResult(input, prob1, output1, prob2, output2);
            recipes.add(recipe);
        }
    }

    public static class SmeltingResult
    implements IVexatiousCrafting<TileEntitySlagFurnace> {
        public ItemStack input;
        public float prob1;
        public float prob2;
        public ItemStack output1;
        public ItemStack output2;

        public SmeltingResult(ItemStack input, float prob1, ItemStack output1, float prob2, ItemStack output2) {
            this.input = input;
            this.prob1 = prob1;
            this.prob2 = prob2;
            this.output1 = output1;
            this.output2 = output2;
        }

        @Override
        public boolean matches(TileEntitySlagFurnace machine) {
            return ItemUtil.wildcardSimilar(this.input, machine.inv[0]);
        }

        @Override
        public void onCraftingStart(TileEntitySlagFurnace machine) {
        }

        @Override
        public void onCraftingComplete(TileEntitySlagFurnace machine) {
            ItemStack[] furnaceItemStacks = machine.inv;
            if (furnaceItemStacks[2] == null) {
                furnaceItemStacks[2] = ItemStack.func_77944_b((ItemStack)this.output1);
                furnaceItemStacks[2].field_77994_a = 0;
            }
            if (furnaceItemStacks[3] == null) {
                furnaceItemStacks[3] = ItemStack.func_77944_b((ItemStack)this.output2);
                furnaceItemStacks[3].field_77994_a = 0;
            }
            ItemStack fo0 = furnaceItemStacks[2];
            ItemStack fo1 = furnaceItemStacks[3];
            fo0.field_77994_a += machine.getRandomSize(this.prob1);
            fo1.field_77994_a += machine.getRandomSize(this.prob2);
            if (fo0.field_77994_a > fo0.func_77976_d()) {
                fo0.field_77994_a = fo0.func_77976_d();
            }
            if (fo1.field_77994_a > fo1.func_77976_d()) {
                fo1.field_77994_a = fo1.func_77976_d();
            }
            if (fo0.field_77994_a <= 0) {
                furnaceItemStacks[2] = null;
            }
            if (fo1.field_77994_a <= 0) {
                furnaceItemStacks[3] = null;
            }
            --furnaceItemStacks[0].field_77994_a;
            if (furnaceItemStacks[0].field_77994_a == 0) {
                furnaceItemStacks[0] = null;
            }
        }

        boolean checkFit(ItemStack output, ItemStack res, int resSize) {
            if (output == null) {
                return true;
            }
            if (!ItemUtil.couldMerge(output, res)) {
                return false;
            }
            return output.field_77994_a + resSize <= output.func_77976_d();
        }

        @Override
        public boolean isUnblocked(TileEntitySlagFurnace machine) {
            return this.checkFit(machine.inv[2], this.output1, (int)this.prob1) && this.checkFit(machine.inv[3], this.output2, (int)this.prob2);
        }
    }
}

