/*
 * Decompiled with CFR 0.152.
 */
package factorization.redstone;

import factorization.common.BlockIcons;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMatcher
extends Block {
    static final byte STATE_READY = 0;
    static final byte STATE_FIRING = 4;
    static final byte STATE_MATCHED = 8;

    public BlockMatcher() {
        super(Material.field_151576_e);
        this.func_149675_a(false);
        this.func_149647_a(Core.tabFactorization);
        this.func_149663_c("BlockMatcher");
    }

    int makeMd(ForgeDirection axis, byte state) {
        if (SpaceUtil.sign(axis) == 1) {
            axis = axis.getOpposite();
        }
        int md = 0;
        if (axis == ForgeDirection.DOWN) {
            md = 0;
        }
        if (axis == ForgeDirection.NORTH) {
            md = 1;
        }
        if (axis == ForgeDirection.WEST) {
            md = 2;
        }
        return md |= state;
    }

    ForgeDirection getAxis(int md) {
        switch (md & 3) {
            default: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.NORTH;
            }
            case 2: 
        }
        return ForgeDirection.WEST;
    }

    byte getState(int md) {
        return (byte)(md & 0xC);
    }

    byte match(IBlockAccess world, int x, int y, int z, ForgeDirection axis) {
        ForgeDirection dir1 = axis;
        ForgeDirection dir2 = axis.getOpposite();
        Block front = world.func_147439_a(x + dir1.offsetX, y + dir1.offsetY, z + dir1.offsetZ);
        int frontMd = world.func_72805_g(x + dir1.offsetX, y + dir1.offsetY, z + dir1.offsetZ);
        boolean frontAir = world.func_147437_c(x + dir1.offsetX, y + dir1.offsetY, z + dir1.offsetZ);
        Block back = world.func_147439_a(x + dir2.offsetX, y + dir2.offsetY, z + dir2.offsetZ);
        int backMd = world.func_72805_g(x + dir2.offsetX, y + dir2.offsetY, z + dir2.offsetZ);
        boolean backAir = world.func_147437_c(x + dir2.offsetX, y + dir2.offsetY, z + dir2.offsetZ);
        if (frontAir || backAir) {
            return 0;
        }
        if (front == back) {
            if (frontMd == backMd) {
                return 4;
            }
            return 3;
        }
        if (front.func_149688_o() == back.func_149688_o()) {
            return 2;
        }
        if (front.func_149721_r() == back.func_149721_r()) {
            return 1;
        }
        return 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        ForgeDirection mojangSide;
        int md = world.func_72805_g(x, y, z);
        ForgeDirection axis = this.getAxis(md);
        if (axis == (mojangSide = SpaceUtil.demojangSide(side)) || axis == mojangSide.getOpposite()) {
            return 0;
        }
        byte match = this.match((IBlockAccess)world, x, y, z, axis);
        if (match == 0) {
            return 0;
        }
        return match * 5 - 4;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (block == this) {
            return;
        }
        int md = world.func_72805_g(x, y, z);
        byte state = this.getState(md);
        if (state == 4) {
            return;
        }
        ForgeDirection axis = this.getAxis(md);
        byte match = this.match((IBlockAccess)world, x, y, z, axis);
        byte next_state = match >= 3 ? (byte)4 : 0;
        world.func_147453_f(x, y, z, (Block)this);
        if (state == 8 && next_state == 4) {
            return;
        }
        int notify = 3;
        int next_md = this.makeMd(axis, next_state);
        if (md == next_md) {
            return;
        }
        world.func_72921_c(x, y, z, next_md, notify);
        world.func_147464_a(x, y, z, (Block)this, 4);
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int md = world.func_72805_g(x, y, z);
        ForgeDirection axis = this.getAxis(md);
        if (axis == ForgeDirection.DOWN) {
            return side != -1 && side != -2 && side != 4;
        }
        if (axis == ForgeDirection.NORTH) {
            return side != 0 && side != 2;
        }
        if (axis == ForgeDirection.WEST) {
            return side != 1 && side != 3;
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int md = world.func_72805_g(x, y, z);
        ForgeDirection axis = this.getAxis(md);
        return axis != side && axis != side.getOpposite();
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection dir;
        int md = world.func_72805_g(x, y, z);
        byte state = this.getState(md);
        if (state != 4) {
            return 0;
        }
        ForgeDirection axis = this.getAxis(md);
        if (axis == (dir = ForgeDirection.getOrientation((int)side)) || axis == dir.getOpposite()) {
            return 0;
        }
        byte match = this.match(world, x, y, z, axis);
        if (match >= 3) {
            return 15;
        }
        return 0;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int md = world.func_72805_g(x, y, z);
        ForgeDirection axis = this.getAxis(md);
        byte match = this.match((IBlockAccess)world, x, y, z, axis);
        byte nextState = match >= 3 ? (byte)8 : 0;
        int notify = 3;
        int nextMd = this.makeMd(this.getAxis(md), nextState);
        world.func_72921_c(x, y, z, nextMd, notify);
    }

    public int func_149660_a(World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int itemMetadata) {
        return this.makeMd(ForgeDirection.getOrientation((int)side), (byte)0);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        int md = world.func_72805_g(x, y, z);
        byte state = this.getState(md);
        if (state == 0) {
            return;
        }
        ForgeDirection axis = this.getAxis(md);
        world.func_72921_c(x, y, z, this.makeMd(axis, (byte)0), 0);
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = BlockIcons.redstone$matcher_side;
    }

    public IIcon func_149691_a(int side, int md) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        ForgeDirection axis = this.getAxis(md);
        if (axis == dir || axis == dir.getOpposite()) {
            return BlockIcons.redstone$matcher_face;
        }
        return BlockIcons.redstone$matcher_side;
    }
}

