/*
 * Decompiled with CFR 0.152.
 */
package factorization.rendersorting;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import factorization.rendersorting.CleaningList;
import factorization.rendersorting.ISortableRenderer;
import factorization.shared.Core;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.event.world.WorldEvent;

public class RenderSorter
implements Comparator<Object> {
    private int tick = 0;

    public static void dirtyTileEntity(TileEntity te) {
        if (!te.func_145831_w().field_72995_K) {
            return;
        }
        List tes = Minecraft.func_71410_x().field_71438_f.field_147598_a;
        if (tes instanceof CleaningList) {
            ((CleaningList)tes).setDirty();
        }
    }

    public static void dirtyEntity(Entity ent) {
        if (!ent.field_70170_p.field_72995_K) {
            return;
        }
        List ents = ent.field_70170_p.field_72996_f;
        if (ents instanceof CleaningList) {
            ((CleaningList)ents).setDirty();
        }
    }

    @SubscribeEvent
    public void inject(WorldEvent.Load event) {
        World w = event.world;
        if (!w.field_72995_K) {
            return;
        }
        if (!(w instanceof WorldClient)) {
            return;
        }
        RenderGlobal rg = Minecraft.func_71410_x().field_71438_f;
        w.field_72996_f = this.make(w.field_72996_f, "Entities");
        rg.field_147598_a = this.make(rg.field_147598_a, "TileEntities");
    }

    @SubscribeEvent
    public void sort(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.tick++ % 20 != 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        this.sort(mc.field_71441_e.field_72996_f);
        this.sort(mc.field_71438_f.field_147598_a);
    }

    private List make(List orig, String category) {
        if (orig instanceof CleaningList) {
            return orig;
        }
        if (orig.getClass() != ArrayList.class) {
            Core.logWarning("Can't sort " + category + "; it has already been changed to " + orig.getClass(), new Object[0]);
            return orig;
        }
        CleaningList ret = new CleaningList();
        ret.addAll(orig);
        return ret;
    }

    private void sort(List list) {
        if (!(list instanceof CleaningList)) {
            return;
        }
        CleaningList ls = (CleaningList)list;
        if (ls.setClean()) {
            return;
        }
        Collections.sort(ls, this);
    }

    @Override
    public int compare(Object a, Object b) {
        Class<?> bClass;
        if (a == null || b == null) {
            return 0;
        }
        Class<?> aClass = a.getClass();
        if (aClass != (bClass = b.getClass())) {
            return aClass.getCanonicalName().compareTo(bClass.getCanonicalName());
        }
        if (a instanceof ISortableRenderer) {
            ISortableRenderer ai = (ISortableRenderer)a;
            return ai.compareRenderer(b);
        }
        return 0;
    }

    private static int getComplexity(ItemStack a, IItemRenderer.ItemRenderType renderType) {
        if (a == null) {
            return 0;
        }
        if (a.hasEffect(0)) {
            return 100;
        }
        IItemRenderer ar = MinecraftForgeClient.getItemRenderer((ItemStack)a, (IItemRenderer.ItemRenderType)renderType);
        if (ar == null) {
            return 10 + a.func_94608_d();
        }
        return 1000 + Math.abs(ar.getClass().hashCode() % Short.MAX_VALUE);
    }

    public static int compareItemRender(ItemStack a, ItemStack b, IItemRenderer.ItemRenderType renderType) {
        int bc;
        int ac = RenderSorter.getComplexity(a, renderType);
        if (ac == (bc = RenderSorter.getComplexity(b, renderType))) {
            return 0;
        }
        if (ac < bc) {
            return -1;
        }
        return 1;
    }
}

