/*
 * Decompiled with CFR 0.152.
 */
package factorization.scrap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList;
import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.scrap.CompileError;
import factorization.scrap.Help;
import factorization.scrap.IRevertible;
import factorization.scrap.ScannerHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraftforge.common.MinecraftForge;

@Help(value={"Deregisters an event handler from the EventBusses", "BusRemove EventClassname EventHandlerClassname"})
public class BusRemove
implements IRevertible {
    static final List<EventBus> busses = Arrays.asList(MinecraftForge.EVENT_BUS, MinecraftForge.ORE_GEN_BUS, MinecraftForge.TERRAIN_GEN_BUS, FMLCommonHandler.instance().bus());
    final Class<?> handlerClass;
    final Class<? extends Event> eventClass;
    final Multimap<EventBus, Object> map = ArrayListMultimap.create();

    public BusRemove(Scanner in) throws ClassNotFoundException {
        this.handlerClass = ScannerHelper.nextClass(in);
        String methodName = in.next();
        Class<?> foundEvent = null;
        for (Method method : this.handlerClass.getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals(methodName) || (params = method.getParameterTypes()).length != 1 || !Event.class.isAssignableFrom(params[0])) continue;
            foundEvent = params[0];
            break;
        }
        if (foundEvent == null) {
            throw new CompileError("Didn't find method in class: " + this.handlerClass.getCanonicalName() + "::" + methodName);
        }
        this.eventClass = foundEvent;
        try {
            this.setup();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void setup() throws Throwable {
        Constructor<? extends Event> eventConstructor = this.eventClass.getConstructor(new Class[0]);
        eventConstructor.setAccessible(true);
        Event testEvent = eventConstructor.newInstance(new Object[0]);
        ListenerList listeners = testEvent.getListenerList();
        for (EventBus bus : busses) {
            int busID = (Integer)ReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String[])new String[]{"busID"});
            for (IEventListener listener : listeners.getListeners(busID)) {
                if (!(listener instanceof ASMEventHandler)) continue;
                Object handler = ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)((ASMEventHandler)listener), (String[])new String[]{"handler"});
                Field instanceField = handler.getClass().getField("instance");
                instanceField.setAccessible(true);
                Object instance = instanceField.get(handler);
                if (instance.getClass() != this.handlerClass) continue;
                this.map.put((Object)bus, instance);
            }
        }
    }

    @Override
    public void apply() {
        for (Map.Entry entry : this.map.entries()) {
            EventBus bus = (EventBus)entry.getKey();
            Object handler = entry.getValue();
            bus.unregister(handler);
        }
    }

    @Override
    public void revert() {
        for (Map.Entry entry : this.map.entries()) {
            EventBus bus = (EventBus)entry.getKey();
            Object handler = entry.getValue();
            bus.register(handler);
        }
    }

    @Override
    public String info() {
        int reg = 0;
        for (Object x : this.map.values()) {
            ++reg;
        }
        return "BusRemove " + this.eventClass.getCanonicalName() + " " + this.handlerClass.getCanonicalName() + " # " + reg + " registered on " + this.map.size() + " busses";
    }
}

