/*
 * Decompiled with CFR 0.152.
 */
package factorization.scrap;

import factorization.scrap.CompileError;
import factorization.util.DataUtil;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;

public final class ScannerHelper {
    private static final Pattern stackPattern = Pattern.compile("([a-zA-Z_09:]+)(%[\\d]+)?(#[\\d])+");

    public static Item nextItem(Scanner in) {
        String name = in.next();
        Item ret = DataUtil.getItemFromName(name);
        if (ret == null) {
            throw new CompileError("No such item: " + name);
        }
        return ret;
    }

    public static Block nextBlock(Scanner in) {
        String name = in.next();
        Block ret = DataUtil.getBlockFromName(name);
        if (ret == null) {
            throw new CompileError("No such block: " + name);
        }
        return ret;
    }

    public static ItemStack nextStack(Scanner in) {
        String stackText = in.next(stackPattern);
        Matcher match = stackPattern.matcher(stackText);
        String name = match.group(1);
        int damageValue = ScannerHelper.i(match.group(2), 0);
        int stacksize = ScannerHelper.i(match.group(3), 1);
        Item it = DataUtil.getItemFromName(name);
        if (it == null) {
            throw new CompileError("No such item: " + name);
        }
        return new ItemStack(it, stacksize, damageValue);
    }

    public static Class nextClass(Scanner in) {
        String className = in.next();
        try {
            return ScannerHelper.class.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CompileError("Class not found: " + className);
        }
    }

    private static int i(String n, int def) {
        if (StringUtils.func_151246_b((String)n)) {
            return def;
        }
        return Integer.parseInt(n);
    }
}

