/*
 * Decompiled with CFR 0.152.
 */
package factorization.scrap;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.Side;
import factorization.scrap.BusRemove;
import factorization.scrap.CompileError;
import factorization.scrap.DeregisterTesr;
import factorization.scrap.IRevertible;
import factorization.scrap.ScrapCommand;
import factorization.scrap.Script;
import factorization.scrap.SetMaxDamage;
import factorization.scrap.SetMaxSize;
import factorization.util.FzUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import net.minecraft.command.ICommand;
import org.apache.logging.log4j.Logger;

@Mod(modid="fz.scrap", version="0.8.109", name="Scrap")
public class ScrapManager {
    public static Logger log;
    static final ArrayList<IRevertible> actions;
    public static final HashMap<String, Class<? extends IRevertible>> actionClasses;

    @Mod.EventHandler
    public void registerActions(FMLPreInitializationEvent event) {
        FzUtil.setCoreParent(event);
        log = event.getModLog();
        actionClasses.put("SetMaxDamage", SetMaxDamage.class);
        actionClasses.put("SetMaxSize", SetMaxSize.class);
        actionClasses.put("BusRemove", BusRemove.class);
        actionClasses.put("Script", Script.class);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            actionClasses.put("DeregisterTesr", DeregisterTesr.class);
        }
    }

    @Mod.EventHandler
    public void registerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ScrapCommand());
    }

    @Mod.EventHandler
    public void runScript(FMLServerStartedEvent event) {
        try {
            ScrapManager.runScript("user", false);
        }
        catch (CompileError compileError) {
            // empty catch block
        }
    }

    public static void runScript(String filename, boolean createIfMissing) {
        ScrapManager.run(new Script(filename, createIfMissing));
    }

    public static void run(IRevertible action) {
        actions.add(action);
        action.apply();
    }

    public static String call(String line) {
        IRevertible action = ScrapManager.compile(line);
        ScrapManager.run(action);
        return action.info();
    }

    public static String undo() {
        if (actions.isEmpty()) {
            return "nothing to undo";
        }
        IRevertible action = actions.remove(actions.size() - 1);
        action.revert();
        return "Undone: " + action.info();
    }

    public static String reset() {
        for (int i = actions.size() - 1; i >= 0; --i) {
            IRevertible action = actions.get(i);
            action.revert();
        }
        actions.clear();
        return "Reset";
    }

    public static String reload() {
        ScrapManager.reset();
        ScrapManager.runScript("user", false);
        return "Reloaded";
    }

    public static IRevertible compile(String src) throws CompileError {
        Constructor<? extends IRevertible> csn;
        Scanner scanner = new Scanner(src);
        String actionName = scanner.next();
        Class<? extends IRevertible> actionClass = actionClasses.get(actionName);
        if (actionClass == null) {
            throw new CompileError("Unknown action: " + actionName);
        }
        try {
            csn = actionClass.getConstructor(Scanner.class);
            csn.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new CompileError("Invalid action class: " + actionName);
        }
        try {
            return csn.newInstance(scanner);
        }
        catch (CompileError t) {
            throw t;
        }
        catch (Throwable t) {
            throw new CompileError("Load failed", t);
        }
    }

    static {
        actions = new ArrayList();
        actionClasses = new HashMap();
    }
}

