/*
 * Decompiled with CFR 0.152.
 */
package factorization.scrap;

import factorization.scrap.CompileError;
import factorization.scrap.Help;
import factorization.scrap.IRevertible;
import factorization.scrap.ScrapManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Help(value={"Runs a script", "Script extra # runs scraps/extra.scrap"})
public class Script
implements IRevertible {
    static final Logger log = ScrapManager.log;
    final ArrayList<IRevertible> actions = new ArrayList();
    final String filename;
    final String simpleName;
    final File scriptFile;
    static ThreadLocal<HashSet<String>> localActive = new ThreadLocal();

    private static HashSet<String> getLocalActive() {
        HashSet<String> ret = localActive.get();
        if (ret == null) {
            ret = new HashSet();
            localActive.set(ret);
        }
        return ret;
    }

    public Script(Scanner in) {
        this(in.next(), false);
    }

    public Script(String simpleName, boolean createIfMissing) {
        this.simpleName = simpleName;
        for (String b : new String[]{".", "\\", ":"}) {
            if (!simpleName.contains(b) && !simpleName.startsWith("/")) continue;
            throw new CompileError("Not running script with strange name");
        }
        this.filename = "scraps/" + simpleName + ".scrap";
        HashSet<String> active = Script.getLocalActive();
        if (active.contains(simpleName)) {
            throw new CompileError("Already compiling: " + simpleName);
        }
        this.scriptFile = new File(this.filename);
        this.tryCreate(createIfMissing);
        active.add(simpleName);
        try {
            this.read();
        }
        catch (IOException e) {
            throw new CompileError("Error reading script", e);
        }
        finally {
            active.remove(simpleName);
        }
    }

    void tryCreate(boolean createIfMissing) {
        if (this.scriptFile.exists()) {
            return;
        }
        if (!createIfMissing) {
            throw new CompileError("File does not exist: " + this.scriptFile);
        }
        new File(this.scriptFile.getParent()).mkdirs();
        try {
            if (!this.scriptFile.createNewFile()) {
                throw new IOException("Could not create " + this.filename + " file");
            }
        }
        catch (IOException e) {
            log.log(Level.WARN, "File creation failed", (Throwable)e);
        }
    }

    private void read() throws IOException {
        log.log(Level.INFO, "Running script: " + this.filename);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.scriptFile)));
        int lineNumber = 0;
        while (true) {
            ++lineNumber;
            String line = in.readLine();
            if (line == null) break;
            if ((line = line.replaceFirst(" *", "")).startsWith("#") || line.isEmpty()) continue;
            try {
                this.actions.add(ScrapManager.compile(line));
            }
            catch (CompileError error) {
                error.addTrace(this.filename, lineNumber, line);
                throw error;
            }
        }
        log.log(Level.INFO, "Script completed");
    }

    @Override
    public void apply() {
        for (IRevertible action : this.actions) {
            action.apply();
        }
    }

    @Override
    public void revert() {
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            IRevertible action = this.actions.get(i);
            action.revert();
        }
    }

    @Override
    public String info() {
        return "script " + this.simpleName + " # containing " + this.actions.size() + " actions";
    }
}

