/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.IChargeConductor;
import factorization.api.IEntityMessage;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInByteBuf;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataOutByteBuf;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.servo.MotionHandler;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractServoMachine
extends Entity
implements IEntityAdditionalSpawnData,
IEntityMessage {
    public final MotionHandler motionHandler = this.newMotionHandler();

    public AbstractServoMachine(World world) {
        super(world);
    }

    public void spawnServoMotor() {
        this.motionHandler.beforeSpawn();
        this.field_70170_p.func_72838_d((Entity)this);
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataInNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        try {
            this.putData(new DataOutNBT(nbttagcompound));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.putData(new DataInPacket((DataInput)new ByteBufInputStream(data), Side.CLIENT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            this.putData(new DataOutPacket((DataOutput)new ByteBufOutputStream(data), Side.SERVER));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void putData(DataHelper data) throws IOException {
        this.motionHandler.putData(data);
    }

    void broadcast(NetworkFactorization.MessageType message_type, Object ... msg) {
        FMLProxyPacket p = Core.network.entityPacket(this, message_type, msg);
        Core.network.broadcastPacket(null, this.getCurrentPos(), p);
    }

    public void broadcastBriefUpdate() {
        Coord a = this.getCurrentPos();
        Coord b = this.getNextPos();
        this.broadcast(NetworkFactorization.MessageType.servo_brief, (byte)this.motionHandler.orientation.ordinal(), this.motionHandler.speed_b, a.x, a.y, a.z, b.x, b.y, b.z, Float.valueOf(this.motionHandler.pos_progress));
    }

    public void broadcastFullUpdate() {
        try {
            ByteBuf buf = Unpooled.buffer();
            Core.network.prefixEntityPacket(buf, this, NetworkFactorization.MessageType.servo_complete);
            DataOutByteBuf data = new DataOutByteBuf(buf, Side.SERVER);
            this.putData(data);
            FMLProxyPacket toSend = Core.network.entityPacket(buf);
            Core.network.broadcastPacket(null, this.getCurrentPos(), toSend);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.servo_stopped) {
            this.motionHandler.stopped = input.readBoolean();
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.servo_brief) {
            Coord a = this.getCurrentPos();
            Coord b = this.getNextPos();
            FzOrientation no = FzOrientation.getOrientation(input.readByte());
            this.setOrientation(no);
            this.motionHandler.speed_b = input.readByte();
            a.x = input.readInt();
            a.y = input.readInt();
            a.z = input.readInt();
            b.x = input.readInt();
            b.y = input.readInt();
            b.z = input.readInt();
            this.motionHandler.pos_progress = input.readFloat();
            if (this.motionHandler.speed_b > 0) {
                this.motionHandler.stopped = false;
            }
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.servo_complete) {
            try {
                DataInByteBuf data = new DataInByteBuf(input, Side.CLIENT);
                this.putData(data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public Coord getCurrentPos() {
        return this.motionHandler.pos_prev;
    }

    public Coord getNextPos() {
        return this.motionHandler.pos_next;
    }

    protected abstract void markDirty();

    public abstract boolean extractAccelerationEnergy();

    public boolean extractCharge(int amount) {
        IChargeConductor wire = this.getCurrentPos().getTE(IChargeConductor.class);
        if (wire == null) {
            return false;
        }
        return wire.getCharge().tryTake(amount) >= amount;
    }

    public void updateSocket() {
    }

    public void onEnterNewBlock() {
    }

    public FzOrientation getOrientation() {
        return this.motionHandler.orientation;
    }

    public void setOrientation(FzOrientation orientation) {
        this.motionHandler.orientation = orientation;
    }

    public void changeOrientation(ForgeDirection fd) {
        this.motionHandler.changeOrientation(fd);
    }

    public void setNextDirection(ForgeDirection direction) {
        this.motionHandler.nextDirection = direction;
    }

    public void setTargetSpeed(byte newTarget) {
        this.motionHandler.setTargetSpeed((byte)(newTarget - 1));
    }

    public byte getTargetSpeed() {
        return (byte)(this.motionHandler.target_speed_index + 1);
    }

    public void penalizeSpeed() {
        this.motionHandler.penalizeSpeed();
    }

    public void setStopped(boolean stop) {
        this.motionHandler.setStopped(stop);
    }

    public boolean isStopped() {
        return this.motionHandler.stopped;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70128_L) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.motionHandler.updateServoMotion();
            this.updateServoLogic();
        } else {
            if (!this.getNextPos().blockExists()) {
                return;
            }
            byte orig_speed = this.motionHandler.speed_b;
            FzOrientation orig_or = this.motionHandler.orientation;
            this.motionHandler.updateServoMotion();
            this.updateServoLogic();
            if (orig_speed != this.motionHandler.speed_b || orig_or != this.motionHandler.orientation) {
                this.broadcastBriefUpdate();
            }
        }
    }

    public abstract void updateServoLogic();

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int three) {
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        double dp = 1.0;
        this.field_70121_D.func_72324_b(x, y, z, x + dp, y + dp, z + dp);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        super.func_70080_a(x, y, z, yaw, pitch);
    }

    protected MotionHandler newMotionHandler() {
        return new MotionHandler(this);
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            return false;
        }
        Entity src = damageSource.func_76364_f();
        if (!(src instanceof EntityPlayer)) {
            return false;
        }
        if (this.field_70128_L) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)src;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (!player.field_71075_bZ.field_75099_e) {
            return false;
        }
        this.func_70106_y();
        if (!PlayerUtil.isPlayerCreative(player)) {
            this.dropItemsOnBreak();
        }
        return true;
    }

    protected abstract void dropItemsOnBreak();
}

