/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.FzColor;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.servo.Decorator;
import factorization.servo.TileEntityServoRail;
import factorization.shared.BlockRenderHelper;
import factorization.shared.FactorizationBlockRender;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRenderServoRail
extends FactorizationBlockRender {
    IIcon[] central = new IIcon[6];
    boolean[] sides = new boolean[6];
    BlockRenderHelper block;
    boolean[] extend = new boolean[6];
    public static IIcon[] coloredRails = new IIcon[FzColor.VALID_COLORS.length];

    void removeTextures(int i, int j) {
        if (!this.world_mode) {
            return;
        }
        if (this.sides[i]) {
            this.block.setTexture(i, null);
        }
        if (this.sides[j]) {
            this.block.setTexture(j, null);
        }
    }

    void restoreTextures(int a, int b) {
        IIcon icon = BlockIcons.servo$rail;
        this.block.setTexture(a, icon);
        this.block.setTexture(b, icon);
    }

    @Override
    public boolean render(RenderBlocks rb) {
        TileEntityServoRail rail = null;
        if (this.world_mode) {
            if (this.te instanceof TileEntityServoRail) {
                rail = (TileEntityServoRail)this.te;
            } else {
                return false;
            }
        }
        this.block = BlockRenderHelper.instance;
        if (rail != null) {
            rail.fillSideInfo(this.sides);
            this.block.setupBrightness(Tessellator.field_78398_a, this.w, this.x, this.y, this.z);
        } else {
            for (int i = 0; i < 6; ++i) {
                this.sides[i] = true;
            }
        }
        if (this.world_mode && rail != null) {
            Decorator dec;
            boolean has_comment = rail.comment != null && rail.comment.length() > 0;
            this.drawWithTexture(rb, has_comment ? BlockIcons.servo$rail_comment : BlockIcons.servo$rail);
            if (rail.color != FzColor.NO_COLOR) {
                this.drawWithTexture(rb, coloredRails[rail.color.toVanillaColorIndex()]);
            }
            if ((dec = rail.decoration) != null) {
                dec.renderStatic(rail.getCoord(), rb);
            }
        } else {
            float fL = 0.4375f;
            float fH = 0.5625f;
            this.block.useTexture(BlockIcons.servo$rail);
            this.block.func_149676_a(0.0f, 0.4375f, 0.4375f, 1.0f, 0.5625f, 0.5625f);
            this.block.renderForInventory(rb);
            this.block.func_149676_a(0.4375f, 0.0f, 0.4375f, 0.5625f, 1.0f, 0.5625f);
            this.block.renderForInventory(rb);
            this.block.func_149676_a(0.4375f, 0.4375f, 0.0f, 0.5625f, 0.5625f, 1.0f);
            this.block.renderForInventory(rb);
        }
        return true;
    }

    void drawWithTexture(RenderBlocks rb, IIcon icon) {
        float fL = 0.4375f;
        float fH = 0.5625f;
        this.block.useTexture(null);
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            int i = fd.ordinal();
            this.block.setTexture(i, icon);
            boolean any = false;
            for (ForgeDirection other : ForgeDirection.VALID_DIRECTIONS) {
                if (fd == other || fd == other.getOpposite()) continue;
                int ord = other.ordinal();
                this.extend[ord] = this.sides[ord];
                any |= this.extend[ord];
            }
            this.block.setTexture(i, (IIcon)(this.sides[i] && !any ? null : icon));
            this.block.func_149676_a(this.extend[4] ? 0.0f : 0.4375f, this.extend[0] ? 0.0f : 0.4375f, this.extend[2] ? 0.0f : 0.4375f, this.extend[5] ? 1.0f : 0.5625f, this.extend[1] ? 1.0f : 0.5625f, this.extend[3] ? 1.0f : 0.5625f);
            this.block.beginWithHipsterUVs();
            this.block.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
            Arrays.fill(this.extend, false);
            this.block.setTexture(i, null);
        }
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SERVORAIL;
    }

    public static void registerColoredIcons(IIconRegister reg) {
        for (int i = 0; i < FzColor.VALID_COLORS.length; ++i) {
            FzColor color = FzColor.VALID_COLORS[i];
            BlockRenderServoRail.coloredRails[i] = reg.func_94245_a("factorization:servo/colored_rails/" + color.toString().toLowerCase(Locale.ROOT));
        }
    }
}

