/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.BlockIcons;
import factorization.servo.ServoComponent;
import factorization.servo.ServoMotor;
import factorization.servo.TileEntityServoRail;
import factorization.servo.stepper.StepperEngine;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Decorator
extends ServoComponent {
    @SideOnly(value=Side.CLIENT)
    private static StretchedIIcon[] stretcher;

    public abstract void motorHit(ServoMotor var1);

    public boolean preMotorHit(ServoMotor motor) {
        return false;
    }

    public void stepperHit(StepperEngine engine) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Coord where, RenderBlocks rb) {
        if (stretcher == null) {
            stretcher = new StretchedIIcon[6];
            for (int i = 0; i < stretcher.length; ++i) {
                Decorator.stretcher[i] = new StretchedIIcon();
            }
        }
        BlockRenderHelper block = BlockRenderHelper.instance;
        float d = this.getSize();
        block.setBlockBoundsOffset(d, d, d);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection face = ForgeDirection.getOrientation((int)i);
            IIcon icon = this.getIcon(face);
            if (icon == null) {
                icon = BlockIcons.uv_test;
            }
            if (this.stretchIIcon()) {
                Decorator.stretcher[i].under = icon;
                block.setTexture(i, stretcher[i]);
                continue;
            }
            block.setTexture(i, icon);
        }
        if (where == null) {
            block.renderForTileEntity();
        } else {
            block.beginWithRotatedUVs();
            block.renderRotated(Tessellator.field_78398_a, where);
        }
    }

    public abstract IIcon getIcon(ForgeDirection var1);

    public float getSize() {
        return 0.43701172f;
    }

    public boolean stretchIIcon() {
        return true;
    }

    public static boolean playerHasProgrammer(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack cur = player.func_71045_bC();
        if (cur == null) {
            return false;
        }
        return cur.func_77973_b() == Core.registry.logicMatrixProgrammer;
    }

    public boolean isFreeToPlace() {
        return false;
    }

    public String getInfo() {
        return null;
    }

    public void onPlacedOnRail(TileEntityServoRail sr) {
    }

    public boolean collides() {
        return true;
    }

    public void afterClientLoad(TileEntityServoRail rail) {
    }

    @SideOnly(value=Side.CLIENT)
    private static class StretchedIIcon
    implements IIcon {
        public IIcon under;

        private StretchedIIcon() {
        }

        @SideOnly(value=Side.CLIENT)
        public int func_94211_a() {
            return this.under.func_94211_a();
        }

        @SideOnly(value=Side.CLIENT)
        public int func_94216_b() {
            return this.under.func_94216_b();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94209_e() {
            return this.under.func_94209_e();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94212_f() {
            return this.under.func_94212_f();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94214_a(double d0) {
            return d0 > 8.0 ? this.under.func_94212_f() : this.under.func_94209_e();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94206_g() {
            return this.under.func_94206_g();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94210_h() {
            return this.under.func_94210_h();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94207_b(double d0) {
            return d0 > 8.0 ? this.under.func_94210_h() : this.under.func_94206_g();
        }

        @SideOnly(value=Side.CLIENT)
        public String func_94215_i() {
            return this.under.func_94215_i();
        }
    }
}

