/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.common.ItemIcons;
import factorization.notify.Notice;
import factorization.notify.Style;
import factorization.servo.Decorator;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.FzUtil;
import factorization.util.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ItemMatrixProgrammer
extends ItemFactorization {
    private static final String authTagName = "fzLmpAuthenticated";
    private static StatBase authStat = new StatBase("factorization.lmpAuthenticated", (IChatComponent)new ChatComponentTranslation("factorization.lmpAuthenticated", new Object[0])).func_75971_g();

    public ItemMatrixProgrammer() {
        super("tool.matrix_programmer", Core.TabType.TOOLS);
        this.func_77625_d(1);
        this.func_77642_a(this);
        Core.loadBus((Object)this);
    }

    public boolean func_77630_h(ItemStack par1ItemStack) {
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Coord c = new Coord(world, x, y, z);
        TileEntityNote noteBlock = c.getTE(TileEntityNote.class);
        if (noteBlock != null) {
            if (world.field_72995_K) {
                return false;
            }
            byte orig_note = noteBlock.field_145879_a;
            int delta = player.func_70093_af() ? -1 : 1;
            int new_note = orig_note + delta;
            if (new_note < 0) {
                new_note = 24;
            } else if (new_note > 24) {
                new_note = 0;
            }
            noteBlock.field_145879_a = (byte)new_note;
            if (ForgeHooks.onNoteChange((TileEntityNote)noteBlock, (byte)orig_note)) {
                noteBlock.func_70296_d();
            }
            if (noteBlock.field_145879_a != orig_note) {
                noteBlock.func_145878_a(world, x, y, z);
            }
            new Notice(noteBlock, "noteblock.pitch." + noteBlock.field_145879_a, new String[0]).withStyle(Style.EXACTPOSITION).send(player);
            return true;
        }
        TileEntityServoRail rail = c.getTE(TileEntityServoRail.class);
        if (rail == null) {
            return false;
        }
        rail.priority = 0;
        Decorator decor = rail.getDecoration();
        if (player.func_70093_af()) {
            if (decor == null) {
                if (rail.color != FzColor.NO_COLOR) {
                    rail.color = FzColor.NO_COLOR;
                    c.redraw();
                    c.syncTE();
                }
                return false;
            }
            if (!(decor.isFreeToPlace() || player.field_71075_bZ.field_75098_d || world.field_72995_K)) {
                c.spawnItem(decor.toItem());
            }
            rail.setDecoration(null);
            c.redraw();
            return false;
        }
        return false;
    }

    public boolean func_77616_k(ItemStack is) {
        return true;
    }

    @SubscribeEvent
    public void clickPainting(EntityInteractEvent event) {
        EntityPainting.EnumArt origArt;
        ItemStack is = event.entityPlayer.func_70694_bm();
        if (is == null) {
            return;
        }
        if (is.func_77973_b() != this) {
            return;
        }
        if (!(event.target instanceof EntityPainting)) {
            return;
        }
        int d = event.entityPlayer.func_70093_af() ? -1 : 1;
        EntityPainting painting = (EntityPainting)event.target;
        if (painting.field_70170_p.field_72995_K) {
            return;
        }
        EntityPainting.EnumArt art = origArt = painting.field_70522_e;
        int hangingDirection = painting.field_82332_a;
        do {
            art = (EntityPainting.EnumArt)FzUtil.shiftEnum((Enum)art, (Enum[])EntityPainting.EnumArt.values(), (int)d);
            painting.func_82328_a(hangingDirection);
            painting.field_70522_e = art;
            if (art != origArt) continue;
            return;
        } while (!painting.func_70518_d());
        NBTTagCompound save = new NBTTagCompound();
        painting.func_70039_c(save);
        painting.func_70106_y();
        Entity newPainting = EntityList.func_75615_a((NBTTagCompound)save, (World)event.target.field_70170_p);
        newPainting.field_70170_p.func_72838_d(newPainting);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        ItemStack hat;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP me = mc.field_71439_g;
        if (me != null && stack != null && (stack == (hat = me.func_82169_q(3)) || me.func_70694_bm() == stack && this.isBowed((EntityPlayer)me) && hat == null)) {
            return ItemIcons.tool$matrix_programmer_tilted;
        }
        return super.func_77650_f(stack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_82169_q(3) == null && this.isBowed(player)) {
            ItemStack mask = stack.func_77979_a(1);
            player.func_70062_b(4, mask);
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void removeMask(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.func_70093_af()) {
            return;
        }
        if (player.func_70694_bm() != null) {
            return;
        }
        ItemStack helmet = player.func_82169_q(3);
        if (helmet == null || helmet.func_77973_b() != this) {
            return;
        }
        if (!this.isBowed(player)) {
            return;
        }
        player.func_70062_b(4, null);
        player.func_70062_b(0, helmet);
        event.setCanceled(true);
        Core.proxy.updatePlayerInventory(player);
    }

    boolean isBowed(EntityPlayer player) {
        return player.field_70125_A > 75.0f && player.func_70093_af();
    }

    public static boolean isUserAuthenticated(EntityPlayerMP player) {
        if (PlayerUtil.isPlayerCreative((EntityPlayer)player)) {
            return true;
        }
        if (Core.dev_environ) {
            return false;
        }
        StatisticsFile statsFile = PlayerUtil.getStatsFile((EntityPlayer)player);
        return statsFile != null && statsFile.func_77444_a(authStat) > 0 || player.getEntityData().func_74764_b(authTagName);
    }

    public static void setUserAuthenticated(EntityPlayerMP player) {
        StatisticsFile statsFile = PlayerUtil.getStatsFile((EntityPlayer)player);
        if (statsFile != null) {
            statsFile.func_150873_a((EntityPlayer)player, authStat, 1);
        }
        player.getEntityData().func_74757_a(authTagName, true);
    }

    @SubscribeEvent
    public void preserveAuthState(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP && ItemMatrixProgrammer.isUserAuthenticated((EntityPlayerMP)player)) {
            ItemMatrixProgrammer.setUserAuthenticated((EntityPlayerMP)player);
        }
    }

    public boolean isAuthenticated(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b() == this && is.func_77960_j() == 2;
    }

    public boolean setAuthenticated(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (is.func_77973_b() != this) {
            return false;
        }
        if (is.func_77960_j() == 2) {
            return false;
        }
        is.func_77964_b(2);
        return true;
    }
}

