/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInByteBuf;
import factorization.api.datahelpers.DataInByteBufClientEdited;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.servo.AbstractServoMachine;
import factorization.servo.Decorator;
import factorization.servo.Executioner;
import factorization.servo.ItemServoRailWidget;
import factorization.servo.ServoComponent;
import factorization.servo.ServoStack;
import factorization.servo.TileEntityServoRail;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.NetworkFactorization;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import factorization.sockets.GuiDataConfig;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketEmpty;
import factorization.sockets.TileEntitySocketBase;
import factorization.util.DataUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ServoMotor
extends AbstractServoMachine
implements IInventory,
ISocketHolder {
    public Executioner executioner = new Executioner(this);
    public TileEntitySocketBase socket = new SocketEmpty();
    public boolean isSocketActive = false;
    public boolean isSocketPulsed = false;
    ItemStack[] inv = new ItemStack[1];
    ItemStack[] inv_last_sent = new ItemStack[this.inv.length];
    private final ArrayList<MovingObjectPosition> ret = new ArrayList();
    private static final Vec3 nullVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    public ServoMotor(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70178_ae = true;
    }

    public void syncWithSpawnPacket() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Packet p = FMLNetworkHandler.getEntitySpawningPacket((Entity)this);
        FzNetDispatch.addPacketFrom(p, this);
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        super.putData(data);
        this.executioner.putData(data);
        int invSize = data.as(Share.VISIBLE, "inv#").putByte((byte)this.inv.length);
        this.resizeInventory(invSize);
        for (int i = 0; i < invSize; ++i) {
            ItemStack is = NetworkFactorization.nullItem(this.inv[i]);
            is = data.as(Share.VISIBLE, "inv" + i).putItemStack(is);
            this.inv[i] = is == null ? null : (is.func_77973_b() == null ? null : is);
        }
        data.as(Share.VISIBLE, "sock");
        if (data.isReader()) {
            NBTTagCompound tag = data.putTag(new NBTTagCompound());
            TileEntity te = TileEntity.func_145827_c((NBTTagCompound)tag);
            this.socket = te instanceof TileEntitySocketBase ? (TileEntitySocketBase)te : new SocketEmpty();
        } else {
            NBTTagCompound output = new NBTTagCompound();
            this.socket.func_145841_b(output);
            data.putTag(output);
        }
        this.isSocketActive = data.as(Share.VISIBLE, "sockon").putBoolean(this.isSocketActive);
        this.isSocketPulsed = data.as(Share.VISIBLE, "sockpl").putBoolean(this.isSocketPulsed);
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.DataHelperEditOnEntity) {
            DataInByteBufClientEdited di = new DataInByteBufClientEdited(input);
            this.socket.serialize("", di);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case OpenDataHelperGuiOnEntity: {
                if (!this.field_70170_p.field_72995_K) {
                    return false;
                }
                DataInByteBuf dip = new DataInByteBuf(input, Side.CLIENT);
                this.socket.serialize("", dip);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDataConfig(this.socket, this));
                return true;
            }
            case servo_item: {
                byte index;
                while ((index = input.readByte()) >= 0) {
                    this.inv[index] = DataUtil.readStack(input);
                }
                return true;
            }
            case TileEntityMessageOnEntity: {
                NetworkFactorization.MessageType subMsg = NetworkFactorization.MessageType.read(input);
                return this.socket.handleMessageFromServer(subMsg, input);
            }
        }
        return this.socket.handleMessageFromServer(messageType, input);
    }

    @Override
    public void updateServoLogic() {
        if (this.field_70170_p.field_72995_K) {
            this.executioner.tick();
            return;
        }
        this.executioner.tick();
        if (!this.executioner.stacks_changed) {
            return;
        }
        this.executioner.stacks_changed = false;
        this.broadcastFullUpdate();
    }

    @Override
    public void updateSocket() {
        Coord here = this.getCurrentPos();
        here.setAsTileEntityLocation(this.socket);
        this.socket.facing = this.motionHandler.orientation.top;
        this.socket.genericUpdate(this, here, this.isSocketActive ^ this.isSocketPulsed);
        this.isSocketPulsed = false;
    }

    @Override
    public void onEnterNewBlock() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.socket.onEnterNewBlock();
        this.motionHandler.onEnterNewBlock();
        TileEntityServoRail rail = this.getCurrentPos().getTE(TileEntityServoRail.class);
        if (rail != null && rail.decoration != null && rail.decoration.preMotorHit(this)) {
            return;
        }
        this.executioner.onEnterNewBlock(rail);
    }

    public ServoStack getArgStack() {
        return this.executioner.getArgStack();
    }

    public ServoStack getInstructionsStack() {
        return this.executioner.getInstructionStack();
    }

    public ServoStack getEntryInstructionStack() {
        return this.executioner.getEntryInstructionStack();
    }

    public void putError(Object error) {
        this.executioner.putError(error);
    }

    protected void func_70088_a() {
    }

    public boolean func_130002_c(EntityPlayer player) {
        FzColor newColor;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.executioner.stacks_changed = true;
        ItemStack is = ItemUtil.normalize(player.func_70694_bm());
        if (is == null) {
            return false;
        }
        Item item = is.func_77973_b();
        if (item instanceof ItemServoRailWidget) {
            FactoryType[] sc = ServoComponent.fromItem(is);
            if (player.func_70093_af()) {
                if (!sc.onClick(player, this)) {
                    return false;
                }
                ItemStack updated = sc.toItem();
                is.func_77964_b(updated.func_77960_j());
                is.func_77982_d(updated.func_77978_p());
                return true;
            }
            if (sc instanceof Decorator) {
                Decorator dec = (Decorator)sc;
                dec.motorHit(this);
                return true;
            }
        }
        if (this.socket == null) {
            return false;
        }
        if (this.socket.activateOnServo(player, this)) {
            return false;
        }
        if (ItemUtil.identical(this.socket.getCreatingItem(), is)) {
            return false;
        }
        for (FactoryType ft : FactoryType.values()) {
            TileEntitySocketBase rep;
            ItemStack creator;
            TileEntityCommon tec = ft.getRepresentative();
            if (tec == null || !(tec instanceof TileEntitySocketBase) || (creator = (rep = (TileEntitySocketBase)tec).getCreatingItem()) == null || !ItemUtil.couldMerge(is, creator)) continue;
            if (rep.getParentFactoryType() != this.socket.getFactoryType()) {
                rep.mentionPrereq(this, player);
                return false;
            }
            TileEntityCommon upgrade = ft.makeTileEntity();
            if (upgrade == null) continue;
            this.socket = (TileEntitySocketBase)upgrade;
            if (!player.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
            Sound.servoInstall.playAt(new Coord(this));
            this.socket.installedOnServo(this);
            return true;
        }
        if (this.motionHandler.color == FzColor.NO_COLOR && (newColor = FzColor.fromItem(is)) != FzColor.NO_COLOR) {
            this.motionHandler.color = newColor;
            this.func_70296_d();
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70062_b(0, ItemUtil.normalDecr(is));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void dropItemsOnBreak() {
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        toDrop.add(new ItemStack((Item)Core.registry.servo_placer));
        toDrop.addAll(Arrays.asList(this.inv));
        if (this.socket != null) {
            TileEntitySocketBase sb;
            this.socket.uninstall();
            FactoryType ft = this.socket.getFactoryType();
            while (ft != null && (sb = (TileEntitySocketBase)ft.getRepresentative()) != null) {
                ItemStack is = sb.getCreatingItem();
                if (is != null) {
                    toDrop.add(is.func_77946_l());
                }
                ft = sb.getParentFactoryType();
            }
        }
        this.dropItemStacks(toDrop);
    }

    public void dropItemStacks(Iterable<ItemStack> toDrop) {
        for (ItemStack is : toDrop) {
            InvUtil.spawnItemStack(this, is);
        }
    }

    public void resizeInventory(int newSize) {
        if (newSize == this.inv.length) {
            return;
        }
        ItemStack[] origInv = this.inv;
        int min = Math.min(newSize, origInv.length);
        this.inv = new ItemStack[newSize];
        for (int i = 0; i < min; ++i) {
            this.inv[i] = origInv[i];
            origInv[i] = null;
        }
        for (ItemStack is : origInv) {
            if (is == null) continue;
            this.getCurrentPos().spawnItem(is);
        }
        this.inv_last_sent = new ItemStack[newSize];
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack ret = this.inv[i].func_77979_a(j);
        this.inv[i] = ItemUtil.normalize(this.inv[i]);
        return ret;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv[i] = itemstack;
    }

    public String func_145825_b() {
        return "Servo Motor Inventory";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        ArrayList<Number> toSend = new ArrayList<Number>(this.inv.length * 2);
        for (byte i = 0; i < this.inv.length; i = (byte)(i + 1)) {
            if (ItemUtil.identical(this.inv[i], this.inv_last_sent[i])) continue;
            toSend.add(i);
            toSend.add((Number)NetworkFactorization.nullItem(this.inv[i]));
            this.inv_last_sent[i] = this.inv[i];
        }
        if (toSend.isEmpty()) {
            return;
        }
        toSend.add(-1);
        this.broadcast(NetworkFactorization.MessageType.servo_item, toSend.toArray());
        this.getCurrentPos().getChunk().func_76630_e();
        this.getNextPos().getChunk().func_76630_e();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    ArrayList<MovingObjectPosition> rayTrace() {
        this.ret.clear();
        Coord c = this.getCurrentPos();
        ForgeDirection top = this.motionHandler.orientation.top;
        ForgeDirection face = this.motionHandler.orientation.facing;
        ForgeDirection right = face.getRotation(top);
        AxisAlignedBB ab = AxisAlignedBB.func_72330_a((double)(c.x + top.offsetX), (double)(c.y + top.offsetY), (double)(c.z + top.offsetZ), (double)(c.x + 1 + top.offsetX), (double)(c.y + 1 + top.offsetY), (double)(c.z + 1 + top.offsetZ));
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, ab)) {
            if (!entity.func_70067_L()) continue;
            this.ret.add(new MovingObjectPosition(entity));
        }
        ServoMotor.nullVec.field_72449_c = 0.0;
        ServoMotor.nullVec.field_72448_b = 0.0;
        ServoMotor.nullVec.field_72450_a = 0.0;
        Coord targetBlock = c.add(top);
        this.mopBlock(this.ret, targetBlock, top.getOpposite());
        this.mopBlock(this.ret, targetBlock.add(top), top.getOpposite());
        this.mopBlock(this.ret, targetBlock.add(top.getOpposite()), top);
        if (this.ret.size() == 0) {
            this.mopBlock(this.ret, targetBlock.add(face), face.getOpposite());
            this.mopBlock(this.ret, targetBlock.add(face.getOpposite()), face);
            if (this.ret.size() == 0) {
                this.mopBlock(this.ret, targetBlock.add(right), right.getOpposite());
                this.mopBlock(this.ret, targetBlock.add(right.getOpposite()), right);
            }
        }
        return this.ret;
    }

    void mopBlock(ArrayList<MovingObjectPosition> list, Coord target, ForgeDirection side) {
        if (target.isAir()) {
            return;
        }
        list.add(target.createMop(side, nullVec));
    }

    @Override
    public boolean dumpBuffer(List<ItemStack> buffer) {
        if (buffer.isEmpty()) {
            return false;
        }
        InvUtil.FzInv me = InvUtil.openInventory(this, false);
        ItemStack got = buffer.get(0);
        if (got == null) {
            buffer.remove(0);
            return true;
        }
        ItemStack res = me.push(buffer.get(0));
        if (res == null) {
            buffer.remove(0);
        } else {
            buffer.set(0, res);
        }
        return true;
    }

    @Override
    public void sendMessage(NetworkFactorization.MessageType msgType, Object ... msg) {
        Object[] buff = new Object[msg.length + 1];
        System.arraycopy(msg, 0, buff, 1, msg.length);
        buff[0] = msgType;
        FMLProxyPacket toSend = Core.network.entityPacket(this, NetworkFactorization.MessageType.TileEntityMessageOnEntity, buff);
        Core.network.broadcastPacket(null, this.getCurrentPos(), toSend);
    }

    @Override
    public Vec3 getPos() {
        return SpaceUtil.fromEntPos(this);
    }

    @Override
    public boolean extractAccelerationEnergy() {
        return this.extractCharge(2);
    }
}

