/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo;

import factorization.api.FzColor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.UnionEnumeration;
import factorization.servo.Executioner;
import factorization.servo.Instruction;
import factorization.servo.instructions.GenericPlaceholder;
import factorization.shared.Core;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;

public class ServoStack
implements IDataSerializable,
Iterable {
    private ArrayDeque<Object> contents = new ArrayDeque();
    private final int maxSize = 16;
    private final Executioner executioner;
    static final UnionEnumeration stackableTypes = ServoStack.buildUnion();

    public ServoStack(Executioner executioner) {
        this.executioner = executioner;
    }

    public void setContentsList(Collection<Object> obj) {
        this.clear();
        this.contents.addAll(obj);
    }

    public void clear() {
        this.contents.clear();
        this.executioner.stacks_changed = true;
    }

    public boolean push(Object o) {
        if (o == null) {
            Core.logSevere("Tried to push null!", new Object[0]);
            Thread.dumpStack();
            return false;
        }
        if (this.contents.size() >= 16) {
            return false;
        }
        this.contents.addFirst(o);
        this.executioner.stacks_changed = true;
        return true;
    }

    public boolean append(Object o) {
        if (o == null) {
            Core.logSevere("Tried to append null!", new Object[0]);
            Thread.dumpStack();
            return false;
        }
        if (this.contents.size() >= 16) {
            return false;
        }
        this.contents.add(o);
        this.executioner.stacks_changed = true;
        return true;
    }

    public void forceAppend(Object o) {
        this.contents.add(o);
        this.executioner.stacks_changed = true;
    }

    public Object pop() {
        if (this.contents.isEmpty()) {
            return null;
        }
        this.executioner.stacks_changed = true;
        return this.contents.removeFirst();
    }

    public Object peek() {
        if (this.contents.isEmpty()) {
            return null;
        }
        return this.contents.getFirst();
    }

    public Object popEnd() {
        if (this.contents.isEmpty()) {
            return null;
        }
        this.executioner.stacks_changed = true;
        return this.contents.removeLast();
    }

    public <E> E popType(Class<? extends E> eClass) {
        return this.popType(eClass, true);
    }

    public Object remove(int index) {
        if (index >= this.contents.size()) {
            return null;
        }
        return this.contents.remove(index);
    }

    public <E> E findType(Class<? extends E> eClass) {
        return this.popType(eClass, false);
    }

    private <E> E popType(Class<? extends E> eClass, boolean remove) {
        Iterator<Object> it = this.contents.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null) {
                it.remove();
                continue;
            }
            if (o.getClass() != eClass && !eClass.isInstance(o)) continue;
            if (remove) {
                this.executioner.stacks_changed = true;
                it.remove();
            }
            return (E)o;
        }
        return null;
    }

    public Iterator<Object> iterator() {
        return this.contents.iterator();
    }

    public Iterator<Object> descendingIterator() {
        return this.contents.descendingIterator();
    }

    public int getMaxSize() {
        return 16;
    }

    public int getFreeSpace() {
        return Math.max(0, 16 - this.contents.size());
    }

    public int getSize() {
        return this.contents.size();
    }

    static UnionEnumeration buildUnion() {
        UnionEnumeration ret = UnionEnumeration.build(new Object[]{Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Void.TYPE, null, Instruction.class, new GenericPlaceholder(), Boolean.class, false, Byte.class, (byte)0, Short.class, (short)0, Integer.class, 0, Long.class, 0L, Float.class, Float.valueOf(0.0f), Double.class, 0.0, String.class, "", FzColor.class, FzColor.BLACK});
        if (ret.getIndex(false) != 10) {
            throw new AssertionError();
        }
        if (ret.getIndex(new GenericPlaceholder()) != 9) {
            throw new AssertionError();
        }
        return ret;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        int length = data.asSameShare(prefix + "_size").putInt(this.contents.size());
        if (length == 0) {
            if (data.isReader()) {
                this.contents.clear();
            }
            return this;
        }
        prefix = prefix + "#";
        if (data.isWriter()) {
            int i = 0;
            for (Object o : this.contents) {
                this.writeObject(data, prefix + i++, o);
            }
        } else {
            this.contents.clear();
            for (int i = 0; i < length; ++i) {
                Object n = this.readObject(data, prefix + i);
                if (n == null) continue;
                this.contents.add(n);
            }
        }
        return this;
    }

    void writeObject(DataHelper data, String entryName, Object value) throws IOException {
        data.asSameShare(entryName).putUnion(stackableTypes, value);
    }

    Object readObject(DataHelper data, String entryName) throws IOException {
        return data.asSameShare(entryName).putUnion(stackableTypes, null);
    }

    public String toString() {
        return this.contents.toString();
    }
}

