/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import com.google.common.base.Joiner;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.Executioner;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.ServoStack;
import factorization.shared.Core;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class InstructionGroup
extends Instruction {
    ServoStack stuff = new ServoStack(new Executioner(null));

    @Override
    public IDataSerializable putData(String prefix, DataHelper data) throws IOException {
        this.stuff = data.as(Share.VISIBLE, "contents").putIDS(this.stuff);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Items.field_151123_aH);
    }

    @Override
    protected void addRecipes() {
        super.addRecipes();
        Core.registry.vanillaShapelessRecipe(this.toItem(), this.toItem());
    }

    @Override
    public void motorHit(ServoMotor motor) {
        Iterator<Object> it = this.stuff.descendingIterator();
        ServoStack ss = motor.getInstructionsStack();
        while (it.hasNext()) {
            ss.push(it.next());
        }
    }

    @Override
    public boolean onClick(EntityPlayer player, ServoMotor motor) {
        if (this.stuff.getSize() > 0) {
            return false;
        }
        ServoStack ss = motor.getArgStack();
        if (ss.getSize() <= 0) {
            return false;
        }
        while (ss.getSize() > 0) {
            this.stuff.push(ss.pop());
        }
        return true;
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        if (this.stuff.getSize() > 0) {
            return BlockIcons.servo$group_something;
        }
        return BlockIcons.servo$group_empty;
    }

    @Override
    public String getName() {
        return "fz.instruction.group";
    }

    @Override
    public void addInformation(List info) {
        if (this.stuff.getSize() <= 0) {
            info.add("Empty");
            return;
        }
        for (Object obj : this.stuff) {
            info.add(obj.toString());
        }
    }

    @Override
    public String getInfo() {
        ArrayList bits = new ArrayList();
        this.addInformation(bits);
        return Joiner.on((String)"\n").join(bits);
    }
}

