/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.CpuBlocking;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class SetSpeed
extends Instruction {
    byte speed = (byte)3;

    @Override
    public IDataSerializable putData(String prefix, DataHelper data) throws IOException {
        this.speed = data.isReader() && data.isNBT() && !data.hasLegacy(prefix + "speedB") ? data.as(Share.VISIBLE, "sc").putByte(this.speed) : data.as(Share.VISIBLE, prefix + "speedB").putByte(this.speed);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Items.field_151102_aT);
    }

    @Override
    public void motorHit(ServoMotor motor) {
        byte origSpeed = motor.getTargetSpeed();
        motor.setTargetSpeed(this.speed);
        if (origSpeed != motor.getTargetSpeed()) {
            motor.func_70296_d();
        }
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        switch (this.speed) {
            default: {
                return BlockIcons.servo$speed1;
            }
            case 2: {
                return BlockIcons.servo$speed2;
            }
            case 3: {
                return BlockIcons.servo$speed3;
            }
            case 4: {
                return BlockIcons.servo$speed4;
            }
            case 5: 
        }
        return BlockIcons.servo$speed5;
    }

    @Override
    public String getName() {
        return "fz.instruction.setspeed";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!SetSpeed.playerHasProgrammer(player)) {
            return false;
        }
        this.speed = (byte)(this.speed + 1);
        if (this.speed == 6) {
            this.speed = 1;
        }
        return true;
    }

    @Override
    public String getInfo() {
        switch (this.speed) {
            default: {
                return "Slowest";
            }
            case 2: {
                return "Slow";
            }
            case 3: {
                return "Normal";
            }
            case 4: {
                return "Fast";
            }
            case 5: 
        }
        return "Faster";
    }

    @Override
    public CpuBlocking getBlockingBehavior() {
        return CpuBlocking.BLOCK_FOR_TICK;
    }
}

