/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.CpuBlocking;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.stepper.StepperEngine;
import factorization.shared.Core;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class SocketCtrl
extends Instruction {
    static final byte MODE_PULSE = 0;
    static final byte MODE_POWER = 1;
    static final byte MODE_UNPOWER = 2;
    byte mode = 0;

    @Override
    public IDataSerializable putData(String prefix, DataHelper data) throws IOException {
        this.mode = data.as(Share.VISIBLE, "mode").putByte(this.mode);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return Core.registry.empty_socket_item;
    }

    @Override
    public void stepperHit(StepperEngine engine) {
        if (this.mode == 1) {
            engine.fzdsGrab();
        } else if (this.mode == 2) {
            engine.fzdsRelease();
        } else if (engine.grabbed()) {
            engine.fzdsRelease();
        } else {
            engine.fzdsGrab();
        }
    }

    @Override
    public void motorHit(ServoMotor motor) {
        if (this.mode == 1) {
            motor.isSocketActive = true;
        } else if (this.mode == 2) {
            motor.isSocketActive = false;
        } else {
            motor.isSocketPulsed = true;
        }
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        if (this.mode == 1) {
            return BlockIcons.servo$socket_on;
        }
        if (this.mode == 2) {
            return BlockIcons.servo$socket_off;
        }
        return BlockIcons.servo$socket_pulse;
    }

    @Override
    public String getInfo() {
        if (this.mode == 1) {
            return "Socket Powered";
        }
        if (this.mode == 2) {
            return "Socket Unpowered";
        }
        return "Socket Pulse";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (!SocketCtrl.playerHasProgrammer(player)) {
            return false;
        }
        this.mode = (byte)(this.mode + 1);
        if (this.mode > 2) {
            this.mode = 0;
        }
        return true;
    }

    @Override
    public String getName() {
        return "fz.instruction.socketCtrl";
    }

    @Override
    public CpuBlocking getBlockingBehavior() {
        return CpuBlocking.BLOCK_FOR_TICK;
    }
}

