/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.instructions;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.servo.AbstractServoMachine;
import factorization.servo.CpuBlocking;
import factorization.servo.Instruction;
import factorization.servo.ServoMotor;
import factorization.servo.stepper.StepperEngine;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class Spin
extends Instruction {
    boolean cc = true;

    @Override
    public IDataSerializable putData(String prefix, DataHelper data) throws IOException {
        this.cc = data.as(Share.VISIBLE, prefix + "cc").putBoolean(this.cc);
        return this;
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block, ForgeDirection side) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (Spin.playerHasProgrammer(player)) {
            this.cc = !this.cc;
            return true;
        }
        return false;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Items.field_151007_F);
    }

    void hit(AbstractServoMachine motor) {
        int i;
        ForgeDirection newTop = motor.getOrientation().top;
        int n = i = this.cc ? 3 : 1;
        while (i > 0) {
            newTop = newTop.getRotation(motor.getOrientation().facing);
            --i;
        }
        FzOrientation next = motor.getOrientation().pointTopTo(newTop);
        if (next != FzOrientation.UNKNOWN) {
            motor.setOrientation(next);
        }
    }

    @Override
    public void motorHit(ServoMotor motor) {
        this.hit(motor);
    }

    @Override
    public void stepperHit(StepperEngine engine) {
        this.hit(engine);
    }

    @Override
    public IIcon getIcon(ForgeDirection side) {
        return this.cc ? BlockIcons.servo$spin_cc : BlockIcons.servo$spin_ccc;
    }

    @Override
    public String getName() {
        return "fz.instruction.spin";
    }

    @Override
    public CpuBlocking getBlockingBehavior() {
        return CpuBlocking.BLOCK_UNTIL_NEXT_ENTRY;
    }
}

