/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.stepper;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.interfaces.IDCController;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.servo.stepper.DropMode;
import factorization.servo.stepper.IdcDropper;
import factorization.shared.EntityFz;
import factorization.shared.EntityReference;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityGrabController
extends EntityFz
implements IDCController {
    private static final long WAIT_TIME = 600L;
    final EntityReference<Entity> holderRef = new EntityReference();
    final EntityReference<IDeltaChunk> idcRef = new EntityReference<IDeltaChunk>().whenFound(new EntityReference.OnFound<IDeltaChunk>(){

        @Override
        public void found(IDeltaChunk ent) {
            ent.setController(EntityGrabController.this);
        }
    });
    DropMode dropMode = DropMode.EVENTUALLY;
    long unheldTime = 0L;
    boolean needs_future_glue_applied = true;
    transient AxisAlignedBB hitReal;
    transient AxisAlignedBB hitShadow;

    public EntityGrabController(World w) {
        super(w);
    }

    public EntityGrabController(Entity holder, IDeltaChunk idc, DropMode dropMode) {
        super(holder.field_70170_p);
        this.holderRef.trackEntity(holder);
        this.idcRef.trackEntity(idc);
        this.dropMode = dropMode;
        SpaceUtil.toEntPos(this, SpaceUtil.fromEntPos(holder));
    }

    @Override
    protected void putData(DataHelper data) throws IOException {
        this.holderRef.serialize("holder", data);
        this.idcRef.serialize("idc", data);
        this.dropMode = data.as(Share.PRIVATE, "dropMode").putEnum(this.dropMode);
        this.unheldTime = data.as(Share.PRIVATE, "unheldTime").putLong(this.unheldTime);
        this.needs_future_glue_applied = data.as(Share.PRIVATE, "need4glue").putBoolean(this.needs_future_glue_applied);
    }

    protected void func_70088_a() {
    }

    public void release() {
        this.holderRef.trackEntity(null);
    }

    public boolean isUngrabbed() {
        return !this.holderRef.trackingEntity();
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        super.func_70071_h_();
        IDeltaChunk idc = this.idcRef.getEntity();
        Entity holder = this.holderRef.getEntity();
        if (idc != null && !this.holderRef.trackingEntity()) {
            if (this.unheldTime++ > 600L && this.unheldTime % 20L == 0L) {
                EntityGrabController.drop(idc);
            }
        } else {
            this.unheldTime = 0L;
        }
        if (holder != null && holder.field_70128_L) {
            this.holderRef.trackEntity(null);
        }
        if (idc != null && idc.field_70128_L) {
            this.func_70106_y();
        }
    }

    public static void drop(IDeltaChunk idc) {
        Coord min = idc.getCorner();
        Coord max = idc.getFarCorner();
        ForgeDirection up = ForgeDirection.UP;
        ForgeDirection south = ForgeDirection.SOUTH;
        ForgeDirection east = ForgeDirection.EAST;
        Coord realStart = idc.shadow2realCoord(min);
        DeltaCoord range = max.difference(min);
        Quaternion rot = idc.getRotation();
        ArrayList<ForgeDirection> known = new ArrayList<ForgeDirection>();
        Collections.addAll(known, ForgeDirection.VALID_DIRECTIONS);
        up = SpaceUtil.rotateDirectionAndExclude(up, rot, known);
        south = SpaceUtil.rotateDirectionAndExclude(south, rot, known);
        east = SpaceUtil.rotateDirectionAndExclude(east, rot, known);
        int bestScore = Integer.MAX_VALUE;
        DeltaCoord bestShift = null;
        for (DeltaCoord shift : DeltaCoord.directNeighborsPlusMe) {
            IdcDropper dropper = new IdcDropper(up, south, east, min, realStart.add(shift), range, true);
            int score = dropper.drop(true);
            if (score >= bestScore) continue;
            bestScore = score;
            bestShift = shift;
        }
        IdcDropper dropper = new IdcDropper(up, south, east, min, realStart.add(bestShift), range, true);
        if (dropper.drop(false) > 0) {
            ((DimensionSliceEntity)idc).removeItemEntities();
        }
        idc.func_70106_y();
    }

    @Override
    public boolean placeBlock(IDeltaChunk idc, EntityPlayer player, Coord at) {
        return true;
    }

    @Override
    public boolean breakBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return true;
    }

    @Override
    public boolean hitBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return true;
    }

    @Override
    public boolean useBlock(IDeltaChunk idc, EntityPlayer player, Coord at, byte sideHit) {
        return true;
    }

    @Override
    public void beforeUpdate(IDeltaChunk idc) {
        Entity holder = this.holderRef.getEntity();
        if (holder == null) {
            idc.func_70016_h(0.0, 0.0, 0.0);
            return;
        }
        double dx = holder.field_70165_t - holder.field_70169_q;
        double dy = holder.field_70163_u - holder.field_70167_r;
        double dz = holder.field_70161_v - holder.field_70166_s;
        idc.func_70016_h(dx, dy, dz);
    }

    @Override
    public void afterUpdate(IDeltaChunk idc) {
        Entity holder = this.holderRef.getEntity();
        if (holder == null) {
            return;
        }
        idc.func_70107_b(holder.field_70165_t, holder.field_70163_u, holder.field_70161_v);
    }

    @Override
    public boolean onAttacked(IDeltaChunk idc, DamageSource damageSource, float damage) {
        return false;
    }

    @Override
    public IDCController.CollisionAction collidedWithWorld(World realWorld, AxisAlignedBB realBox, World shadowWorld, AxisAlignedBB shadowBox) {
        this.hitReal = realBox.func_72329_c();
        this.hitShadow = shadowBox.func_72329_c();
        return IDCController.CollisionAction.STOP_INSIDE;
    }

    @Override
    public void idcDied(IDeltaChunk idc) {
        this.func_70106_y();
    }
}

