/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.stepper;

import factorization.algos.FastBag;
import factorization.api.Coord;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class GrabConnector {
    final Coord start;
    int avail;
    Block primary;
    final FastBag<Coord> frontier = new FastBag();
    final HashSet<Coord> found = new HashSet();
    Block[] natch = new Block[]{Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150424_aL, Blocks.field_150377_bs, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150353_l, Blocks.field_150356_k};

    public GrabConnector(Coord start, int maxSize) {
        this.start = start;
        this.avail = maxSize;
        this.primary = start.getBlock();
        if (start.isAir()) {
            throw new IllegalArgumentException("Don't grab air");
        }
        this.found.add(start);
        this.frontier.add(start);
    }

    Coord glueCheck(Coord at, ForgeDirection dir) {
        Coord neighbor = at.add(dir);
        Block neighborBlock = neighbor.getBlock();
        if (neighborBlock == Core.registry.factory_block && at.getMd() == BlockClass.Wire.md) {
            return null;
        }
        if (neighborBlock == this.primary) {
            return neighbor;
        }
        for (Block n : this.natch) {
            if (n != neighborBlock) continue;
            return null;
        }
        if (neighbor.isAir()) {
            return null;
        }
        if (neighborBlock == at.getBlock() && at.isSolid()) {
            return neighbor;
        }
        return null;
    }

    public Collection<Coord> fill() {
        block0: while (!this.frontier.isEmpty()) {
            Coord at = this.frontier.removeAny();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Coord next = this.glueCheck(at, dir);
                if (next == null || !this.found.add(next)) continue;
                this.frontier.add(next);
                if (this.avail-- <= 0) continue block0;
            }
        }
        return this.found;
    }
}

