/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.stepper;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.fzds.TransferLib;
import net.minecraftforge.common.util.ForgeDirection;

public class IdcDropper {
    final ForgeDirection ax;
    final ForgeDirection ay;
    final ForgeDirection az;
    final Coord src;
    final Coord dst;
    final DeltaCoord range;
    final boolean breakSrcElseDest;
    int fails = 0;

    public IdcDropper(ForgeDirection up, ForgeDirection south, ForgeDirection east, Coord src, Coord dst, DeltaCoord range, boolean breakSrcElseDest) {
        this.ax = east;
        this.ay = up;
        this.az = south;
        this.src = src;
        this.dst = dst;
        this.range = range;
        this.breakSrcElseDest = breakSrcElseDest;
        if (range.isSubmissive()) {
            throw new IllegalArgumentException("range must be positive");
        }
    }

    static void add(Coord ret, Coord src, ForgeDirection a1, int n1, ForgeDirection a2, int n2, ForgeDirection a3, int n3) {
        ret.x = src.x + a1.offsetX * n1 + a2.offsetX * n2 + a3.offsetX * n3;
        ret.y = src.y + a1.offsetY * n1 + a2.offsetY * n2 + a3.offsetY * n3;
        ret.z = src.z + a1.offsetZ * n1 + a2.offsetZ * n2 + a3.offsetZ * n3;
    }

    public int drop(boolean simulated) {
        Coord s = this.src.copy();
        Coord d = this.dst.copy();
        for (int dx = 0; dx < this.range.x; ++dx) {
            for (int dy = 0; dy < this.range.y; ++dy) {
                for (int dz = 0; dz < this.range.z; ++dz) {
                    IdcDropper.add(s, this.src, this.ax, dx, this.ay, dy, this.az, dz);
                    IdcDropper.add(d, this.dst, this.ax, dx, this.ay, dy, this.az, dz);
                    this.move(s, d, simulated);
                }
            }
        }
        return this.fails;
    }

    private void move(Coord s, Coord d, boolean simulated) {
        if (simulated) {
            if (!d.isReplacable() && !d.isAir()) {
                this.fails += d.isSolid() ? 10 : 1;
            }
            return;
        }
        if (d.isReplacable()) {
            TransferLib.move(s, d, true, true);
            return;
        }
        if (this.breakSrcElseDest) {
            if (this.fails == 0 && !s.isAir()) {
                ++this.fails;
            }
            s.breakBlock();
        } else {
            d.breakBlock();
        }
    }
}

