/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.stepper;

import factorization.api.FzColor;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.fzds.DeltaChunk;
import factorization.fzds.Hammer;
import factorization.fzds.HammerEnabled;
import factorization.servo.BlockRenderServoRail;
import factorization.servo.stepper.StepperEngine;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.ObjectModel;
import factorization.util.NumUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderStepperEngine
extends RenderEntity {
    ObjectModel sprocket = new ObjectModel(Core.getResource("models/servo/sprocket.obj"));
    ObjectModel chasis = new ObjectModel(Core.getResource("models/servo/stepper.obj"));
    private Quaternion q0 = new Quaternion();
    private Quaternion q1 = new Quaternion();
    private static boolean debug_servo_orientation = false;

    float interp(double a, double b, double part) {
        double d = a - b;
        float r = (float)(b + d * part);
        double v = Math.min(1.0f, r * r * 4.0f);
        return (float)v;
    }

    public void func_76986_a(Entity ent, double x, double y, double z, float yaw, float partial) {
        Core.profileStartRender("servo");
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        if (HammerEnabled.ENABLED && DeltaChunk.getClientShadowWorld() == ent.field_70170_p) {
            mop = Hammer.proxy.getShadowHit();
        }
        boolean highlighted = mop != null && mop.field_72308_g == ent;
        StepperEngine motor = (StepperEngine)ent;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glPushMatrix();
        motor.motionHandler.interpolatePosition((float)Math.pow(motor.motionHandler.pos_progress, 2.0));
        float reorientInterpolation = this.interp(motor.motionHandler.servo_reorient, motor.motionHandler.prev_servo_reorient, partial);
        this.orientMotor(motor, partial, reorientInterpolation);
        this.renderMainModel(motor, partial, reorientInterpolation, false);
        if (highlighted) {
            GL11.glDisable((int)3553);
            GL11.glPushAttrib((int)16448);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float gray = 0.65f;
            GL11.glColor4f((float)gray, (float)gray, (float)gray, (float)0.8f);
            GL11.glLineWidth((float)1.5f);
            float d = 0.5f;
            float h = 0.25f;
            AxisAlignedBB ab = AxisAlignedBB.func_72330_a((double)(-d), (double)(-h), (double)(-d), (double)d, (double)h, (double)d);
            this.drawOutlinedBoundingBox(ab);
            ab.func_72317_d(ab.field_72340_a, ab.field_72338_b, ab.field_72339_c);
            GL11.glPopAttrib();
            GL11.glEnable((int)3553);
            EntityPlayer player = Core.proxy.getClientPlayer();
            if (player != null) {
                ItemStack is;
                for (int i = 0; i < 9 && ((is = player.field_71071_by.func_70301_a(i)) == null || is.func_77973_b() != Core.registry.logicMatrixProgrammer); ++i) {
                }
            }
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        motor.motionHandler.interpolatePosition(motor.motionHandler.pos_progress);
        GL11.glDisable((int)32826);
        Core.profileEndRender();
    }

    void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(3);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        tessellator.func_78381_a();
    }

    void orientMotor(StepperEngine motor, float partial, float reorientInterpolation) {
        Quaternion qt;
        FzOrientation orientation = motor.motionHandler.orientation;
        FzOrientation prevOrientation = motor.motionHandler.prevOrientation;
        if (prevOrientation == FzOrientation.UNKNOWN) {
            prevOrientation = orientation;
        }
        if (debug_servo_orientation) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glLineWidth((float)4.0f);
            GL11.glBegin((int)3);
            FzOrientation o = orientation;
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
            GL11.glLineWidth((float)2.0f);
            GL11.glBegin((int)3);
            o = prevOrientation;
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)o.facing.offsetX, (double)o.facing.offsetY, (double)o.facing.offsetZ);
            GL11.glVertex3d((double)(o.facing.offsetX + o.top.offsetX), (double)(o.facing.offsetY + o.top.offsetY), (double)(o.facing.offsetZ + o.top.offsetZ));
            GL11.glEnd();
        }
        if (prevOrientation == orientation) {
            qt = Quaternion.fromOrientation(orientation);
        } else {
            this.q0.update(Quaternion.fromOrientation(prevOrientation));
            this.q1.update(Quaternion.fromOrientation(orientation));
            if (this.q0.dotProduct(this.q1) < 0.0) {
                this.q0.incrScale(-1.0);
            }
            this.q0.incrLerp(this.q1, reorientInterpolation);
            qt = this.q0;
        }
        qt.glRotate();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (debug_servo_orientation) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
            GL11.glBegin((int)3);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)1.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
        }
    }

    protected ResourceLocation func_110775_a(Entity ent) {
        return Core.blockAtlas;
    }

    void renderMainModel(StepperEngine motor, float partial, double ro, boolean hilighting) {
        double stretch_interp;
        GL11.glPushMatrix();
        this.func_110776_a(Core.blockAtlas);
        this.chasis.render(BlockIcons.servo$model$stepper);
        FzColor c = motor.motionHandler.color;
        this.renderServoColor(c);
        GL11.glColor3f((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue());
        double radius = 0.5;
        double constant = Math.PI * 2 * radius;
        double partial_rotation = NumUtil.interp((float)motor.motionHandler.prev_sprocket_rotation, (float)motor.motionHandler.sprocket_rotation, partial);
        double angle = constant * partial_rotation;
        float rd = (float)radius;
        if (motor.motionHandler.orientation != motor.motionHandler.prevOrientation && motor.motionHandler.prevOrientation != FzOrientation.UNKNOWN && (stretch_interp = ro * 2.0) < 1.0) {
            if (stretch_interp > 0.5) {
                stretch_interp = 1.0 - stretch_interp;
            }
            rd = (float)((double)rd + stretch_interp / 8.0);
        }
        float o = 0.5f;
        float height_d = 0.125f;
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)o, (float)height_d, (float)rd);
        GL11.glRotatef((float)((float)Math.toDegrees(angle)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.sprocket.render(BlockIcons.servo$model$sprocket);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)o, (float)height_d, (float)(-rd));
        GL11.glRotatef((float)((float)Math.toDegrees(-angle) + 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.sprocket.render(BlockIcons.servo$model$sprocket);
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    void renderServoColor(FzColor color) {
        if (color == FzColor.NO_COLOR) {
            return;
        }
        IIcon colorIcon = BlockRenderServoRail.coloredRails[color.toVanillaColorIndex()];
        BlockRenderHelper block = BlockRenderHelper.instance;
        block.setBlockBoundsOffset(0.0f, 0.0f, 0.0f);
        block.useTexture(null);
        block.setTexture(1, colorIcon);
        block.beginWithMirroredUVs();
        GL11.glPushMatrix();
        float d = -0.5f;
        GL11.glTranslatef((float)d, (float)(d - 0.375f + 1.0E-4f), (float)d);
        float b = 0.875f;
        GL11.glScalef((float)(1.0f / b), (float)1.0f, (float)(1.0f / b));
        float s = 0.625f;
        GL11.glScalef((float)s, (float)1.0f, (float)s);
        float t = 0.2f;
        GL11.glTranslatef((float)t, (float)0.0f, (float)t);
        Tessellator.field_78398_a.func_78382_b();
        block.renderForTileEntity();
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
    }
}

