/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.stepper;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.fzds.DeltaChunk;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.servo.AbstractServoMachine;
import factorization.servo.MotionHandler;
import factorization.servo.TileEntityServoRail;
import factorization.servo.stepper.DropMode;
import factorization.servo.stepper.EntityGrabController;
import factorization.servo.stepper.GrabConnector;
import factorization.servo.stepper.ItemStepperEngine;
import factorization.servo.stepper.StepperMotionHandler;
import factorization.shared.Core;
import factorization.shared.EntityReference;
import factorization.shared.NetworkFactorization;
import factorization.util.SpaceUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class StepperEngine
extends AbstractServoMachine {
    final EntityReference<EntityGrabController> grabber = new EntityReference();
    int number_of_grabbed_blocks = 0;
    static int MAX_SIZE = 2048;

    public StepperEngine(World w) {
        super(w);
        this.func_70105_a(1.0f, 1.0f);
        this.grabber.setWorld(w);
    }

    protected void func_70088_a() {
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        super.putData(data);
        data.as(Share.VISIBLE, "grabber").putIDS(this.grabber);
        this.number_of_grabbed_blocks = data.as(Share.VISIBLE, "numberOfGrabbedBlocks").putInt(this.number_of_grabbed_blocks);
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        return super.handleMessageFromClient(messageType, input);
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        return super.handleMessageFromServer(messageType, input);
    }

    @Override
    protected void markDirty() {
    }

    @Override
    public boolean extractAccelerationEnergy() {
        return this.extractCharge(this.number_of_grabbed_blocks + 2);
    }

    @Override
    public void updateServoLogic() {
    }

    @Override
    protected MotionHandler newMotionHandler() {
        return new StepperMotionHandler(this);
    }

    @Override
    protected void dropItemsOnBreak() {
        new Coord(this).spawnItem(Core.registry.stepper_placer);
    }

    @Override
    public void onEnterNewBlock() {
        TileEntityServoRail rail = this.getCurrentPos().getTE(TileEntityServoRail.class);
        if (rail != null && rail.decoration != null) {
            rail.decoration.stepperHit(this);
        }
    }

    public boolean grabbed() {
        return this.grabber.trackingEntity();
    }

    public void fzdsGrab() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabbed()) {
            return;
        }
        Coord front = this.getCurrentPos().add(this.getOrientation().top);
        if (this.grabExistingIdc(front)) {
            return;
        }
        this.grabNewIdc(front);
        this.broadcastFullUpdate();
    }

    private void grabNewIdc(Coord front) {
        if (front.isReplacable() || front.isAir()) {
            return;
        }
        GrabConnector gc = new GrabConnector(front, MAX_SIZE);
        final Collection<Coord> mesh = gc.fill();
        Coord min = null;
        Coord max = null;
        for (Coord c : mesh) {
            if (min == null) {
                min = c.copy();
                max = c.copy();
                continue;
            }
            c = c.copy();
            Coord.sort(min, c);
            Coord.sort(c, max);
        }
        if (min == null) {
            return;
        }
        IDeltaChunk idc = DeltaChunk.makeSlice(ItemStepperEngine.channel, min, max, new DeltaChunk.AreaMap(){

            @Override
            public void fillDse(DeltaChunk.DseDestination destination) {
                for (Coord c : mesh) {
                    destination.include(c);
                }
            }
        }, true);
        idc.permit(DeltaCapability.COLLIDE, DeltaCapability.MOVE, DeltaCapability.ROTATE, DeltaCapability.DRAG, DeltaCapability.DIE_WHEN_EMPTY, DeltaCapability.INTERACT, DeltaCapability.BLOCK_PLACE, DeltaCapability.BLOCK_MINE, DeltaCapability.REMOVE_ITEM_ENTITIES);
        idc.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)idc);
        this.grabIdc(idc);
    }

    private boolean grabExistingIdc(Coord front) {
        double extreme_max = 1.6777216E7;
        for (IDeltaChunk idc : DeltaChunk.getAllSlices(this.field_70170_p)) {
            EntityGrabController egc;
            if (!idc.can(DeltaCapability.COLLIDE_WITH_WORLD) || !(idc.getController() instanceof EntityGrabController) || !(egc = (EntityGrabController)idc.getController()).isUngrabbed() || this.func_70068_e(idc) > extreme_max) continue;
            Coord grabPoint = idc.real2shadowCoord(front);
            if (!SpaceUtil.contains(SpaceUtil.createAABB(idc.getCorner(), idc.getFarCorner()), grabPoint)) continue;
            this.grabIdc(idc);
            return true;
        }
        return false;
    }

    private void grabIdc(IDeltaChunk idc) {
        EntityGrabController egc = new EntityGrabController(this, idc, DropMode.EVENTUALLY);
        this.field_70170_p.func_72838_d((Entity)egc);
        egc.func_70078_a(this);
        this.grabber.trackEntity(egc);
        idc.setController(egc);
    }

    public void fzdsRelease() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.grabbed()) {
            return;
        }
        EntityGrabController egc = this.grabber.getEntity();
        if (egc == null) {
            Core.logWarning("Stepper Engine can't drop! DSE grabber entity is not loaded! Sorry! " + this + " " + this.grabber.getUUID(), new Object[0]);
            return;
        }
        egc.release();
        egc.func_70078_a(null);
        this.grabber.trackEntity(null);
        this.broadcastFullUpdate();
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }
}

