/*
 * Decompiled with CFR 0.152.
 */
package factorization.servo.stepper;

import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.servo.MotionHandler;
import factorization.servo.stepper.EntityGrabController;
import factorization.servo.stepper.StepperEngine;
import java.io.IOException;
import net.minecraftforge.common.util.ForgeDirection;

public class StepperMotionHandler
extends MotionHandler {
    final StepperEngine engine;
    int stepperReorient = 0;
    int reorientDistance = 0;
    EnumObstructionKind obstruction = EnumObstructionKind.NONE;
    static int TICKS_PER_HALF_TURN = 40;

    public StepperMotionHandler(StepperEngine stepperEngine) {
        super(stepperEngine);
        this.engine = stepperEngine;
    }

    IDeltaChunk get() {
        EntityGrabController grabber = this.engine.grabber.getEntity();
        if (grabber == null) {
            return null;
        }
        return grabber.idcRef.getEntity();
    }

    void turnThrough(Quaternion start, Quaternion end) {
        double angle = start.getAngleBetween(end);
        double ticksNeeded = angle / Math.PI * (double)TICKS_PER_HALF_TURN;
        int t = (int)ticksNeeded;
        if (t < 10) {
            t = 10;
        }
        this.reorientDistance = this.stepperReorient = t;
    }

    @Override
    public void changeOrientation(ForgeDirection dir) {
        FzOrientation orig = this.orientation;
        super.changeOrientation(dir);
        if (this.orientation == orig) {
            return;
        }
        if (orig != FzOrientation.UNKNOWN) {
            this.setStopped(true);
        }
        if (!this.engine.grabbed()) {
            this.turnThrough(Quaternion.fromOrientation(orig), Quaternion.fromOrientation(this.orientation));
            return;
        }
        IDeltaChunk idc = this.get();
        if (idc == null) {
            return;
        }
        this.faceTarget(idc);
    }

    private void faceTarget(IDeltaChunk idc) {
        Quaternion startRot = idc.getRotation();
        Quaternion endRot = Quaternion.fromOrientation(this.orientation);
        this.turnThrough(startRot, endRot);
        idc.orderTargetRotation(endRot, this.reorientDistance, Interpolation.SMOOTH);
    }

    @Override
    protected void putData(DataHelper data) throws IOException {
        super.putData(data);
        this.stepperReorient = data.as(Share.VISIBLE, "stepperReorient").putInt(this.stepperReorient);
        this.obstruction = data.as(Share.VISIBLE, "obstruction").putEnum(this.obstruction);
        this.stepperReorient = data.as(Share.VISIBLE, "stepperReorient").putInt(this.stepperReorient);
        this.reorientDistance = data.as(Share.VISIBLE, "stepperReorientDistance").putInt(this.reorientDistance);
    }

    boolean waitForObstructionClear(EntityGrabController grabber, IDeltaChunk idc) {
        if (this.obstruction == EnumObstructionKind.NONE) {
            return false;
        }
        if (this.engine.field_70170_p.func_82737_E() % 40L != 0L) {
            return true;
        }
        idc.findAnyCollidingBox();
        if (grabber.hitReal == null) {
            if (this.obstruction == EnumObstructionKind.LINEAR) {
                this.matchVelocity(idc);
            } else if (this.obstruction == EnumObstructionKind.ROTATIONAL) {
                this.faceTarget(idc);
            }
            this.obstruction = EnumObstructionKind.NONE;
            return false;
        }
        grabber.hitShadow = null;
        grabber.hitReal = null;
        return true;
    }

    private void matchVelocity(IDeltaChunk idc) {
        idc.setVelocity(this.getVelocity());
    }

    @Override
    protected void updateServoMotion() {
        if (!this.engine.grabbed() || this.engine.field_70170_p.field_72995_K) {
            super.updateServoMotion();
            if (this.stepperReorient > 0) {
                --this.stepperReorient;
                this.setStopped(false);
            }
            return;
        }
        EntityGrabController grabber = this.engine.grabber.getEntity();
        if (grabber == null) {
            return;
        }
        IDeltaChunk idc = grabber.idcRef.getEntity();
        if (idc == null) {
            return;
        }
        if (!idc.field_70170_p.field_72995_K && this.waitForObstructionClear(grabber, idc)) {
            return;
        }
        if (this.stepperReorient > 0) {
            --this.stepperReorient;
            this.setStopped(false);
        }
        this.removeIdcPositionError();
        super.updateServoMotion();
    }

    void removeIdcPositionError() {
    }

    static enum EnumObstructionKind {
        NONE,
        LINEAR,
        ROTATIONAL;

    }
}

