/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.algos.ReservoirSampler;
import factorization.api.Coord;
import factorization.api.FzColor;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.Registry;
import factorization.notify.Notice;
import factorization.shared.BlockClass;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationTextureLoader;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.shared.TileEntityFzNull;
import factorization.weird.TileEntityDayBarrel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFactorization
extends BlockContainer {
    public boolean fake_normal_render = false;
    public static IIcon force_texture = null;
    private IIcon tempParticleIIcon = null;
    LinkedList<TileEntityCommon> destroyed_tes = new LinkedList();
    ArrayList<ItemStack> todaysBarrels = null;
    public static final float lamp_pad = 0.0625f;
    public static int CURRENT_PASS = 0;

    public BlockFactorization(Material material) {
        super(material);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.field_149785_s = true;
        this.func_149675_a(false);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        TileEntityFzNull nuller = new TileEntityFzNull();
        nuller.func_145834_a(world);
        return nuller;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityCommon tec = new Coord(world, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return null;
        }
        return tec.getPickedBlock();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t == null || !(t instanceof TileEntityCommon)) {
            return false;
        }
        TileEntityCommon te = (TileEntityCommon)t;
        return te.isBlockSolidOnSide(side);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.func_149747_d(world, x, y, z, side.ordinal());
    }

    public void func_149695_a(World w, int x, int y, int z, Block neighbor) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)te;
            tec.neighborChanged(neighbor);
        }
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer player, int side, float vecx, float vecy, float vecz) {
        ItemStack cur;
        Coord here = new Coord(w, x, y, z);
        TileEntityCommon t = here.getTE(TileEntityCommon.class);
        if (t == null && w.field_72995_K) {
            Core.network.broadcastMessage(null, here, NetworkFactorization.MessageType.DescriptionRequest, new Object[0]);
        }
        if (player.func_70093_af() && ((cur = player.func_71045_bC()) == null || cur.func_77973_b() != Core.registry.logicMatrixProgrammer)) {
            return false;
        }
        if (t != null) {
            return t.activate(player, ForgeDirection.getOrientation((int)side));
        }
        if (w.field_72995_K) {
            if (here.getTE() == null) {
                Core.network.broadcastMessage(null, here, NetworkFactorization.MessageType.DescriptionRequest, new Object[0]);
                return false;
            }
            return false;
        }
        player.func_145747_a((IChatComponent)new ChatComponentText("This block is missing its TileEntity, possibly due to a bug in Factorization."));
        player.func_145747_a((IChatComponent)new ChatComponentText("The block and its contents can not be recovered without cheating."));
        return true;
    }

    public void func_149699_a(World w, int x, int y, int z, EntityPlayer player) {
        if (w.field_72995_K) {
            return;
        }
        TileEntity t = w.func_147438_o(x, y, z);
        if (t instanceof TileEntityCommon) {
            ((TileEntityCommon)t).click(player);
        }
    }

    public void func_149651_a(IIconRegister reg) {
        FactorizationTextureLoader.register(reg, BlockIcons.class, null, "factorization:");
        Core.proxy.texturepackChanged(reg);
    }

    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int side) {
        if (force_texture != null) {
            return force_texture;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)te;
            return tec.getIcon(ForgeDirection.getOrientation((int)side));
        }
        return BlockIcons.error;
    }

    public IIcon func_149691_a(int side, int md) {
        if (this.tempParticleIIcon != null) {
            IIcon ret = this.tempParticleIIcon;
            this.tempParticleIIcon = null;
            return ret;
        }
        FactoryType ft = FactoryType.fromMd((byte)md);
        if (ft == null) {
            return BlockIcons.default_icon;
        }
        TileEntityCommon rep = ft.getRepresentative();
        if (rep == null) {
            return BlockIcons.error;
        }
        return rep.getIcon(ForgeDirection.getOrientation((int)side));
    }

    public int func_149692_a(int i) {
        return i;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public void func_149749_a(World w, int x, int y, int z, Block id, int md) {
        Coord here = new Coord(w, x, y, z);
        TileEntityCommon te = here.getTE(TileEntityCommon.class);
        if (te != null) {
            te.onRemove();
            this.destroyed_tes.add(te);
        }
        super.func_149749_a(w, x, y, z, id, md);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return this.removedByPlayer(world, player, x, y, z, true);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        Coord here = new Coord(world, x, y, z);
        TileEntityCommon tec = here.getTE(TileEntityCommon.class);
        if (tec == null) {
            if (!world.field_72995_K) {
                new Notice(here, "There was no TileEntity!", new String[0]).send(player);
            }
            return world.func_147468_f(x, y, z);
        }
        boolean ret = tec.removedByPlayer(player, willHarvest);
        if (!world.field_72995_K && !ret) {
            FMLProxyPacket description = tec.getDescriptionPacket();
            Core.network.broadcastPacket(player, here, description);
            here.sendRedraw();
        }
        return ret;
    }

    public ArrayList<ItemStack> getDrops(World world, int X, int Y, int Z, int md, int fortune) {
        ItemStack is;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Coord here = new Coord(world, X, Y, Z);
        TileEntityCommon f = here.getTE(TileEntityCommon.class);
        if (f == null) {
            Iterator it = this.destroyed_tes.iterator();
            TileEntityCommon destroyedTE = null;
            while (it.hasNext()) {
                TileEntityCommon tec = (TileEntityCommon)it.next();
                if (!tec.getCoord().equals(here)) continue;
                destroyedTE = tec;
                it.remove();
            }
            if (destroyedTE == null) {
                Core.logWarning("No IFactoryType TE behind block that was destroyed, and nothing saved!", new Object[0]);
                return ret;
            }
            Coord destr = destroyedTE.getCoord();
            if (!destr.equals(here)) {
                Core.logWarning("Last saved destroyed TE wasn't for this location", new Object[0]);
                destroyedTE = null;
                return ret;
            }
            f = destroyedTE;
            destroyedTE = null;
        }
        if ((is = f.getDroppedBlock()) != null) {
            ret.add(is);
        }
        return ret;
    }

    private static void put(List itemList, ItemStack item) {
        if (item == null) {
            return;
        }
        itemList.add(item);
    }

    public void func_149666_a(Item me, CreativeTabs tab, List itemList) {
        if (this != Core.registry.factory_block) {
            return;
        }
        Registry reg = Core.registry;
        BlockFactorization.put(itemList, reg.stamper_item);
        BlockFactorization.put(itemList, reg.packager_item);
        BlockFactorization.put(itemList, reg.slagfurnace_item);
        BlockFactorization.put(itemList, reg.parasieve_item);
        if (reg.battery != null) {
            BlockFactorization.put(itemList, new ItemStack((Item)reg.battery, 1, 2));
        }
        BlockFactorization.put(itemList, reg.leydenjar_item);
        BlockFactorization.put(itemList, reg.leydenjar_item_full);
        BlockFactorization.put(itemList, FactoryType.CREATIVE_CHARGE.itemStack());
        BlockFactorization.put(itemList, reg.caliometric_burner_item);
        BlockFactorization.put(itemList, reg.sap_generator_item);
        BlockFactorization.put(itemList, reg.anthro_generator_item);
        BlockFactorization.put(itemList, reg.solarboiler_item);
        BlockFactorization.put(itemList, reg.steamturbine_item);
        BlockFactorization.put(itemList, reg.wooden_shaft);
        BlockFactorization.put(itemList, reg.bibliogen);
        if (reg.mirror != null) {
            BlockFactorization.put(itemList, new ItemStack((Item)reg.mirror));
        }
        BlockFactorization.put(itemList, reg.shaft_generator_item);
        BlockFactorization.put(itemList, reg.wind_mill);
        BlockFactorization.put(itemList, reg.water_wheel);
        BlockFactorization.put(itemList, reg.steam_to_shaft);
        BlockFactorization.put(itemList, reg.heater_item);
        BlockFactorization.put(itemList, reg.leadwire_item);
        BlockFactorization.put(itemList, reg.mixer_item);
        BlockFactorization.put(itemList, reg.crystallizer_item);
        BlockFactorization.put(itemList, reg.greenware_item);
        if (reg.rocket_engine != null) {
            BlockFactorization.put(itemList, new ItemStack((Item)reg.rocket_engine));
        }
        BlockFactorization.put(itemList, reg.empty_socket_item);
        BlockFactorization.put(itemList, reg.servorail_item);
        BlockFactorization.put(itemList, reg.lamp_item);
        BlockFactorization.put(itemList, reg.compression_crafter_item);
        BlockFactorization.put(itemList, reg.hinge);
        if (this.todaysBarrels != null) {
            itemList.addAll(this.todaysBarrels);
        } else if (reg.daybarrel != null) {
            Calendar cal = Calendar.getInstance();
            int doy = cal.get(6) - 1;
            ReservoirSampler<ItemStack> barrelPool = new ReservoirSampler<ItemStack>(1, new Random(doy));
            this.todaysBarrels = new ArrayList();
            for (ItemStack barrel : TileEntityDayBarrel.barrel_items) {
                TileEntityDayBarrel.Type type = TileEntityDayBarrel.getUpgrade(barrel);
                if (type == TileEntityDayBarrel.Type.NORMAL) {
                    barrelPool.give(barrel);
                    continue;
                }
                if (type != TileEntityDayBarrel.Type.CREATIVE) continue;
                this.todaysBarrels.add(barrel);
            }
            TileEntityDayBarrel rep = new TileEntityDayBarrel();
            for (ItemStack barrel : barrelPool.getSamples()) {
                rep.loadFromStack(barrel);
                for (TileEntityDayBarrel.Type type : TileEntityDayBarrel.Type.values()) {
                    if (type == TileEntityDayBarrel.Type.CREATIVE || type == TileEntityDayBarrel.Type.LARGER) continue;
                    rep.type = type;
                    this.todaysBarrels.add(rep.getPickedBlock());
                }
            }
        }
        BlockFactorization.put(itemList, reg.legendarium);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int dir) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)te;
            return tec.getFactoryType().connectRedstone();
        }
        return false;
    }

    public boolean isNormalCube(IBlockAccess world, int i, int j, int k) {
        return BlockClass.get(world.func_72805_g(i, j, k)).isNormal();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TileEntity te;
        int md = world.func_72805_g(x, y, z);
        if (BlockClass.Barrel.md == md && (te = world.func_147438_o(x, y, z)) instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)te).getFlamability();
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.getFlammability(world, x, y, z, face) > 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te;
        int md = world.func_72805_g(x, y, z);
        BlockClass c = BlockClass.get(md);
        if ((c == BlockClass.MachineDynamicLightable || c == BlockClass.MachineLightable) && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCommon) {
            return ((TileEntityCommon)te).getDynamicLight();
        }
        return c.lightValue;
    }

    public float func_149712_f(World w, int x, int y, int z) {
        BlockClass bc = BlockClass.get(w.func_72805_g(x, y, z));
        return bc.hardness;
    }

    public MovingObjectPosition func_149731_a(World w, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCommon)) {
            return super.func_149731_a(w, x, y, z, startVec, endVec);
        }
        TileEntityCommon tec = (TileEntityCommon)te;
        return tec.collisionRayTrace(startVec, endVec);
    }

    public AxisAlignedBB func_149668_a(World w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCommon)) {
            return super.func_149668_a(w, x, y, z);
        }
        TileEntityCommon tec = (TileEntityCommon)te;
        return tec.getCollisionBoundingBoxFromPool();
    }

    public void func_149743_a(World w, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        BlockRenderHelper test;
        TileEntity te = w.func_147438_o(x, y, z);
        TileEntityCommon tec = null;
        if (te instanceof TileEntityCommon) {
            tec = (TileEntityCommon)te;
        }
        BlockRenderHelper blockRenderHelper = test = w.field_72995_K ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        if (tec == null || !tec.addCollisionBoxesToList(test, aabb, list, entity)) {
            super.func_149743_a(w, x, y, z, aabb, list, entity);
        }
    }

    public AxisAlignedBB func_149633_g(World w, int x, int y, int z) {
        AxisAlignedBB ret;
        TileEntityCommon tec;
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon && (tec = (TileEntityCommon)te).getFactoryType() == FactoryType.EXTENDED && (ret = tec.getCollisionBoundingBoxFromPool()) != null) {
            return ret;
        }
        return super.func_149633_g(w, x, y, z);
    }

    public void func_149719_a(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCommon)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        ((TileEntityCommon)te).setBlockBounds((Block)this);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        if (this.fake_normal_render) {
            return 0;
        }
        return Core.factory_rendertype;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149674_a(World w, int x, int y, int z, Random rand) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)te;
            tec.blockUpdateTick((Block)this);
        }
    }

    public int func_149748_c(IBlockAccess w, int x, int y, int z, int side) {
        return 0;
    }

    public int func_149709_b(IBlockAccess w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            return ((TileEntityCommon)te).power() ? 15 : 0;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random rand) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)te;
            tec.spawnDisplayTickParticles(rand);
        }
    }

    public boolean canRenderInPass(int pass) {
        CURRENT_PASS = pass;
        return pass == 0 || pass == 1;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149646_a(IBlockAccess iworld, int x, int y, int z, int side) {
        int md = iworld.func_72805_g(x, y, z);
        return !BlockClass.get(md).isNormal() || super.func_149646_a(iworld, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        Coord here = new Coord(worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        TileEntityCommon tec = here.getTE(TileEntityCommon.class);
        this.tempParticleIIcon = tec == null ? BlockIcons.default_icon : tec.getIcon(ForgeDirection.getOrientation((int)target.field_72310_e));
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCommon)) {
            return false;
        }
        TileEntityCommon tec = (TileEntityCommon)te;
        IIcon theIIcon = tec.getIcon(ForgeDirection.DOWN);
        int range = 4;
        for (int dx = 0; dx < range; ++dx) {
            for (int dy = 0; dy < range; ++dy) {
                for (int dz = 0; dz < range; ++dz) {
                    double px = (double)x + ((double)dx + 0.5) / (double)range;
                    double py = (double)y + ((double)dy + 0.5) / (double)range;
                    double pz = (double)z + ((double)dz + 0.5) / (double)range;
                    EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, (Block)this, meta);
                    fx.func_70596_a(x, y, z);
                    fx.func_110125_a(theIIcon);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        Coord at = new Coord(worldObj, x, y, z);
        TileEntityCommon tec = at.getTE(TileEntityCommon.class);
        if (tec == null) {
            return false;
        }
        boolean suc = tec.rotate(axis);
        if (suc) {
            at.markBlockForUpdate();
        }
        return suc;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        TileEntityCommon tec = new Coord(worldObj, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return TileEntityCommon.empty_rotation_array;
        }
        return tec.getValidRotations();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntityCommon tec = new Coord(world, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return 0;
        }
        return tec.getComparatorValue(ForgeDirection.getOrientation((int)side));
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        int md = world.func_72805_g(x, y, z);
        return md == BlockClass.Wire.md;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tilex, int tiley, int tilez) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            ((TileEntityCommon)te).onNeighborTileChanged(tilex, tiley, tilez);
        }
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCommon) {
            return ((TileEntityCommon)te).recolourBlock(side, FzColor.fromVanillaColorIndex(colour));
        }
        return false;
    }

    public float func_149737_a(EntityPlayer player, World w, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75099_e && this == Core.registry.factory_block_barrel) {
            return 0.0f;
        }
        return super.func_149737_a(player, w, x, y, z);
    }
}

