/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.api.VectorUV;
import factorization.common.BlockIcons;
import factorization.shared.Core;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRenderHelper
extends Block {
    public static BlockRenderHelper instance;
    public IIcon[] textures;
    private IIcon[] repetitionCache = new IIcon[6];
    private static final byte UV_NONE = 0;
    private static final byte UV_OLD_STYLE_ROTATED = 1;
    private static final byte UV_NEW_STYLE_MIRRORED = 2;
    private static final byte UV_FULLY_ROTATED_STYLE = 3;
    private VectorUV center = new VectorUV();
    private int[] colors = new int[6];
    public float alpha;
    static Vec3 midCache;
    VectorUV[] currentFace;
    public VectorUV[][] faceCache;
    private static final float[] directionLighting;
    VectorUV normal_uv;

    public BlockRenderHelper() {
        super(Material.field_151577_b);
        this.resetColors();
        this.alpha = 1.0f;
        this.faceCache = new VectorUV[6][4];
        for (int i = 0; i < this.faceCache.length; ++i) {
            this.currentFace = this.faceCache[i];
            for (int j = 0; j < this.currentFace.length; ++j) {
                this.currentFace[j] = new VectorUV();
            }
        }
        this.normal_uv = new VectorUV();
        if (instance == null) {
            instance = this;
        }
    }

    public BlockRenderHelper setBlockBoundsOffset(float x, float y, float z) {
        this.func_149676_a(x, y, z, 1.0f - x, 1.0f - y, 1.0f - z);
        return this;
    }

    public BlockRenderHelper setBlockBoundsBasedOnRotation() {
        double maxZ;
        double maxY;
        double maxX;
        this.currentFace = this.faceCache[0];
        double minX = maxX = this.currentFace[0].x;
        double minY = maxY = this.currentFace[0].y;
        double minZ = maxZ = this.currentFace[0].z;
        for (int face = 0; face < this.faceCache.length; ++face) {
            this.currentFace = this.faceCache[face];
            for (int i = 1; i < this.currentFace.length; ++i) {
                VectorUV vec = this.currentFace[i];
                minX = Math.min(minX, vec.x);
                minY = Math.min(minY, vec.y);
                minZ = Math.min(minZ, vec.z);
                maxX = Math.max(maxX, vec.x);
                maxY = Math.max(maxY, vec.y);
                maxZ = Math.max(maxZ, vec.z);
            }
        }
        this.func_149676_a((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper useTexture(IIcon texture) {
        this.textures = this.repetitionCache;
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = texture;
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper useTextures(IIcon ... textures) {
        this.textures = textures;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper setTexture(int i, IIcon texture) {
        this.textures = this.repetitionCache;
        this.textures[i] = texture;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess w, int x, int y, int z, int side) {
        return this.textures[side] != null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int md) {
        IIcon ret;
        try {
            ret = this.textures[side];
        }
        catch (NullPointerException e) {
            this.textures = new IIcon[6];
            this.textures[side] = BlockIcons.error;
            return this.textures[side];
        }
        if (ret == null) {
            return BlockIcons.error;
        }
        return this.textures[side];
    }

    public VectorUV[][] getFaceVertices() {
        return this.faceCache;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderForTileEntity() {
        this.renderRotated(Tessellator.field_78398_a, 0, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderForInventory(RenderBlocks renderblocks) {
        renderblocks.func_147775_a((Block)this);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78372_c(-0.5f, -0.5f, -0.5f);
        tessellator.func_78382_b();
        IIcon texture = this.textures[0];
        if (texture != null) {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderblocks.func_147768_a((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[1]) != null) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderblocks.func_147806_b((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[2]) != null) {
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderblocks.func_147761_c((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[3]) != null) {
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderblocks.func_147734_d((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[4]) != null) {
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderblocks.func_147798_e((Block)this, 0.0, 0.0, 0.0, texture);
        }
        if ((texture = this.textures[5]) != null) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderblocks.func_147764_f((Block)this, 0.0, 0.0, 0.0, texture);
        }
        tessellator.func_78381_a();
        tessellator.func_78372_c(0.5f, 0.5f, 0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean render(RenderBlocks rb, int x, int y, int z) {
        rb.func_147782_a(this.field_149759_B, this.field_149760_C, this.field_149754_D, this.field_149755_E, this.field_149756_F, this.field_149757_G);
        return rb.func_147784_q((Block)this, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean render(RenderBlocks rb, Coord c) {
        rb.func_147782_a(this.field_149759_B, this.field_149760_C, this.field_149754_D, this.field_149755_E, this.field_149756_F, this.field_149757_G);
        return rb.func_147784_q((Block)this, c.x, c.y, c.z);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper beginWithRotatedUVs() {
        return this.begin((byte)1);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper beginWithMirroredUVs() {
        return this.begin((byte)2);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderHelper beginWithHipsterUVs() {
        return this.begin((byte)3);
    }

    @SideOnly(value=Side.CLIENT)
    private BlockRenderHelper begin(byte uv_mode) {
        for (int i = 0; i < 6; ++i) {
            IIcon faceIIcon = this.textures[i];
            if (faceIIcon == null) continue;
            this.currentFace = this.faceCache[i];
            this.faceVerts(i, uv_mode);
            for (VectorUV vert : this.currentFace) {
                vert.u = faceIIcon.func_94214_a(vert.u * 16.0);
                vert.v = faceIIcon.func_94207_b(vert.v * 16.0);
            }
        }
        this.center.x = (this.field_149759_B + this.field_149755_E) / 2.0;
        this.center.y = (this.field_149760_C + this.field_149756_F) / 2.0;
        this.center.z = (this.field_149754_D + this.field_149757_G) / 2.0;
        return this;
    }

    public BlockRenderHelper beginNoIIcons() {
        for (int i = 0; i < 6; ++i) {
            this.currentFace = this.faceCache[i];
            this.faceVerts(i, (byte)0);
        }
        return this;
    }

    boolean hasTexture(int f) {
        return Core.proxy.BlockRenderHelper_has_texture(this, f);
    }

    public BlockRenderHelper rotate(Quaternion q) {
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (!this.hasTexture(f)) continue;
            VectorUV[] face = this.faceCache[f];
            for (int v = 0; v < face.length; ++v) {
                q.applyRotation(face[v]);
            }
        }
        q.applyRotation(this.center);
        return this;
    }

    public BlockRenderHelper rotateMiddle(Quaternion q) {
        Vec3 d = this.getBoundsMiddle();
        this.translate((float)(-d.field_72450_a), (float)(-d.field_72448_b), (float)(-d.field_72449_c));
        this.rotate(q);
        this.translate((float)d.field_72450_a, (float)d.field_72448_b, (float)d.field_72449_c);
        return this;
    }

    public BlockRenderHelper rotateCenter(Quaternion q) {
        float d = 0.5f;
        this.translate(-d, -d, -d);
        this.rotate(q);
        this.translate(d, d, d);
        return this;
    }

    public BlockRenderHelper translate(float dx, float dy, float dz) {
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (!this.hasTexture(f)) continue;
            VectorUV[] face = this.faceCache[f];
            for (int v = 0; v < face.length; ++v) {
                face[v].x += (double)dx;
                face[v].y += (double)dy;
                face[v].z += (double)dz;
            }
        }
        this.center.x += (double)dx;
        this.center.y += (double)dy;
        this.center.z += (double)dz;
        return this;
    }

    public void setColor(int index, int color) {
        this.colors[index] = color;
    }

    public void setColor(int color) {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = color;
        }
    }

    public void resetColors() {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = 0xFFFFFF;
        }
    }

    Quaternion getNormal(VectorUV a, VectorUV b, VectorUV c) {
        Quaternion A = new Quaternion();
        Quaternion B = new Quaternion();
        Quaternion C = new Quaternion();
        A.loadFrom(a);
        B.loadFrom(b);
        C.loadFrom(c);
        A.incrScale(-1.0);
        B.incrAdd(A);
        C.incrAdd(A);
        B.incrCross(C);
        B.incrNormalize();
        return B;
    }

    public void simpleCull(FzOrientation fzo, IBlockAccess w, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            ForgeDirection turned = fzo.applyRotation(dir);
            Block b = w.func_147439_a(x + turned.offsetX, y + turned.offsetY, z + turned.offsetZ);
            boolean cull = b.func_149662_c();
            if (!cull) continue;
            int ordinal = dir.ordinal();
            this.textures[ordinal] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderRotated(Tessellator tess, int x, int y, int z) {
        boolean any = false;
        for (int f = 0; f < this.faceCache.length; ++f) {
            VectorUV[] face;
            if (this.textures[f] == null || (face = this.faceCache[f]) == null) continue;
            any = true;
            float lighting = this.getNormalizedLighting(face, this.center);
            int color = this.colors[f];
            float color_r = (color & 0xFF0000) >> 16;
            float color_g = (color & 0xFF00) >> 8;
            float color_b = color & 0xFF;
            tess.func_78369_a((lighting /= 255.0f) * color_r, lighting * color_g, lighting * color_b, this.alpha);
            for (VectorUV vert : face) {
                tess.func_78374_a(vert.x + (double)x, vert.y + (double)y, vert.z + (double)z, vert.u, vert.v);
            }
        }
        return any;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRotatedUnshaded(Tessellator tess, int x, int y, int z) {
        for (int f = 0; f < this.faceCache.length; ++f) {
            if (this.textures[f] == null) continue;
            VectorUV[] face = this.faceCache[f];
            float lighting = 1.0f;
            int color = this.colors[f];
            float color_r = (color & 0xFF0000) >> 16;
            float color_g = (color & 0xFF00) >> 8;
            float color_b = color & 0xFF;
            tess.func_78386_a((lighting /= 255.0f) * color_r, lighting * color_g, lighting * color_b);
            for (int i = 0; i < face.length; ++i) {
                VectorUV vert = face[i];
                tess.func_78374_a(vert.x + (double)x, vert.y + (double)y, vert.z + (double)z, vert.u, vert.v);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRotated(Tessellator tess, Coord c) {
        if (c == null) {
            this.renderRotated(tess, 0, 0, 0);
            return;
        }
        this.renderRotated(tess, c.x, c.y, c.z);
    }

    public Vec3 getBoundsMiddle() {
        BlockRenderHelper.midCache.field_72450_a = (this.field_149759_B + this.field_149755_E) / 2.0;
        BlockRenderHelper.midCache.field_72448_b = (this.field_149760_C + this.field_149756_F) / 2.0;
        BlockRenderHelper.midCache.field_72449_c = (this.field_149754_D + this.field_149757_G) / 2.0;
        return midCache;
    }

    private void setVertexPositions(int face) {
        switch (face) {
            case 0: {
                this.set(0, 1, 0, 1);
                this.set(1, 0, 0, 1);
                this.set(2, 0, 0, 0);
                this.set(3, 1, 0, 0);
                break;
            }
            case 1: {
                this.set(0, 1, 1, 0);
                this.set(1, 0, 1, 0);
                this.set(2, 0, 1, 1);
                this.set(3, 1, 1, 1);
                break;
            }
            case 2: {
                this.set(0, 1, 1, 0);
                this.set(1, 1, 0, 0);
                this.set(2, 0, 0, 0);
                this.set(3, 0, 1, 0);
                break;
            }
            case 3: {
                this.set(0, 1, 1, 1);
                this.set(1, 0, 1, 1);
                this.set(2, 0, 0, 1);
                this.set(3, 1, 0, 1);
                break;
            }
            case 4: {
                this.set(0, 0, 0, 1);
                this.set(1, 0, 1, 1);
                this.set(2, 0, 1, 0);
                this.set(3, 0, 0, 0);
                break;
            }
            case 5: {
                this.set(0, 1, 1, 1);
                this.set(1, 1, 0, 1);
                this.set(2, 1, 0, 0);
                this.set(3, 1, 1, 0);
            }
        }
    }

    private void setOldStyleRotatedishUVs(int face) {
        switch (face) {
            case 0: 
            case 1: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.x;
                    vert.v = vert.z;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = 1.0 - vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = 1.0 - vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid face number");
            }
        }
    }

    private void setVanillaStyleMirroredUVs(int face) {
        switch (face) {
            case 0: 
            case 1: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.x;
                    vert.v = vert.z;
                }
                break;
            }
            case 2: 
            case 3: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 4: 
            case 5: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid face number");
            }
        }
    }

    private void setStyleFullyRotatedUVs(int face) {
        switch (face) {
            case 0: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.x;
                    vert.v = 1.0 - vert.z;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = 1.0 - vert.x;
                    vert.v = 1.0 - vert.z;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = 1.0 - vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.x;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.currentFace.length; ++i) {
                    VectorUV vert = this.currentFace[i];
                    vert.u = 1.0 - vert.z;
                    vert.v = 1.0 - vert.y;
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid face number");
            }
        }
    }

    private void convertUVsForIcon(int face) {
        VectorUV[] cache = this.currentFace;
        boolean WIDTH = true;
        for (int i = 0; i < cache.length; ++i) {
            VectorUV main = cache[i];
            double udelta = 0.0;
            double vdelta = 0.0;
            int nada = 0;
            if (main.u > (double)WIDTH) {
                udelta = main.u - (double)WIDTH;
            } else if (main.u < 0.0) {
                udelta = main.u;
            } else {
                ++nada;
            }
            if (main.v > (double)WIDTH) {
                vdelta = main.v - (double)WIDTH;
            } else if (main.v < 0.0) {
                vdelta = main.v;
            } else {
                ++nada;
            }
            if (nada == 2) continue;
            for (int J = 0; J < cache.length; ++J) {
                VectorUV other = cache[J];
                other.u -= udelta;
                other.v -= vdelta;
            }
        }
    }

    private void clipUVs() {
        for (int i = 0; i < this.currentFace.length; ++i) {
            VectorUV vec = this.currentFace[i];
            vec.u = BlockRenderHelper.clip(vec.u);
            vec.v = BlockRenderHelper.clip(vec.v);
        }
    }

    private void faceVerts(int face, byte uv_mode) {
        this.setVertexPositions(face);
        if (uv_mode == 0) {
            return;
        }
        if (uv_mode == 2) {
            this.setVanillaStyleMirroredUVs(face);
        } else if (uv_mode == 1) {
            this.setOldStyleRotatedishUVs(face);
        } else if (uv_mode == 3) {
            this.setStyleFullyRotatedUVs(face);
        }
        this.convertUVsForIcon(face);
        this.clipUVs();
    }

    static double clip(double v) {
        return Math.max(0.0, Math.min(1.0, v));
    }

    private void set(int i, int X, int Y, int Z) {
        this.currentFace[i].x = X == 0 ? this.field_149759_B : this.field_149755_E;
        this.currentFace[i].y = Y == 0 ? this.field_149760_C : this.field_149756_F;
        this.currentFace[i].z = Z == 0 ? this.field_149754_D : this.field_149757_G;
    }

    private static ForgeDirection getDirectionFromVector(VectorUV here) {
        double x = Math.abs(here.x);
        double y = Math.abs(here.y);
        double z = Math.abs(here.z);
        if (x >= y && x >= z) {
            return here.x >= 0.0 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (y >= x && y >= z) {
            return here.y >= 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (z >= x && z >= y) {
            return here.z >= 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return ForgeDirection.UP;
    }

    private float getNormalizedLighting(VectorUV[] vecs, VectorUV center) {
        Quaternion normal = this.getNormal(vecs[0], vecs[1], vecs[2]);
        this.normal_uv.x = normal.x;
        this.normal_uv.y = normal.y;
        this.normal_uv.z = normal.z;
        ForgeDirection dir = BlockRenderHelper.getDirectionFromVector(this.normal_uv);
        return directionLighting[dir.ordinal()];
    }

    public void setupBrightness(Tessellator tess, IBlockAccess w, int x, int y, int z) {
        if (w == null) {
            return;
        }
        Tessellator.field_78398_a.func_78380_c(this.func_149677_c(w, x, y, z));
    }

    public void setupBrightness(Tessellator tess, Coord c) {
        if (c.w == null) {
            return;
        }
        Tessellator.field_78398_a.func_78380_c(this.func_149677_c((IBlockAccess)c.w, c.x, c.y, c.z));
    }

    public int func_149720_d(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        return this.colors[0];
    }

    static {
        midCache = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        directionLighting = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    }
}

