/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.artifact.InspirationManager;
import factorization.beauty.EntityLeafBomb;
import factorization.charge.TileEntitySolarBoiler;
import factorization.citizen.EntityCitizen;
import factorization.colossi.BuildColossusCommand;
import factorization.colossi.ColossusController;
import factorization.colossi.ColossusFeature;
import factorization.common.FactorizationProxy;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.Registry;
import factorization.compat.CompatModuleLoader;
import factorization.coremod.AtVerifier;
import factorization.coremod.LoadingPlugin;
import factorization.darkiron.BlockDarkIronOre;
import factorization.fzds.HammerEnabled;
import factorization.mechanics.MechanismsFeature;
import factorization.oreprocessing.FactorizationOreProcessingHandler;
import factorization.servo.ServoMotor;
import factorization.servo.stepper.EntityGrabController;
import factorization.servo.stepper.StepperEngine;
import factorization.shared.FzNetEventHandler;
import factorization.shared.ItemFactorization;
import factorization.shared.NetworkFactorization;
import factorization.shared.PatreonRewards;
import factorization.shared.TileEntityCommon;
import factorization.shared.TileEntityFzNull;
import factorization.truth.minecraft.DistributeDocs;
import factorization.util.DataUtil;
import factorization.util.FzUtil;
import factorization.weird.EntityMinecartDayBarrel;
import factorization.weird.poster.EntityPoster;
import factorization.wrath.TileEntityWrathLamp;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="factorization", name="Factorization", version="0.8.109", acceptedMinecraftVersions="1.7.10", dependencies="required-after:factorization.dimensionalSlice", guiFactory="factorization.common.FzConfigGuiFactory")
public class Core {
    public static final String modId = "factorization";
    public static final String name = "Factorization";
    public static final String version = "0.8.109";
    public static Core instance;
    public static FzConfig fzconfig;
    public static Registry registry;
    public static FactorizationOreProcessingHandler foph;
    @SidedProxy(clientSide="factorization.common.FactorizationClientProxy", serverSide="factorization.common.FactorizationProxy")
    public static FactorizationProxy proxy;
    public static NetworkFactorization network;
    public static FzNetEventHandler netevent;
    public static CompatModuleLoader compatLoader;
    public static int factory_rendertype;
    public static int nonte_rendertype;
    public static boolean finished_loading;
    public static final boolean dev_environ;
    public static final boolean cheat;
    public static final boolean cheat_servo_energy;
    public static final boolean debug_network = false;
    public static final boolean show_fine_logging = false;
    public static final boolean enable_test_content;
    public static boolean serverStarted;
    private static boolean checked;
    private static Logger FZLogger;
    static final ThreadLocal<Boolean> isMainClientThread;
    static final ThreadLocal<Boolean> isMainServerThread;
    public static final String hintFormat;
    public static final String shiftFormat;
    public static CreativeTabs tabFactorization;
    public static final String texture_dir = "factorization:";
    public static final String model_dir = "/mods/factorization/models/";
    public static final String real_texture_dir = "/mods/factorization/textures/";
    public static final String gui_dir = "/mods/factorization/textures/gui/";
    public static final String gui_nei = "factorization:textures/gui/";
    public static final ResourceLocation blockAtlas;
    public static final ResourceLocation itemAtlas;

    public Core() {
        instance = this;
        fzconfig = new FzConfig();
        registry = new Registry();
        foph = new FactorizationOreProcessingHandler();
        network = new NetworkFactorization();
        netevent = new FzNetEventHandler();
        compatLoader = new CompatModuleLoader();
    }

    private static boolean dev_only(boolean a) {
        if (!dev_environ) {
            return false;
        }
        return a;
    }

    public static void checkJar() {
        if (checked) {
            return;
        }
        checked = true;
        if (dev_environ) {
            Core.logSevere("Dev environ; skipping jar check.", new Object[0]);
            return;
        }
        if (Boolean.parseBoolean(System.getProperty("fz.dontCheckJar"))) {
            Core.logSevere("checkJar disabled by system property", new Object[0]);
            return;
        }
        ModContainer mod = FMLCommonHandler.instance().findContainerFor((Object)modId);
        if (mod == null) {
            Core.logSevere("I don't have a mod container? Wat?", new Object[0]);
            return;
        }
        File src = mod.getSource();
        if (src == null) {
            Core.logSevere("mod has null source!", new Object[0]);
            return;
        }
        if (src.isDirectory()) {
            throw new RuntimeException("Factorization jar has been unpacked into a directory. Don't do that. Just put Factorization.jar in the mods/ folder");
        }
        String path = src.getPath();
        if (!Core.isBadName(path)) {
            Core.logSevere("Mod jar seems to have a valid filename", new Object[0]);
            return;
        }
        String correctName = path.replaceAll("\\.zip$", ".jar");
        if (Core.isBadName(correctName)) {
            Core.logSevere("Failed to fix filename? " + path + " didn't work when changed to " + correctName, new Object[0]);
            return;
        }
        Core.logSevere("The factorization jar is improperly named! Renaming " + path + "  to " + correctName, new Object[0]);
        boolean success = src.renameTo(new File(correctName));
        if (success) {
            throw new RuntimeException("The Factorization jar had an improper file extension. It has been renamed. Please restart Minecraft.");
        }
        throw new RuntimeException("The Factorization jar has an improper file extension; it should be a .jar, not a .zip, and not a .jar.zip.");
    }

    private static boolean isBadName(String path) {
        if (path == null) {
            return false;
        }
        return path.endsWith(".zip");
    }

    void checkForge() {
    }

    private static void validateEnvironment() {
        if (!LoadingPlugin.pluginInvoked) {
            String fml = "-Dfml.coreMods.load=factorization.coremod.LoadingPlugin";
            String ignore = "-Dfz.ignoreMissingCoremod=true";
            if ("".equals(System.getProperty("fz.ignoreMissingCoremod", ""))) {
                String dev = dev_environ ? "You're in a dev environ, so this is to be expected.\n" : "";
                throw new IllegalStateException("Coremod didn't load! Is your installation broken?\nWeird. It really is supposed to load, y'know...\nAnyways, try adding this flag to the JVM command line: " + fml + "\n" + dev + "(If the '-Dfml.coreMods.load' property is already being passed with another coremod, instead add the FZ coremod class with a comma.)\nIf you want to force loading to continue anyways, without the coremod, pass the following flag, but many things (including blowing up diamond blocks) will be broken: " + ignore);
            }
            System.err.println("Coremod did not load! But continuing anyways; as per VM flag " + ignore);
        }
        if (!dev_environ && "".equals(System.getProperty("fz.dontVerifyAt", ""))) {
            AtVerifier.verify();
        }
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        this.initializeLogging(event.getModLog());
        Core.checkJar();
        this.checkForge();
        Core.loadBus(registry);
        fzconfig.loadConfig(event.getSuggestedConfigurationFile());
        registry.makeBlocks();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.registerSimpleTileEntities();
        registry.makeItems();
        FzConfig.config.save();
        registry.makeRecipes();
        registry.setToolEffectiveness();
        proxy.registerRenderers();
        if (FzConfig.players_discover_colossus_guides) {
            DistributeDocs dd = new DistributeDocs();
            MinecraftForge.EVENT_BUS.register((Object)dd);
            FMLCommonHandler.instance().bus().register((Object)dd);
        }
        MechanismsFeature.initialize();
        FzConfig.config.save();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            isMainClientThread.set(true);
        }
        String truth = "factorization.truth";
        FMLInterModComms.sendMessage((String)truth, (String)"AddRecipeCategory", (String)"Lacerator|factorization.oreprocessing.TileEntityGrinder|recipes");
        FMLInterModComms.sendMessage((String)truth, (String)"AddRecipeCategory", (String)"Crystallizer|factorization.oreprocessing.TileEntityCrystallizer|recipes");
        FMLInterModComms.sendMessage((String)truth, (String)"AddRecipeCategory", (String)"Slag Furnace|factorization.oreprocessing.TileEntitySlagFurnace$SlagRecipes|smeltingResults");
        FMLInterModComms.sendMessage((String)truth, (String)"DocVar", (String)"fzverion=0.8.109");
        compatLoader.loadCompat();
        compatLoader.preinit(event);
    }

    void registerSimpleTileEntities() {
        FactoryType.registerTileEntities();
        GameRegistry.registerTileEntity(TileEntityFzNull.class, (String)"fz.null");
        GameRegistry.registerTileEntity(BlockDarkIronOre.Glint.class, (String)"fz.glint");
        EntityRegistry.registerModEntity(TileEntityWrathLamp.RelightTask.class, (String)"fz_relight_task", (int)0, (Object)instance, (int)1, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(ServoMotor.class, (String)"factory_servo", (int)1, (Object)instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(ColossusController.class, (String)"fz_colossal_controller", (int)2, (Object)instance, (int)256, (int)20, (boolean)false);
        EntityRegistry.registerModEntity(EntityPoster.class, (String)"fz_entity_poster", (int)3, (Object)instance, (int)160, (int)Integer.MAX_VALUE, (boolean)false);
        EntityRegistry.registerModEntity(EntityCitizen.class, (String)"fz_entity_citizen", (int)4, (Object)instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityMinecartDayBarrel.class, (String)"fz_minecart_barrel", (int)5, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityLeafBomb.class, (String)"fz_leaf_bomb", (int)6, (Object)this, (int)64, (int)10, (boolean)true);
        EntityRegistry.registerModEntity(StepperEngine.class, (String)"fz_stepper_engine", (int)7, (Object)instance, (int)100, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityGrabController.class, (String)"fz_grab_controller", (int)8, (Object)instance, (int)100, (int)1, (boolean)true);
    }

    @Mod.EventHandler
    public void handleInteractions(FMLInitializationEvent event) {
        registry.sendIMC();
        ColossusFeature.init();
        PatreonRewards.init();
        InspirationManager.init();
        compatLoader.init(event);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        TileEntitySolarBoiler.setupSteam();
        foph.addDictOres();
        registry.addOtherRecipes();
        for (FactoryType ft : FactoryType.values()) {
            ft.getRepresentative();
        }
        proxy.afterLoad();
        compatLoader.postinit(event);
        finished_loading = true;
        Blocks.field_150484_ah.func_149711_c(5.0f).func_149752_b(10.0f);
        Core.validateEnvironment();
    }

    @Mod.EventHandler
    public void registerServerCommands(FMLServerStartingEvent event) {
        isMainServerThread.set(true);
        serverStarted = true;
        if (HammerEnabled.ENABLED) {
            event.registerServerCommand((ICommand)new BuildColossusCommand());
        }
    }

    @Mod.EventHandler
    public void mappingsChanged(FMLModIdMappingEvent event) {
        for (FactoryType ft : FactoryType.values()) {
            TileEntityCommon tec = ft.getRepresentative();
            if (tec == null) continue;
            tec.mappingsChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDeadItems() {
        HashSet<String> hashSet;
        InputStream is = null;
        String dead_list = "/factorization_dead_items";
        try {
            String line;
            HashSet<String> found = new HashSet<String>();
            URL url = this.getClass().getResource("/factorization_dead_items");
            is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                found.add(line);
            }
            hashSet = found;
        }
        catch (IOException e) {
            HashSet<String> hashSet2;
            try {
                Core.logSevere("Failed to load /factorization_dead_items", new Object[0]);
                e.printStackTrace();
                hashSet2 = new HashSet<String>();
            }
            catch (Throwable throwable) {
                FzUtil.closeNoisily("closing /factorization_dead_items", is);
                throw throwable;
            }
            FzUtil.closeNoisily("closing /factorization_dead_items", is);
            return hashSet2;
        }
        FzUtil.closeNoisily("closing /factorization_dead_items", is);
        return hashSet;
    }

    @Mod.EventHandler
    public void abandonDeadItems(FMLMissingMappingsEvent event) {
        Set<String> theDead = this.getDeadItems();
        for (FMLMissingMappingsEvent.MissingMapping missed : event.get()) {
            if (!missed.name.startsWith(texture_dir)) continue;
            if (theDead.contains(missed.name)) {
                missed.ignore();
                continue;
            }
            if (missed.getAction() == FMLMissingMappingsEvent.Action.IGNORE) continue;
            Core.logSevere("Missing mapping: " + missed.name, new Object[0]);
        }
    }

    @Mod.EventHandler
    public void handleFzPrefixStrip(FMLMissingMappingsEvent event) {
        HashMap<String, Item> fixups = Registry.nameCleanup;
        for (FMLMissingMappingsEvent.MissingMapping missed : event.get()) {
            Item target;
            if (missed.type != GameRegistry.Type.ITEM || (target = (Item)fixups.get(missed.name)) == null) continue;
            missed.remap(target);
        }
    }

    @Mod.EventHandler
    public void replaceDerpyNames(FMLMissingMappingsEvent event) {
        Object[][] corrections = new Object[][]{{"factorization:tile.null", Core.registry.factory_block}, {"factorization:FZ factory", Core.registry.factory_block}, {"factorization:tile.factorization.ResourceBlock", Core.registry.resource_block}, {"factorization:FZ resource", Core.registry.resource_block}, {"factorization:tile.lightair", Core.registry.lightair_block}, {"factorization:FZ Lightair", Core.registry.lightair_block}, {"factorization:tile.factorization:darkIronOre", Core.registry.dark_iron_ore}, {"factorization:FZ dark iron ore", Core.registry.dark_iron_ore}, {"factorization:tile.bedrock", Core.registry.fractured_bedrock_block}, {"factorization:FZ fractured bedrock", Core.registry.fractured_bedrock_block}, {"factorization:tile.factorization:darkIronOre", Core.registry.dark_iron_ore}, {"factorization:FZ fractured bedrock", Core.registry.fractured_bedrock_block}};
        HashMap<String, Block> corr = new HashMap<String, Block>();
        for (Object[] pair : corrections) {
            corr.put((String)pair[0], (Block)pair[1]);
        }
        for (FMLMissingMappingsEvent.MissingMapping missed : event.get()) {
            Item it;
            Block value = (Block)corr.get(missed.name);
            if (value == null) continue;
            if (missed.type == GameRegistry.Type.BLOCK) {
                missed.remap(value);
                continue;
            }
            if (missed.type != GameRegistry.Type.ITEM || (it = DataUtil.getItem(value)) == null) continue;
            missed.remap(it);
        }
    }

    ItemStack getExternalItem(String className, String classField, String description) {
        try {
            Class<?> c = Class.forName(className);
            return (ItemStack)c.getField(classField).get(null);
        }
        catch (Exception err) {
            Core.logWarning("Could not get %s (from %s.%s)", description, className, classField);
            return null;
        }
    }

    private void initializeLogging(Logger logger) {
        FZLogger = logger;
        Core.logInfo("This is Factorization %s", version);
    }

    public static void logSevere(String format, Object ... formatParameters) {
        FZLogger.error(String.format(format, formatParameters));
    }

    public static void logWarning(String format, Object ... formatParameters) {
        FZLogger.warn(String.format(format, formatParameters));
    }

    public static void logInfo(String format, Object ... formatParameters) {
        FZLogger.info(String.format(format, formatParameters));
    }

    public static void logFine(String format, Object ... formatParameters) {
        if (dev_environ) {
            FZLogger.info(String.format(format, formatParameters));
        }
    }

    public static void profileStart(String section) {
        if (isMainClientThread.get().booleanValue()) {
            proxy.getProfiler().func_76320_a(section);
        }
    }

    public static void profileEnd() {
        if (isMainClientThread.get().booleanValue()) {
            proxy.getProfiler().func_76319_b();
        }
    }

    public static void profileStartRender(String section) {
        Core.profileStart(modId);
        Core.profileStart(section);
    }

    public static void profileEndRender() {
        Core.profileEnd();
        Core.profileEnd();
    }

    private static void addTranslationHints(String hint_key, List list, String prefix) {
        String hint;
        if (StatCollector.func_94522_b((String)hint_key) && (hint = StatCollector.func_74838_a((String)hint_key)) != null && (hint = hint.trim()).length() > 0) {
            for (String s : hint.split("\\\\n")) {
                list.add(prefix + s);
            }
        }
    }

    public static void brand(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        Item it = is.func_77973_b();
        String name = it.func_77667_c(is);
        Core.addTranslationHints(name + ".hint", list, hintFormat);
        if (player != null && proxy.isClientHoldingShift()) {
            Core.addTranslationHints(name + ".shift", list, shiftFormat);
        }
        ArrayList<String> untranslated = new ArrayList<String>();
        if (it instanceof ItemFactorization) {
            ((ItemFactorization)it).addExtraInformation(is, player, untranslated, verbose);
        }
        String brand = "";
        if (FzConfig.add_branding) {
            brand = brand + name;
        }
        if (cheat) {
            brand = brand + " Cheat mode!";
        }
        if (dev_environ) {
            brand = brand + " Development!";
        }
        if (brand.length() > 0) {
            untranslated.add(EnumChatFormatting.BLUE + brand.trim());
        }
        for (String s : untranslated) {
            list.add(StatCollector.func_74838_a((String)s));
        }
    }

    public static Item tab(Item item, TabType tabType) {
        item.func_77637_a(tabFactorization);
        return item;
    }

    public static Block tab(Block block, TabType tabType) {
        block.func_149647_a(tabFactorization);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon texture(IIconRegister reg, String name) {
        name = name.replace('.', '/');
        return reg.func_94245_a(texture_dir + name);
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modId, name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void bindGuiTexture(String name) {
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        tex.func_110577_a(Core.getResource("textures/gui/" + name + ".png"));
    }

    public static void loadBus(Object obj) {
        FMLCommonHandler.instance().bus().register(obj);
        MinecraftForge.EVENT_BUS.register(obj);
    }

    static {
        factory_rendertype = -1;
        nonte_rendertype = -1;
        finished_loading = false;
        dev_environ = Launch.blackboard != null ? (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") : false;
        cheat = Core.dev_only(false);
        cheat_servo_energy = Core.dev_only(false);
        enable_test_content = dev_environ || Boolean.parseBoolean(System.getProperty("fz.enableTestContent"));
        serverStarted = false;
        checked = false;
        FZLogger = LogManager.getLogger((String)"FZ-init");
        isMainClientThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        isMainServerThread = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        hintFormat = "" + EnumChatFormatting.DARK_PURPLE;
        shiftFormat = "" + EnumChatFormatting.DARK_GRAY + EnumChatFormatting.ITALIC;
        tabFactorization = new CreativeTabs("factorizationTab"){

            public Item func_78016_d() {
                return Core.registry.logicMatrixProgrammer;
            }
        };
        blockAtlas = new ResourceLocation("textures/atlas/blocks.png");
        itemAtlas = new ResourceLocation("textures/atlas/items.png");
    }

    public static enum TabType {
        ART,
        CHARGE,
        OREP,
        SERVOS,
        ROCKETRY,
        TOOLS,
        BLOCKS,
        MATERIALS,
        COLOSSAL,
        ARTIFACT;

    }
}

