/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.shared.ICaptureDrops;
import factorization.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;

public enum DropCaptureHandler {
    CATCHER;

    private ThreadLocal<Capturer> catchers = new ThreadLocal();

    private DropCaptureHandler() {
        Core.loadBus((Object)this);
    }

    public static void startCapture(ICaptureDrops catcher, Coord src, double maxDist) {
        DropCaptureHandler.CATCHER.catchers.set(new Capturer(catcher, src, maxDist * maxDist));
    }

    public static void endCapture() {
        DropCaptureHandler.CATCHER.catchers.set(null);
    }

    void removeInvalids(Collection<ItemStack> drops) {
        Iterator<ItemStack> it = drops.iterator();
        while (it.hasNext()) {
            if (ItemUtil.normalize(it.next()) != null) continue;
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureBlockDrops(BlockEvent.HarvestDropsEvent event) {
        Capturer capturer = this.catchers.get();
        if (capturer == null) {
            return;
        }
        if (!capturer.passes(event.world, event.x, event.y, event.z)) {
            return;
        }
        this.removeInvalids(event.drops);
        if (capturer.net.captureDrops(event.drops)) {
            this.removeInvalids(event.drops);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureMobDrops(LivingDropsEvent event) {
        Capturer capturer = this.catchers.get();
        if (capturer == null) {
            return;
        }
        if (!capturer.passes(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v)) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (EntityItem ent : event.drops) {
            drops.add(ent.func_92059_d());
        }
        this.removeInvalids(drops);
        if (capturer.net.captureDrops(drops)) {
            Iterator it = event.drops.iterator();
            while (it.hasNext()) {
                EntityItem ent;
                ent = (EntityItem)it.next();
                if (ent != null && ItemUtil.normalize(ent.func_92059_d()) != null) continue;
                it.remove();
            }
        }
    }

    private static class Capturer {
        final ICaptureDrops net;
        final Coord src;
        final double distSq;

        private Capturer(ICaptureDrops net, Coord src, double distSq) {
            this.net = net;
            this.src = src;
            this.distSq = distSq;
        }

        boolean passes(World w, double x, double y, double z) {
            if (w != this.src.w) {
                return false;
            }
            double dx = x - (double)this.src.x;
            double dy = y - (double)this.src.y;
            double dz = z - (double)this.src.z;
            return dx + dy + dz <= this.distSq;
        }
    }
}

