/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IEntityMessage;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInByteBuf;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutByteBuf;
import factorization.api.datahelpers.DataOutNBT;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.NetworkFactorization;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.world.World;

public abstract class EntityFz
extends Entity
implements IEntityAdditionalSpawnData,
IEntityMessage {
    public EntityFz(World w) {
        super(w);
    }

    protected final void func_70037_a(NBTTagCompound tag) {
        DataInNBT data = new DataInNBT(tag);
        try {
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected final void func_70014_b(NBTTagCompound tag) {
        DataOutNBT data = new DataOutNBT(tag);
        try {
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void writeSpawnData(ByteBuf buffer) {
        DataOutByteBuf data = new DataOutByteBuf(buffer, Side.SERVER);
        try {
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void readSpawnData(ByteBuf buffer) {
        DataInByteBuf data = new DataInByteBuf(buffer, Side.CLIENT);
        try {
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void syncData() {
        ByteBuf output = Unpooled.buffer();
        try {
            Core.network.prefixEntityPacket(output, this, NetworkFactorization.MessageType.entity_sync);
            this.writeSpawnData(output);
            FMLProxyPacket p = Core.network.entityPacket(output);
            FzNetDispatch.addPacketFrom((Packet)p, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract void putData(DataHelper var1) throws IOException;

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        return false;
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == NetworkFactorization.MessageType.entity_sync) {
            this.putData(new DataInByteBuf(input, Side.CLIENT));
            return true;
        }
        return false;
    }
}

